/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.event.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.RemoveRegistryData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.Event;

public abstract class LoadRegistriesEvent
extends Event {
    RegistryAccess registryAccess;
    Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries;

    public LoadRegistriesEvent(RegistryAccess registryAccess, Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
        this.registryAccess = registryAccess;
        this.registries = registries;
    }

    public RegistryAccess getRegistryAccess() {
        return this.registryAccess;
    }

    public Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> getRegistries() {
        return this.registries;
    }

    public <T extends ConfigData> Collection<Holder<T>> getRegistry(RegistryHolder<T> registry) {
        return this.registries.get(registry.key());
    }

    public <T extends ConfigData> void addRegistryEntry(RegistryHolder<T> key, Holder<T> value) {
        this.registries.put(key.key(), value);
    }

    public <T extends ConfigData> void addRegistryEntry(RegistryHolder<T> key, T value) {
        this.registries.put(key.key(), (Object)Holder.m_205709_(value));
    }

    public <T extends ConfigData> void addRegistryEntries(RegistryHolder<T> key, Collection<Holder<T>> values) {
        this.registries.putAll(key.key(), values);
    }

    public static class Post
    extends LoadRegistriesEvent {
        public Post(RegistryAccess registryAccess, Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries) {
            super(registryAccess, registries);
        }
    }

    public static class Pre
    extends LoadRegistriesEvent {
        private Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals;

        public Pre(RegistryAccess registryAccess, Multimap<ResourceKey<? extends Registry<? extends ConfigData>>, Holder<? extends ConfigData>> registries, Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> removals) {
            super(registryAccess, registries);
        }

        public Multimap<ResourceKey<Registry<? extends ConfigData>>, RemoveRegistryData<?>> getRegistryRemovals() {
            return ImmutableMultimap.copyOf(this.removals);
        }
    }
}

