/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.alcatrazescapee.primalwinter.util.Config;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public class BiomeTempModifier
extends TempModifier {
    public BiomeTempModifier() {
        this(16);
    }

    public BiomeTempModifier(int samples) {
        this.getNBT().m_128405_("Samples", samples);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        int samples = this.getNBT().m_128451_("Samples");
        double worldTemp = 0.0;
        Level level = entity.m_9236_();
        DimensionType dimension = level.m_6042_();
        BlockPos entPos = entity.m_20183_();
        double timeMultiplier = WorldHelper.getTimeMultiplier((LevelAccessor)level);
        Pair<Double, Double> structureTemp = BiomeTempModifier.getStructureTemp(entity.m_9236_(), entity.m_20183_());
        if (structureTemp.getFirst() != null) {
            return temp -> (Double)structureTemp.getFirst();
        }
        DimensionTempData dimTempOverride = ConfigSettings.DIMENSION_TEMPS.get(level.m_9598_()).get(level.m_204156_());
        if (dimTempOverride != null) {
            return temp -> temp + CSMath.blend(dimTempOverride.getMinTemp(), dimTempOverride.getMaxTemp(), timeMultiplier, -1.0, 1.0);
        }
        DimensionTempData dimTempOffset = ConfigSettings.DIMENSION_OFFSETS.get(level.m_9598_()).get(level.m_204156_());
        double dimOffset = dimTempOffset != null ? CSMath.blend(dimTempOffset.getMinTemp(), dimTempOffset.getMaxTemp(), timeMultiplier, -1.0, 1.0) : 0.0;
        int biomeCount = 0;
        for (BlockPos blockPos : dimension.f_63856_() ? WorldHelper.getPositionCube(entPos, (int)Math.sqrt(samples), 10) : WorldHelper.getPositionGrid(entPos, samples, 10)) {
            Holder holder = level.m_7062_().m_204214_(blockPos);
            if (holder.m_203656_(Tags.Biomes.IS_UNDERGROUND) || holder.m_203543_().isEmpty()) continue;
            if (!dimension.f_63856_()) {
                BiomeTempData biomeTempData = ConfigSettings.BIOME_TEMPS.get(level.m_9598_()).get(holder);
                if (CSMath.getIfNotNull(biomeTempData, BiomeTempData::isDisabled, false).booleanValue()) continue;
                double biomeTemp = WorldHelper.getBiomeTemperature((LevelAccessor)level, (Holder<Biome>)holder);
                if (CompatManager.isPrimalWinterLoaded() && biomeTempData != null) {
                    boolean isWinterBiome = Config.INSTANCE.isWinterBiome(((ResourceKey)holder.m_203543_().get()).m_135782_());
                    boolean isWinterDimension = Config.INSTANCE.isWinterDimension(level.m_46472_());
                    if (isWinterBiome && isWinterDimension) {
                        biomeTemp = Math.min(biomeTemp, biomeTemp / 2.0);
                    }
                }
                worldTemp += biomeTemp;
            } else {
                worldTemp += CSMath.averagePair(WorldHelper.getBiomeTemperatureRange((LevelAccessor)level, (Holder<Biome>)holder));
            }
            ++biomeCount;
        }
        worldTemp /= (double)Math.max(1, biomeCount);
        double finalWorldTemp = worldTemp += ((Double)structureTemp.getSecond()).doubleValue();
        return temp -> temp + finalWorldTemp + dimOffset;
    }

    public static Pair<Double, Double> getStructureTemp(Level level, BlockPos pos) {
        Optional<Holder<Structure>> structure = WorldHelper.getStructureAt(level, pos);
        if (structure.isEmpty()) {
            return Pair.of(null, (Object)0.0);
        }
        Double strucTemp = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_TEMPS.get(level.m_9598_()).get(structure.get()), StructureTempData::getTemperature, null);
        Double strucOffset = CSMath.getIfNotNull(ConfigSettings.STRUCTURE_OFFSETS.get(level.m_9598_()).get(structure.get()), StructureTempData::getTemperature, 0.0);
        return Pair.of((Object)strucTemp, (Object)strucOffset);
    }
}

