/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.renderer.block.IceboxBlockEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.item.SoulSpringLampRenderer;
import com.momosoftworks.coldsweat.client.renderer.layer.ChameleonArmorLayer;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonBootsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonChestplateModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonHelmetModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.ChameleonLeggingsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.EmptyArmorModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatBootsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatChestplateModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatHelmetModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.GoatLeggingsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.HoglinBootsModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.HoglinChestplateModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.HoglinHelmetModel;
import com.momosoftworks.coldsweat.client.renderer.model.armor.HoglinLeggingsModel;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RegisterModels {
    public static HoglinHelmetModel<?> HOGLIN_HELMET_MODEL = null;
    public static HoglinChestplateModel<?> HOGLIN_CHESTPLATE_MODEL = null;
    public static HoglinLeggingsModel<?> HOGLIN_LEGGINGS_MODEL = null;
    public static HoglinBootsModel<?> HOGLIN_BOOTS_MODEL = null;
    public static GoatHelmetModel<?> GOAT_HELMET_MODEL = null;
    public static GoatChestplateModel<?> GOAT_CHESTPLATE_MODEL = null;
    public static GoatLeggingsModel<?> GOAT_LEGGINGS_MODEL = null;
    public static GoatBootsModel<?> GOAT_BOOTS_MODEL = null;
    public static ChameleonHelmetModel<?> CHAMELEON_HELMET_MODEL = null;
    public static ChameleonChestplateModel<?> CHAMELEON_CHESTPLATE_MODEL = null;
    public static ChameleonLeggingsModel<?> CHAMELEON_LEGGINGS_MODEL = null;
    public static ChameleonBootsModel<?> CHAMELEON_BOOTS_MODEL = null;
    public static EmptyArmorModel<?> EMPTY_ARMOR_MODEL = null;
    public static BlockEntityWithoutLevelRenderer SOULSPRING_LAMP_RENDERER = null;
    private static Map<ResourceLocation, BakedModel> BAKED_MODELS = new HashMap<ResourceLocation, BakedModel>();

    public static void checkForInitModels() {
        if (HOGLIN_HELMET_MODEL != null) {
            return;
        }
        EntityModelSet mcModels = Minecraft.m_91087_().m_167973_();
        HOGLIN_HELMET_MODEL = new HoglinHelmetModel(mcModels.m_171103_(HoglinHelmetModel.LAYER_LOCATION));
        HOGLIN_CHESTPLATE_MODEL = new HoglinChestplateModel(mcModels.m_171103_(HoglinChestplateModel.LAYER_LOCATION));
        HOGLIN_BOOTS_MODEL = new HoglinBootsModel(mcModels.m_171103_(HoglinBootsModel.LAYER_LOCATION));
        HOGLIN_LEGGINGS_MODEL = new HoglinLeggingsModel(mcModels.m_171103_(HoglinLeggingsModel.LAYER_LOCATION));
        GOAT_HELMET_MODEL = new GoatHelmetModel(mcModels.m_171103_(GoatHelmetModel.LAYER_LOCATION));
        GOAT_CHESTPLATE_MODEL = new GoatChestplateModel(mcModels.m_171103_(GoatChestplateModel.LAYER_LOCATION));
        GOAT_LEGGINGS_MODEL = new GoatLeggingsModel(mcModels.m_171103_(GoatLeggingsModel.LAYER_LOCATION));
        GOAT_BOOTS_MODEL = new GoatBootsModel(mcModels.m_171103_(GoatBootsModel.LAYER_LOCATION));
        CHAMELEON_HELMET_MODEL = new ChameleonHelmetModel(mcModels.m_171103_(ChameleonHelmetModel.LAYER_LOCATION));
        CHAMELEON_CHESTPLATE_MODEL = new ChameleonChestplateModel(mcModels.m_171103_(ChameleonChestplateModel.LAYER_LOCATION));
        CHAMELEON_LEGGINGS_MODEL = new ChameleonLeggingsModel(mcModels.m_171103_(ChameleonLeggingsModel.LAYER_LOCATION));
        CHAMELEON_BOOTS_MODEL = new ChameleonBootsModel(mcModels.m_171103_(ChameleonBootsModel.LAYER_LOCATION));
        EMPTY_ARMOR_MODEL = new EmptyArmorModel(mcModels.m_171103_(EmptyArmorModel.LAYER_LOCATION));
        SOULSPRING_LAMP_RENDERER = new SoulSpringLampRenderer(Minecraft.m_91087_().m_167982_(), mcModels);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ChameleonModel.LAYER_LOCATION, ChameleonModel::createBodyLayer);
        event.registerLayerDefinition(HoglinHelmetModel.LAYER_LOCATION, HoglinHelmetModel::createArmorLayer);
        event.registerLayerDefinition(HoglinChestplateModel.LAYER_LOCATION, HoglinChestplateModel::createArmorLayer);
        event.registerLayerDefinition(HoglinBootsModel.LAYER_LOCATION, HoglinBootsModel::createArmorLayer);
        event.registerLayerDefinition(HoglinLeggingsModel.LAYER_LOCATION, HoglinLeggingsModel::createArmorLayer);
        event.registerLayerDefinition(GoatHelmetModel.LAYER_LOCATION, GoatHelmetModel::createArmorLayer);
        event.registerLayerDefinition(GoatChestplateModel.LAYER_LOCATION, GoatChestplateModel::createArmorLayer);
        event.registerLayerDefinition(GoatLeggingsModel.LAYER_LOCATION, GoatLeggingsModel::createArmorLayer);
        event.registerLayerDefinition(GoatBootsModel.LAYER_LOCATION, GoatBootsModel::createArmorLayer);
        event.registerLayerDefinition(ChameleonHelmetModel.LAYER_LOCATION, ChameleonHelmetModel::createArmorLayer);
        event.registerLayerDefinition(ChameleonChestplateModel.LAYER_LOCATION, ChameleonChestplateModel::createArmorLayer);
        event.registerLayerDefinition(ChameleonLeggingsModel.LAYER_LOCATION, ChameleonLeggingsModel::createArmorLayer);
        event.registerLayerDefinition(ChameleonBootsModel.LAYER_LOCATION, ChameleonBootsModel::createArmorLayer);
        event.registerLayerDefinition(EmptyArmorModel.LAYER_LOCATION, EmptyArmorModel::createArmorLayer);
        event.registerLayerDefinition(IceboxBlockEntityRenderer.LAYER_LOCATION, IceboxBlockEntityRenderer::createBodyLayer);
        event.registerLayerDefinition(SoulSpringLampRenderer.LAYER_LOCATION, SoulSpringLampRenderer::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityInit.CHAMELEON.get(), ChameleonEntityRenderer::new);
    }

    @SubscribeEvent
    public static void overrideModels(ModelEvent.ModifyBakingResult event) {
        BAKED_MODELS = event.getModels();
        RegisterModels.forceCustomItemModel(ModItems.SOULSPRING_LAMP, ConfigSettings.ANIMATED_SOULSPRING_LAMP_MODEL);
    }

    public static Map.Entry<ResourceLocation, BakedModel> getBakedModel(Item item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        return BAKED_MODELS.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).toString().contains(itemID.toString())).findFirst().orElse(null);
    }

    public static void forceCustomItemModel(Item item, final Supplier<Boolean> custom) {
        BakedModel bakedModel;
        Optional<Map.Entry<ResourceLocation, BakedModel>> modelOpt = Optional.ofNullable(RegisterModels.getBakedModel(item));
        if (modelOpt.isPresent() && (bakedModel = modelOpt.get().getValue()) instanceof SimpleBakedModel) {
            SimpleBakedModel model = (SimpleBakedModel)bakedModel;
            RandomSource random = RandomSource.m_216327_();
            List unculledFaces = model.m_213637_(null, null, random);
            Map culledFaces = Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, (Object)model.m_213637_(null, dir, random))).collect(() -> new EnumMap(Direction.class), (map, pair) -> map.put((Direction)pair.getFirst(), (List)pair.getSecond()), EnumMap::putAll);
            SimpleBakedModel customModel = new SimpleBakedModel(unculledFaces, culledFaces, model.m_7541_(), model.m_7547_(), model.m_7539_(), model.m_6160_(), model.m_7442_(), model.m_7343_(), new RenderTypeGroup(null, null, null)){

                public boolean m_7521_() {
                    return (Boolean)custom.get();
                }
            };
            BAKED_MODELS.put(modelOpt.get().getKey(), (BakedModel)customModel);
        }
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        PlayerRenderer playerRenderer;
        Minecraft mc = Minecraft.m_91087_();
        LivingEntityRenderer livingEntityRenderer = event.getSkin("default");
        if (livingEntityRenderer instanceof PlayerRenderer) {
            playerRenderer = (PlayerRenderer)livingEntityRenderer;
            playerRenderer.m_115326_(new ChameleonArmorLayer(playerRenderer, mc.m_91304_()));
        }
        if ((livingEntityRenderer = event.getSkin("slim")) instanceof PlayerRenderer) {
            playerRenderer = (PlayerRenderer)livingEntityRenderer;
            playerRenderer.m_115326_(new ChameleonArmorLayer(playerRenderer, mc.m_91304_()));
        }
    }
}

