/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import oshi.util.tuples.Triplet;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = new ResourceLocation("cold_sweat", "textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vector2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vector2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;
    private static int LEFT_DROPLETS = 0;
    private static int RIGHT_DROPLETS = 0;
    private static final int MAX_DROPLETS = 5;

    @SubscribeEvent
    public static void updateSkyBrightness(TickEvent.ClientTickEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_46465_();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        float alpha;
        Vector2f pos;
        int i;
        boolean justExitedWater;
        LocalPlayer player;
        if (!ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float frametime = mc.m_91297_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        boolean paused = mc.m_91104_();
        int uiScale = (Integer)mc.f_91066_.m_231928_().m_231551_();
        if (uiScale == 0) {
            uiScale = mc.m_91268_().m_85385_(0, mc.m_91390_());
        }
        if ((player = mc.f_91074_) == null) {
            return;
        }
        BlockPos playerPos = BlockPos.m_274446_((Position)player.m_146892_());
        float playerYVelocity = (float)(player.m_20182_().f_82480_ - player.f_19791_);
        boolean isSubmerged = player.getEyeInFluidType() == Fluids.f_76193_.getFluidType();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        float tempMult = (float)CSMath.blend(0.3, 6.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add((Vector2fc)new Vector2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.f_91074_, Temperature.Trait.WORLD, WaterTempModifier.class).map(arg_0 -> WetnessRenderer.lambda$onRenderOverlay$0((Player)player, arg_0)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater && !player.m_5833_()) {
            for (int i2 = 0; i2 < 10; ++i2) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)(Math.sin(i2 * 4 + player.f_19797_) / 2.0 + 0.5) * (float)screenHeight;
                newDrop.position.x = (float)((double)i2 / 10.0) * (float)screenWidth;
                WATER_DROPS.add(newDrop);
                int streakLength = (int)(Math.random() * 5.0) + 5;
                int x = (int)newDrop.position.x;
                int y = (int)newDrop.position.y;
                for (int j = 1; j < streakLength; ++j) {
                    TRAILS.add((Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i(x, y - j), (Object)Float.valueOf(CSMath.blend(newDrop.alpha * 0.8f, 0.0f, j, 1.0f, streakLength)), (Object)(newDrop.size / 2)));
                }
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.m_6084_() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        int waterColor = BiomeColors.m_108811_((BlockAndTintGetter)player.m_9236_(), (BlockPos)playerPos);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172829_);
        GuiGraphics graphics = event.getGuiGraphics();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        int blockLight = player.m_9236_().m_5518_().m_75814_(LightLayer.BLOCK).m_7768_(playerPos);
        int skyLight = player.m_9236_().m_5518_().m_75814_(LightLayer.SKY).m_7768_(playerPos);
        int combinedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        for (i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            pos = drop.position;
            alpha = drop.alpha;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            int scaledSize = drop.size / uiScale * 3;
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale), (int)pos.y, scaledSize, scaledSize, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    float dropMoveFromPlayerLook = -(player.f_20885_ - player.f_20886_) / 20.0f;
                    dropMoveFromPlayerLook = (float)CSMath.shrink(dropMoveFromPlayerLook, 0.5);
                    drop.xVelocity = (float)CSMath.maxAbs((double)dropMoveFromPlayerLook * (Math.random() * 0.2), drop.xVelocity);
                    drop.xVelocity /= 1.0f + 0.6f * frametime;
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)pos.y;
                    if (!isSubmerged) {
                        drop.position.add((Vector2fc)new Vector2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div((float)uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(pos.y - (float)oldY)); ++j) {
                        TRAILS.add((Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i((int)pos.x, oldY + j), (Object)Float.valueOf(alpha), (Object)drop.size));
                    }
                }
                if (pos.x < -20.0f) {
                    pos.x = screenWidth + 20;
                } else if (pos.x > (float)(screenWidth + 20)) {
                    pos.x = -20.0f;
                }
                if (!(pos.y > (float)screenHeight)) continue;
                WetnessRenderer.removeDrop(drop);
                --i;
                continue;
            }
            WetnessRenderer.removeDrop(drop);
            --i;
        }
        tesselator.m_85914_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP_TRAIL);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        for (i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vector2i, Float, Integer> trail = TRAILS.get(i);
            pos = (Vector2i)trail.getA();
            alpha = ((Float)trail.getB()).floatValue();
            int size = (Integer)trail.getC();
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, buffer, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale * 4.0f), pos.y, size / uiScale * 3, 1, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (paused) continue;
                alpha = wetness <= 0.0 ? (alpha -= 0.08f * frametime) : (alpha -= 0.045f * frametime * tempMult / 2.0f);
                TRAILS.set(i, (Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i(pos.x, pos.y), (Object)Float.valueOf(alpha), (Object)size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        tesselator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.m_91087_().f_91063_.m_109154_().m_109891_();
        poseStack.m_85849_();
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        int x;
        Droplet.Side side;
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        Droplet.Side side2 = side = Math.random() < 0.5 ? Droplet.Side.LEFT : Droplet.Side.RIGHT;
        if (WetnessRenderer.getDropletsOnSide(side) > WetnessRenderer.getDropletsOnSide(side.opposite())) {
            side = side.opposite();
        }
        int xOffset = (int)(Math.random() * (double)screenWidth / 4.0);
        int n = x = side == Droplet.Side.LEFT ? xOffset : screenWidth - xOffset;
        if (side == Droplet.Side.LEFT) {
            ++LEFT_DROPLETS;
        } else {
            ++RIGHT_DROPLETS;
        }
        return new Droplet(new Vector2f((float)x, (float)(-size)), 1.0f, size, side);
    }

    private static void removeDrop(Droplet droplet) {
        if (droplet.side == Droplet.Side.LEFT) {
            --LEFT_DROPLETS;
        } else {
            --RIGHT_DROPLETS;
        }
        WATER_DROPS.remove(droplet);
    }

    private static int getDropletsOnSide(Droplet.Side side) {
        return side == Droplet.Side.LEFT ? LEFT_DROPLETS : RIGHT_DROPLETS;
    }

    private static void renderQuadDirect(PoseStack poseStack, BufferBuilder buffer, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float alpha, int lightLevel, int waterColor) {
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Matrix4f lastPose = poseStack.m_85850_().m_252922_();
        buffer.m_252986_(lastPose, (float)x, (float)y, 0.0f).m_7421_(u, v).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_252986_(lastPose, (float)x, (float)(y + height), 0.0f).m_7421_(u, v + vHeight).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_252986_(lastPose, (float)(x + width), (float)(y + height), 0.0f).m_7421_(u + uWidth, v + vHeight).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
        buffer.m_252986_(lastPose, (float)(x + width), (float)y, 0.0f).m_7421_(u + uWidth, v).m_85950_(red, green, blue, alpha).m_85969_(lightLevel).m_5752_();
    }

    private static /* synthetic */ Double lambda$onRenderOverlay$0(Player player, WaterTempModifier mod) {
        return CSMath.blend(0.0, 1.0, Math.abs(mod.getTemperature()), 0.0, mod.getMaxTemperature((LivingEntity)player));
    }

    protected static class Droplet {
        public Vector2f position;
        public float alpha;
        public int size;
        public float yMotion = WetnessRenderer.getRandomVelocity(Minecraft.m_91087_().m_91296_() / 5.0f);
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;
        public Side side;

        public Droplet(Vector2f position, float alpha, int size, Side side) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
            this.side = side;
        }

        public static enum Side {
            LEFT,
            RIGHT;


            public Side opposite() {
                return this == LEFT ? RIGHT : LEFT;
            }
        }
    }
}

