/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data.edible;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class BiomeSearchingEdible
extends Edible {
    private final BiPredicate<Level, Holder<Biome>> biomePredicate;

    public BiomeSearchingEdible(BiPredicate<Level, Holder<Biome>> biomePredicate) {
        this.biomePredicate = biomePredicate;
    }

    @Override
    public Edible.Result onEaten(Chameleon entity, ItemEntity item) {
        if (!entity.m_9236_().f_46443_) {
            entity.setSearching(true);
            Thread searchThread = new Thread(null, () -> {
                Pair biomePair = ((ServerLevel)entity.m_9236_()).m_215069_(biome -> this.biomePredicate.test(entity.m_9236_(), (Holder<Biome>)biome), entity.m_20183_(), 2000, 32, 64);
                if (biomePair != null) {
                    TaskScheduler.scheduleServer(() -> {
                        entity.setTrackingPos((BlockPos)biomePair.getFirst());
                        WorldHelper.playEntitySound(ModSounds.CHAMELEON_FIND, (Entity)entity, entity.m_5720_(), 1.2f, entity.m_6100_());
                        WorldHelper.spawnParticleBatch(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                } else {
                    TaskScheduler.scheduleServer(() -> {
                        WorldHelper.spawnParticleBatch(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                }
            }, "(Cold Sweat) Chameleon search thread");
            searchThread.start();
        }
        return Edible.Result.FAIL;
    }

    @Override
    public boolean shouldEat(Chameleon entity, ItemEntity item) {
        return item.m_19749_() != null && entity.isPlayerTrusted(item.m_19749_().m_20148_());
    }
}

