/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.common.insulation.InsulationTickEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ItemBreakEvent;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.common.capability.insulation.ItemInsulationCap;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProcessEquipmentInsulation {
    @SubscribeEvent
    public static void applyArmorInsulation(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.f_19797_ % 20 == 0 && !player.m_9236_().f_46443_) {
                Advancement advancement;
                AtomicInteger fullyInsulatedSlots = new AtomicInteger(0);
                FastMap<String, Double> armorInsulation = new FastMap<String, Double>();
                double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
                double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                for (ItemStack armorStack : player.m_6168_()) {
                    if (!(armorStack.m_41720_() instanceof ArmorItem)) continue;
                    ProcessEquipmentInsulation.applyBuiltinArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp);
                    ProcessEquipmentInsulation.applySewnArmorInsulation(armorInsulation, armorStack, player, worldTemp, minTemp, maxTemp, fullyInsulatedSlots);
                    double armorAmount = armorStack.m_41638_(LivingEntity.m_147233_((ItemStack)armorStack)).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.f_22284_)).map(entry -> ((AttributeModifier)entry.getValue()).m_22218_()).mapToDouble(Double::doubleValue).sum();
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_protection", Math.min(armorAmount, 20.0));
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_protection", Math.min(armorAmount, 20.0));
                }
                for (ItemStack curio : CompatManager.Curios.getCurios((LivingEntity)player)) {
                    for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)curio.m_41720_())) {
                        if (!insulator.test((Entity)player, curio)) continue;
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_curios", insulator.getCold());
                        ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_curios", insulator.getHeat());
                    }
                }
                InsulationTickEvent insulationEvent = new InsulationTickEvent(player, armorInsulation);
                MinecraftForge.EVENT_BUS.post((Event)insulationEvent);
                if (!insulationEvent.isCanceled()) {
                    double cold = insulationEvent.getProperty("cold");
                    double heat = insulationEvent.getProperty("heat");
                    if (cold > 0.0 || heat > 0.0) {
                        Temperature.addOrReplaceModifier((LivingEntity)player, ((TempModifier)new ArmorInsulationTempModifier(cold, heat).tickRate(20)).expires(20), Temperature.Trait.RATE, Placement.Duplicates.BY_CLASS);
                    }
                }
                if (fullyInsulatedSlots.get() >= 4 && serverPlayer.m_20194_() != null && (advancement = serverPlayer.m_20194_().m_129889_().m_136041_(new ResourceLocation("cold_sweat:full_insulation"))) != null) {
                    serverPlayer.m_8960_().m_135988_(advancement, "requirement");
                }
            }
        }
    }

    private static void applyBuiltinArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, Player player, double worldTemp, double minTemp, double maxTemp) {
        ArrayList armorInsulators = new ArrayList(ConfigSettings.INSULATING_ARMORS.get().get((Object)armorStack.m_41720_()));
        if (!armorInsulators.isEmpty()) {
            Double newFactor = null;
            for (InsulatorData armorInsulator : armorInsulators) {
                if (!armorInsulator.test((Entity)player, armorStack)) continue;
                List<Insulation> insulations = Insulation.deepCopy(armorInsulator.insulation());
                for (Insulation insul : insulations) {
                    if (insul instanceof AdaptiveInsulation) {
                        AdaptiveInsulation adaptive = (AdaptiveInsulation)insul;
                        if (newFactor == null) {
                            AdaptiveInsulation.readFactorFromArmor(adaptive, armorStack);
                            newFactor = AdaptiveInsulation.calculateChange(adaptive, worldTemp, minTemp, maxTemp);
                            AdaptiveInsulation.setFactorToArmor(armorStack, newFactor);
                        }
                        adaptive.setFactor(newFactor);
                    }
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_armor", insul.getCold());
                    ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_armor", insul.getHeat());
                }
            }
        }
    }

    private static void applySewnArmorInsulation(Map<String, Double> armorInsulation, ItemStack armorStack, Player player, double worldTemp, double minTemp, double maxTemp, AtomicInteger fullyInsulatedSlots) {
        Object t;
        LazyOptional<IInsulatableCap> iCap = ItemInsulationManager.getInsulationCap(armorStack);
        List<InsulatorData> insulators = ItemInsulationManager.getEffectiveAppliedInsulation(armorStack, (LivingEntity)player);
        for (InsulatorData insulator : insulators) {
            for (Insulation insulation : insulator.insulation()) {
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "cold_insulators", insulation.getCold());
                ProcessEquipmentInsulation.mapAdd(armorInsulation, "heat_insulators", insulation.getHeat());
            }
        }
        if ((armorInsulation.getOrDefault("cold_insulators", 0.0) + armorInsulation.getOrDefault("heat_insulators", 0.0)) / 2.0 >= (double)ItemInsulationManager.getInsulationSlots(armorStack)) {
            fullyInsulatedSlots.incrementAndGet();
        }
        if (iCap.resolve().isPresent() && (t = iCap.resolve().get()) instanceof ItemInsulationCap) {
            ItemInsulationCap cap = (ItemInsulationCap)t;
            cap.calcAdaptiveInsulation(worldTemp, minTemp, maxTemp);
            ProcessEquipmentInsulation.popExtraInsulation(cap, armorStack, player);
        }
    }

    private static void mapAdd(Map<String, Double> map, String key, double value) {
        map.put(key, map.getOrDefault(key, 0.0) + value);
    }

    private static void popExtraInsulation(ItemInsulationCap cap, ItemStack armorStack, Player player) {
        List<Pair<ItemStack, List<InsulatorData>>> totalInsulation = cap.getInsulation();
        int filledInsulationSlots = totalInsulation.size();
        if (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            WorldHelper.playEntitySound(SoundEvents.f_12016_, (Entity)player, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        while (filledInsulationSlots > ItemInsulationManager.getInsulationSlots(armorStack)) {
            ItemStack removedItem = cap.removeInsulationItem((ItemStack)totalInsulation.get(totalInsulation.size() - 1).getFirst());
            WorldHelper.entityDropItem((Entity)player, removedItem);
            --filledInsulationSlots;
        }
    }

    @SubscribeEvent
    public static void onArmorBroken(ItemBreakEvent event) {
        ItemStack stack = event.getItemStack();
        LivingEntity entity = event.getEntity();
        if (ItemInsulationManager.isInsulatable(stack)) {
            ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
                for (Pair<ItemStack, List<InsulatorData>> insulation : cap.getInsulation()) {
                    ItemEntity itemEntity = WorldHelper.entityDropItem((Entity)entity, (ItemStack)insulation.getFirst());
                    itemEntity.m_32010_(8);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        if (source.m_276093_(DamageTypes.f_268434_) && event.getEntity().m_6844_(EquipmentSlot.FEET).m_150930_(ModItems.HOGLIN_BOOTS)) {
            event.setCanceled(true);
        }
    }
}

