/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat;

import com.anthonyhilyard.iceberg.util.Tooltips;
import com.mojang.datafixers.util.Either;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.init.FetchSeasonsModsEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.LoadRegistriesEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.compat.SereneSeasonsTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.create.ColdSweatDisplaySources;
import com.momosoftworks.coldsweat.compat.create.ColdSweatPonderPlugin;
import com.momosoftworks.coldsweat.compat.curios.EquipableCurio;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.tag.ModInsulatorTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import dev.ghen.thirst.content.purity.ContainerWithPurity;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.foundation.common.event.RegisterThirstValueEvent;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import glitchcore.event.EventManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import sereneseasons.season.SeasonHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObject;

@Mod.EventBusSubscriber
public class CompatManager {
    private static final boolean BOP_LOADED = CompatManager.modLoaded("biomesoplenty");
    private static final boolean SERENE_SEASONS_LOADED = CompatManager.modLoaded("sereneseasons", "9.1.0.0", "9.3.0.26");
    private static final boolean CURIOS_LOADED = CompatManager.modLoaded("curios");
    private static final boolean SPIRIT_LOADED = CompatManager.modLoaded("spirit");
    private static final boolean BYG_LOADED = CompatManager.modLoaded("byg");
    private static final boolean BWG_LOADED = CompatManager.modLoaded("biomeswevegone");
    private static final boolean CREATE_LOADED = CompatManager.modLoaded("create", "6.0.0");
    private static final boolean ATMOSPHERIC_LOADED = CompatManager.modLoaded("atmospheric");
    private static final boolean ENVIRONMENTAL_LOADED = CompatManager.modLoaded("environmental");
    private static final boolean TERRALITH_LOADED = CompatManager.modLoaded("terralith");
    private static final boolean WEATHER_LOADED = CompatManager.modLoaded("weather2");
    private static final boolean WYTHERS_LOADED = CompatManager.modLoaded("wwoo");
    private static final boolean TOOLTIPS_LOADED = CompatManager.modLoaded("legendarytooltips");
    private static final boolean PRIMAL_WINTER_LOADED = CompatManager.modLoaded("primalwinter");
    private static final boolean THIRST_LOADED = CompatManager.modLoaded("thirst", "1.20.1-1.3.14");
    private static final boolean ICEBERG_LOADED = CompatManager.modLoaded("iceberg");
    private static final boolean SPOILED_LOADED = CompatManager.modLoaded("spoiled", "2.2.0");
    private static final boolean SUPPLEMENTARIES_LOADED = CompatManager.modLoaded("supplementaries");
    private static final boolean VALKYRIEN_SKIES_LOADED = CompatManager.modLoaded("valkyrienskies");
    private static final boolean TOUGH_AS_NAILS_LOADED = CompatManager.modLoaded("toughasnails");
    private static final boolean TWILIGHT_FOREST_LOADED = CompatManager.modLoaded("twilightforest");
    private static final boolean AETHER_LOADED = CompatManager.modLoaded("aether");
    private static final boolean REGIONS_UNEXPLORED_LOADED = CompatManager.modLoaded("regions_unexplored");
    private static final boolean AD_ASTRA_LOADED = CompatManager.modLoaded("ad_astra");
    private static final List<String> SEASONS_MODS = new ArrayList<String>();
    public static boolean USING_BACKTANK = false;

    public static boolean modLoaded(String modID, String minVersion, String maxVersion) {
        List<String> disabledMods = ConfigSettings.DISABLED_MOD_COMPAT.get();
        if (disabledMods.contains(modID)) {
            return false;
        }
        ModFileInfo mod = FMLLoader.getLoadingModList().getModFileById(modID);
        if (mod == null) {
            return false;
        }
        ArtifactVersion version = ((IModInfo)mod.getMods().get(0)).getVersion();
        if (!minVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or higher for compat to be enabled! (found {})", (Object)modID, (Object)minVersion, (Object)version);
            return false;
        }
        if (!maxVersion.isEmpty() && version.compareTo((Object)new DefaultArtifactVersion(maxVersion)) > 0) {
            ColdSweat.LOGGER.error("Cold Sweat requires {} {} or lower for compat to be enabled! (found {})", (Object)modID, (Object)maxVersion, (Object)version);
            return false;
        }
        return true;
    }

    public static boolean modLoaded(String modID, String minVersion) {
        return CompatManager.modLoaded(modID, minVersion, "");
    }

    public static boolean modLoaded(String modID) {
        return CompatManager.modLoaded(modID, "");
    }

    private static List<String> fetchSeasonsMods() {
        if (SEASONS_MODS.isEmpty()) {
            FetchSeasonsModsEvent event = new FetchSeasonsModsEvent();
            if (SERENE_SEASONS_LOADED) {
                event.addSeasonsMod("sereneseasons");
            }
            MinecraftForge.EVENT_BUS.post((Event)event);
            SEASONS_MODS.addAll(event.getSeasonsMods());
        }
        return SEASONS_MODS;
    }

    public static List<String> getSeasonsMods() {
        return CompatManager.fetchSeasonsMods();
    }

    public static boolean isBiomesOPlentyLoaded() {
        return BOP_LOADED;
    }

    public static boolean isSereneSeasonsLoaded() {
        return SERENE_SEASONS_LOADED;
    }

    public static boolean isCuriosLoaded() {
        return CURIOS_LOADED;
    }

    public static boolean isSpiritLoaded() {
        return SPIRIT_LOADED;
    }

    public static boolean isBiomesYoullGoLoaded() {
        return BYG_LOADED;
    }

    public static boolean isBiomesWeveGoneLoaded() {
        return BWG_LOADED;
    }

    public static boolean isCreateLoaded() {
        return CREATE_LOADED;
    }

    public static boolean isAtmosphericLoaded() {
        return ATMOSPHERIC_LOADED;
    }

    public static boolean isEnvironmentalLoaded() {
        return ENVIRONMENTAL_LOADED;
    }

    public static boolean isTerralithLoaded() {
        return TERRALITH_LOADED;
    }

    public static boolean isWeather2Loaded() {
        return WEATHER_LOADED;
    }

    public static boolean isWythersLoaded() {
        return WYTHERS_LOADED;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return TOOLTIPS_LOADED;
    }

    public static boolean isPrimalWinterLoaded() {
        return PRIMAL_WINTER_LOADED;
    }

    public static boolean isThirstLoaded() {
        return THIRST_LOADED;
    }

    public static boolean isIcebergLoaded() {
        return ICEBERG_LOADED;
    }

    public static boolean isSpoiledLoaded() {
        return SPOILED_LOADED;
    }

    public static boolean isSupplementariesLoaded() {
        return SUPPLEMENTARIES_LOADED;
    }

    public static boolean isValkyrienSkiesLoaded() {
        return VALKYRIEN_SKIES_LOADED;
    }

    public static boolean isToughAsNailsLoaded() {
        return TOUGH_AS_NAILS_LOADED;
    }

    public static boolean isTwilightForestLoaded() {
        return TWILIGHT_FOREST_LOADED;
    }

    public static boolean isAetherLoaded() {
        return AETHER_LOADED;
    }

    public static boolean isRegionsUnexploredLoaded() {
        return REGIONS_UNEXPLORED_LOADED;
    }

    public static boolean isAdAstraLoaded() {
        return AD_ASTRA_LOADED;
    }

    public static void registerEventHandlers() {
        if (CURIOS_LOADED) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void onCurioChange(CurioChangeEvent event) {
                    EntityTempManager.updateInsulationAttributeModifiers(event.getEntity(), event.getFrom(), event.getTo());
                }
            });
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void registerEquipableCurios(LoadRegistriesEvent.Pre event) {
                    for (Item item : ForgeRegistries.ITEMS.tags().getTag(ModItemTags.EQUIPABLE_CURIOS)) {
                        if (CuriosApi.getCurio((ItemStack)item.m_7968_()).isPresent()) continue;
                        CuriosApi.registerCurio((Item)item, (ICurioItem)new EquipableCurio());
                    }
                }
            });
        }
        if (THIRST_LOADED) {
            MinecraftForge.EVENT_BUS.register(new Object(){

                @SubscribeEvent
                public void registerThirstItems(RegisterThirstValueEvent event) {
                    event.addDrink(ModItems.FILLED_WATERSKIN, 6, 3);
                    event.addContainer(new ContainerWithPurity(ModItems.WATERSKIN.m_7968_(), ModItems.FILLED_WATERSKIN.m_7968_()));
                }
            });
        }
        if (SERENE_SEASONS_LOADED) {
            new Object(){

                public void registerListener() {
                    EventManager.addListener(event -> {
                        for (Player player : event.getLevel().m_6907_()) {
                            Temperature.getModifier((LivingEntity)player, Temperature.Trait.WORLD, SereneSeasonsTempModifier.class).ifPresent(mod -> mod.update(mod.getLastInput(Temperature.Trait.WORLD), (LivingEntity)player, Temperature.Trait.WORLD));
                        }
                    });
                }
            }.registerListener();
        }
        if (AD_ASTRA_LOADED) {
            ColdSweat.MOD_BUS.register(new Object(){

                @SubscribeEvent
                public void onFetchSeasonsMods(FMLLoadCompleteEvent event) {
                    AdAstraConfig.disableTemperature = true;
                }
            });
        }
    }

    public static void invokeRegistries(IEventBus bus) {
        if (CompatManager.isCreateLoaded()) {
            ColdSweatDisplaySources.DISPLAY_SOURCES.register(bus);
        }
    }

    @SubscribeEvent
    public static void drainCreateBacktank(TickEvent.PlayerTickEvent event) {
        double maxTemp;
        double minTemp;
        Player player = event.player;
        if (!CompatManager.isCreateLoaded()) {
            return;
        }
        double worldTemp = Temperature.get((LivingEntity)player, Temperature.Trait.WORLD);
        if (CSMath.betweenExclusive(worldTemp, minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT), maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT))) {
            return;
        }
        if (worldTemp < minTemp && !ConfigSettings.COLD_DRAINS_BACKTANK.get().booleanValue()) {
            return;
        }
        if (worldTemp > maxTemp && !ConfigSettings.HEAT_DRAINS_BACKTANK.get().booleanValue()) {
            return;
        }
        ItemStack backTank = player.m_6844_(EquipmentSlot.CHEST);
        if (USING_BACKTANK && player.m_9236_().f_46443_) {
            player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAllWithAir((LivingEntity)player).stream().map(BacktankUtil::getAir).reduce(Float.valueOf(0.0f), Float::sum).floatValue()) - 1);
        }
        if (player.f_19797_ % 20 != 0 || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!player.m_7500_() && !player.m_20077_() && backTank.m_41720_() instanceof BacktankItem) {
            List<InsulatorData> drainingInsulators = ConfigHelper.getTaggedConfigsFor(backTank.m_41720_(), ModInsulatorTags.DRAINS_BACKTANK, ConfigSettings.INSULATING_ARMORS.get(), player.m_9236_().m_9598_());
            if (drainingInsulators.stream().noneMatch(insulator -> insulator.test((Entity)player, backTank))) {
                return;
            }
            if (player.m_9236_().f_46443_) {
                USING_BACKTANK = true;
            }
            if (CSMath.getIfNotNull(backTank.m_41783_(), tag -> tag.m_128451_("Air"), 0) > 0) {
                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backTank, (float)1.0f);
                if (player.m_9236_().f_46443_) {
                    player.getPersistentData().m_128405_("VisualBacktankAir", Math.round(BacktankUtil.getAllWithAir((LivingEntity)player).stream().map(BacktankUtil::getAir).reduce(Float.valueOf(0.0f), Float::sum).floatValue()));
                }
            }
        } else if (player.m_9236_().f_46443_) {
            USING_BACKTANK = false;
        }
    }

    @Mod.EventBusSubscriber(modid="cold_sweat", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void setupModEvents(FMLCommonSetupEvent event) {
        }

        @SubscribeEvent
        public static void setupModClientEvents(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                if (CompatManager.isCreateLoaded()) {
                    new Object(){

                        public void registerPonderPlugin() {
                            PonderIndex.addPlugin((PonderPlugin)new ColdSweatPonderPlugin());
                        }
                    }.registerPonderPlugin();
                }
            });
        }
    }

    public static abstract class Valkyrien {
        public static Vec3 translateToShipCoords(Vec3 pos, Ship ship) {
            if (ship != null) {
                Vector3d posVec = VectorConversionsMCKt.toJOML((Vec3)pos);
                ship.getWorldToShip().transformPosition(posVec);
                return VectorConversionsMCKt.toMinecraft((Vector3dc)posVec);
            }
            return pos;
        }

        public static AABB transformIfShipPos(Level level, AABB aabb) {
            AtomicReference<AABB> translated = new AtomicReference<AABB>(aabb);
            VSGameUtilsKt.transformFromWorldToNearbyShipsAndWorld((Level)level, (AABB)aabb, translated::set);
            return translated.get();
        }

        public static BlockPos transformIfShipPos(Level level, BlockPos pos) {
            if (VALKYRIEN_SKIES_LOADED) {
                List shipTransforms = VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)1.0);
                if (shipTransforms.isEmpty()) {
                    return pos;
                }
                Vector3d shipCoords = (Vector3d)shipTransforms.get(0);
                return BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)shipCoords));
            }
            return pos;
        }
    }

    public static abstract class LegendaryTooltips {
        public static int getTooltipStartIndex(List<Either<FormattedText, TooltipComponent>> tooltip) {
            if (CompatManager.isIcebergLoaded()) {
                int index = CSMath.getIndexOf(tooltip, element -> element.right().map(component -> component instanceof Tooltips.TitleBreakComponent).orElse(false));
                if (index == -1) {
                    return 0;
                }
                return index;
            }
            return 0;
        }
    }

    public static abstract class Thirst {
        public static boolean hasWaterPurity(ItemStack stack) {
            if (THIRST_LOADED) {
                return WaterPurity.hasPurity((ItemStack)stack);
            }
            return false;
        }

        public static int getWaterPurity(ItemStack stack) {
            if (THIRST_LOADED) {
                return WaterPurity.getPurity((ItemStack)stack);
            }
            return 0;
        }

        public static ItemStack setWaterPurity(ItemStack stack, int purity) {
            if (THIRST_LOADED) {
                return WaterPurity.addPurity((ItemStack)stack, (int)purity);
            }
            return stack;
        }

        public static ItemStack setWaterPurity(ItemStack item, BlockPos pos, Level level) {
            if (THIRST_LOADED) {
                return WaterPurity.addPurity((ItemStack)item, (BlockPos)pos, (Level)level);
            }
            return item;
        }
    }

    public static abstract class SereneSeasons {
        public static boolean isColdEnoughToSnow(Level level, BlockPos pos) {
            return SERENE_SEASONS_LOADED && SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (Holder)level.m_204166_(pos), (BlockPos)pos);
        }
    }

    public static abstract class Weather2 {
        public static boolean isRainstormAt(Level level, BlockPos pos) {
            if (WEATHER_LOADED) {
                WeatherManagerServer weatherManager = ServerTickHandler.getWeatherManagerFor((ResourceKey)level.m_46472_());
                if (weatherManager == null) {
                    return false;
                }
                StormObject rainStorm = weatherManager.getClosestStormAny(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), 250.0);
                if (rainStorm == null) {
                    return false;
                }
                if (WorldHelper.canSeeSky((LevelAccessor)level, pos, 60) && rainStorm.isPrecipitating() && rainStorm.levelTemperature > 0.0f && Math.sqrt(Math.pow((double)pos.m_123341_() - rainStorm.pos.f_82479_, 2.0) + Math.pow((double)pos.m_123341_() - rainStorm.pos.f_82479_, 2.0)) < (double)rainStorm.getSize()) {
                    return true;
                }
            }
            return false;
        }

        public static Object getClosestStorm(Level level, BlockPos pos) {
            if (WEATHER_LOADED) {
                WeatherManagerServer weatherManager = ServerTickHandler.getWeatherManagerFor((ResourceKey)level.m_46472_());
                if (weatherManager == null) {
                    return null;
                }
                double distance = Double.POSITIVE_INFINITY;
                WeatherObject closestStorm = null;
                for (WeatherObject stormObject : weatherManager.getStormObjects()) {
                    double newDistance = stormObject.pos.m_82554_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                    if (!(newDistance < distance)) continue;
                    distance = newDistance;
                    closestStorm = stormObject;
                }
                return closestStorm;
            }
            return null;
        }
    }

    public static abstract class Create {
        public static boolean isFluidPipe(BlockState state) {
            return CompatManager.isCreateLoaded() && (state.m_60734_() instanceof FluidPipeBlock || state.m_60734_() instanceof GlassFluidPipeBlock || state.m_60734_() instanceof EncasedPipeBlock);
        }
    }

    public static abstract class Curios {
        public static boolean hasCurio(Player player, Item curio) {
            return CURIOS_LOADED && CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(cap -> cap.findFirstCurio(curio)).map(Optional::isPresent).orElse(false) != false;
        }

        public static List<ItemStack> getCurios(LivingEntity entity) {
            if (!CURIOS_LOADED) {
                return new ArrayList<ItemStack>();
            }
            return entity.getCapability(CuriosCapability.INVENTORY).map(ICuriosItemHandler::getEquippedCurios).map(stacks -> {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    list.add(stacks.getStackInSlot(i));
                }
                return list;
            }).orElse(new ArrayList());
        }
    }
}

