/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.common.event.IceBreakingEvents;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class MixinIce {

    @Mixin(value={BlockBehaviour.class})
    public static class AddDrops {
        @Inject(method={"getDrops"}, at={@At(value="HEAD")}, cancellable=true)
        private void addDrops(BlockState state, LootParams.Builder params, CallbackInfoReturnable<List<ItemStack>> cir) {
            ItemStack stack = (ItemStack)params.m_287159_(LootContextParams.f_81463_);
            if (stack == null) {
                return;
            }
            if (ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue() && IceBreakingEvents.isModifiableIceBlock(state) && stack.m_41735_(state)) {
                cir.setReturnValue(ModLootTables.getBlockDropsLootTable(params.m_287258_(), BlockPos.m_274446_((Position)((Position)params.m_287261_(LootContextParams.f_81460_))), state, CSMath.getIfNotNull((Entity)params.m_287159_(LootContextParams.f_81455_), entity -> entity instanceof Player ? (Player)entity : null, null), IceBreakingEvents.getLootTableForIce(state)));
            }
        }
    }

    @Mixin(value={IceBlock.class})
    public static class NoWaterOnBreak {
        @Inject(method={"playerDestroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;")}, cancellable=true)
        private void noWater(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack item, CallbackInfo ci) {
            if (ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
                ci.cancel();
            }
        }
    }
}

