/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Decoder;
import com.momosoftworks.coldsweat.compat.CompatManager;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RegistryDataLoader.class})
public class MixinRegistration {
    @Inject(method={"loadRegistryContents"}, at={@At(value="INVOKE", target="Lcom/google/gson/JsonParser;parseReader(Ljava/io/Reader;)Lcom/google/gson/JsonElement;", shift=At.Shift.BY, by=2)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static <E> void loadRegistryContents(RegistryOps.RegistryInfoLookup pLookup, ResourceManager pManager, ResourceKey<? extends Registry<E>> pRegistryKey, WritableRegistry<E> pRegistry, Decoder<E> pDecoder, Map<ResourceKey<?>, Exception> pExceptions, CallbackInfo ci, String s, FileToIdConverter filetoidconverter, RegistryOps<JsonElement> registryops, Iterator iterator, Map.Entry<ResourceLocation, Resource> entry, ResourceLocation resourcelocation, ResourceKey<E> resourcekey, Resource resource, Reader reader, JsonElement jsonelement) {
        JsonObject json;
        if (pRegistryKey.m_135782_().m_135827_().equals("cold_sweat") && (json = jsonelement.getAsJsonObject()).has("required_mods")) {
            JsonObject condition;
            JsonArray requiredMods = new JsonArray();
            JsonArray excludedMods = new JsonArray();
            JsonElement requiredModField = json.get("required_mods");
            if (requiredModField.isJsonArray()) {
                requiredMods = requiredModField.getAsJsonArray();
            } else {
                JsonObject requiredModCompound = requiredModField.getAsJsonObject();
                if (requiredModCompound.has("require")) {
                    requiredMods = requiredModCompound.getAsJsonArray("require");
                }
                if (requiredModCompound.has("exclude")) {
                    excludedMods = requiredModCompound.getAsJsonArray("exclude");
                }
            }
            JsonArray conditions = json.getAsJsonArray("forge:conditions");
            if (conditions == null) {
                conditions = new JsonArray();
                json.add("forge:conditions", (JsonElement)conditions);
            }
            for (JsonElement requiredMod : requiredMods) {
                condition = new JsonObject();
                condition.addProperty("type", "forge:mod_loaded");
                if (!CompatManager.modLoaded(requiredMod.getAsString())) {
                    condition.addProperty("modid", "cs_impossible");
                    conditions.add((JsonElement)condition);
                    return;
                }
                condition.addProperty("modid", requiredMod.getAsString());
                conditions.add((JsonElement)condition);
            }
            for (JsonElement excludedMod : excludedMods) {
                if (!CompatManager.modLoaded(excludedMod.getAsString())) continue;
                condition = new JsonObject();
                condition.addProperty("type", "forge:mod_loaded");
                condition.addProperty("modid", "cs_impossible");
                conditions.add((JsonElement)condition);
                return;
            }
        }
    }
}

