/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.util.world;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.BlockDataUpdateMessage;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.core.network.message.PlayEntityAttachedSoundMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncForgeDataMessage;
import com.momosoftworks.coldsweat.data.tag.ModBiomeTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyEntity;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.DynamicHolder;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public abstract class WorldHelper {
    static Map<ResourceKey<Level>, DummyPlayer> DUMMY_PLAYERS = new HashMap<ResourceKey<Level>, DummyPlayer>();
    static Map<ResourceKey<Level>, DummyEntity> DUMMY_ENTITIES = new HashMap<ResourceKey<Level>, DummyEntity>();
    static Map<ResourceKey<Level>, Map<BlockPos, TempSnapshot>> TEMPERATURE_CHECKS = new FastMap<ResourceKey<Level>, Map<BlockPos, TempSnapshot>>();

    @SubscribeEvent
    public static void clearCachesOnUnload(ServerStoppedEvent event) {
        DUMMY_PLAYERS.clear();
        DUMMY_ENTITIES.clear();
        TEMPERATURE_CHECKS.clear();
    }

    public static int getHeight(BlockPos pos, Level level, Heightmap.Types heightmap) {
        int minHeight = level.m_141937_();
        int maxHeight = level.m_151558_();
        int seaLevel = level.m_5736_();
        if (!level.m_46749_(pos)) {
            return seaLevel;
        }
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
        if (chunk == null) {
            return seaLevel;
        }
        if (level.m_5776_()) {
            int y = level.m_151558_();
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            mutable.m_142448_(CSMath.clamp(mutable.m_123342_(), minHeight, maxHeight));
            BlockState state = null;
            while (state == null || !heightmap.m_64299_().test(state)) {
                if (!CSMath.betweenInclusive(mutable.m_123342_(), minHeight, maxHeight)) {
                    return seaLevel;
                }
                mutable.m_142448_(y);
                state = chunk.m_8055_((BlockPos)mutable);
                --y;
            }
            return y;
        }
        return chunk.m_5885_(heightmap, pos.m_123341_(), pos.m_123343_());
    }

    public static int getHeight(BlockPos pos, Level level) {
        return WorldHelper.getHeight(pos, level, Heightmap.Types.MOTION_BLOCKING);
    }

    public static int getAverageHeight(BlockPos pos, Level level, Heightmap.Types ... heightmaps) {
        int totalHeight = 0;
        for (Heightmap.Types heightmap : heightmaps) {
            totalHeight += WorldHelper.getHeight(pos, level, heightmap);
        }
        return totalHeight / heightmaps.length;
    }

    public static List<BlockPos> getPositionGrid(BlockPos pos, int samples, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int sampleRoot = (int)Math.sqrt(samples);
        int radius = sampleRoot * interval / 2;
        for (int x = -radius; x < radius; x += interval) {
            for (int z = -radius; z < radius; z += interval) {
                posList.add(pos.m_7918_(x + interval / 2, 0, z + interval / 2));
            }
        }
        return posList;
    }

    public static List<BlockPos> getPositionCube(BlockPos pos, int size, int interval) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int radius = size * interval / 2;
        int halfInterval = interval / 2;
        for (int x = -radius + halfInterval; x < radius + halfInterval; x += interval) {
            for (int y = -radius + halfInterval; y < radius + halfInterval; y += interval) {
                for (int z = -radius + halfInterval; z < radius + halfInterval; z += interval) {
                    posList.add(pos.m_7918_(x, y, z));
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canSeeSky(LevelAccessor level, BlockPos pos, int maxDistance) {
        BlockPos.MutableBlockPos pos2 = pos.m_122032_();
        int iterations = Math.min(maxDistance, level.m_151558_() - pos.m_123342_());
        ChunkAccess chunk = WorldHelper.getChunk(level, pos);
        if (chunk == null) {
            return true;
        }
        for (int i = 0; i < iterations; ++i) {
            try {
                BlockState state = chunk.m_8055_((BlockPos)pos2);
                if (ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().contains(state.m_60734_())) {
                    boolean bl = false;
                    return bl;
                }
                if (state.m_60795_() || state.m_278721_() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(state.m_60734_())) continue;
                VoxelShape shape = state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82749_());
                if (shape.equals(Shapes.m_83144_())) {
                    boolean bl = false;
                    return bl;
                }
                if (!WorldHelper.isFullSide(CSMath.flattenShape(Direction.Axis.Y, shape), Direction.UP)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                pos2.m_122184_(0, 1, 0);
            }
        }
        return true;
    }

    public static boolean isSpreadBlocked(LevelAccessor level, BlockState state, BlockPos pos, Direction fromDir, Direction toDir) {
        Block block = state.m_60734_();
        if (state.m_60795_() || ConfigSettings.THERMAL_SOURCE_SPREAD_WHITELIST.get().contains(block)) {
            return false;
        }
        if (ConfigSettings.THERMAL_SOURCE_SPREAD_BLACKLIST.get().contains(block)) {
            return true;
        }
        VoxelShape shape = state.m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_());
        if (shape.equals(Shapes.m_83144_())) {
            return true;
        }
        return WorldHelper.isFullSide(shape.m_83263_(fromDir.m_122424_()), fromDir) || WorldHelper.isFullSide(CSMath.flattenShape(toDir.m_122434_(), shape), toDir);
    }

    public static boolean isFullSide(VoxelShape shape, Direction dir) {
        if (shape.m_83281_()) {
            return false;
        }
        double[] area = new double[1];
        switch (dir.m_122434_()) {
            case X: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(y2 - y1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Y: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(z2 - z1);
                });
                break;
            }
            case Z: {
                shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
                    area[0] = area[0] + Math.abs(x2 - x1) * Math.abs(y2 - y1);
                });
            }
        }
        return area[0] >= 1.0;
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, BlockPos pos) {
        return WorldHelper.getChunk(level, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, ChunkPos pos) {
        return WorldHelper.getChunk(level, pos.f_45578_, pos.f_45579_);
    }

    @Nullable
    public static ChunkAccess getChunk(LevelAccessor level, int chunkX, int chunkZ) {
        return level.m_7726_().m_7131_(chunkX, chunkZ);
    }

    public static LevelChunkSection getChunkSection(ChunkAccess chunk, int y) {
        LevelChunkSection[] sections = chunk.m_7103_();
        return sections[CSMath.clamp(chunk.m_151564_(y), 0, sections.length - 1)];
    }

    public static Optional<Holder<Structure>> getStructureAt(Level level, BlockPos pos) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (level.m_46749_(pos)) break block7;
            }
            return Optional.empty();
        }
        StructureManager structureManager = serverLevel.m_215010_();
        Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
        for (Map.Entry entry : structureManager.m_220522_(pos).entrySet()) {
            Structure structure = (Structure)entry.getKey();
            LongSet strucCoordinates = (LongSet)entry.getValue();
            LongIterator longIterator = strucCoordinates.iterator();
            while (longIterator.hasNext()) {
                long coordinate = (Long)longIterator.next();
                SectionPos sectionpos = SectionPos.m_123196_((ChunkPos)new ChunkPos(coordinate), (int)level.m_151560_());
                StructureStart structurestart = structureManager.m_220512_(sectionpos, structure, (StructureAccess)level.m_46819_(sectionpos.m_123170_(), sectionpos.m_123222_(), ChunkStatus.f_62315_));
                if (structurestart == null || !structurestart.m_73603_() || !structureManager.m_220497_(pos, structurestart)) continue;
                ResourceLocation structureId = structureRegistry.m_7981_((Object)structure);
                if (structureId == null) {
                    return Optional.empty();
                }
                return structureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureId));
            }
        }
        return Optional.empty();
    }

    public static void playEntitySound(SoundEvent sound, Entity entity, SoundSource source, float volume, float pitch) {
        if (!entity.m_20067_()) {
            if (entity.m_9236_().f_46443_) {
                ClientOnlyHelper.playEntitySound(sound, source, volume, pitch, entity);
            } else {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new PlayEntityAttachedSoundMessage(sound, source, volume, pitch, entity.m_19879_()));
            }
        }
    }

    public static boolean isInWater(Entity entity) {
        BlockPos pos = entity.m_20183_();
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)entity.m_9236_(), pos);
        if (chunk == null) {
            return false;
        }
        return entity.m_20069_() || chunk.m_8055_(pos).m_60734_() == Blocks.f_50628_;
    }

    public static boolean isRainingAt(Level level, BlockPos pos) {
        return (level.m_46471_() && ((Biome)level.m_7062_().m_204214_(pos).m_203334_()).m_264600_(pos) == Biome.Precipitation.RAIN || CompatManager.Weather2.isRainstormAt(level, pos)) && WorldHelper.canSeeSky((LevelAccessor)level, pos.m_7494_(), level.m_151558_()) && !CompatManager.SereneSeasons.isColdEnoughToSnow(level, pos);
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, ChunkAccess chunk, Map<BlockPos, BlockState> stateCache, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        block5: {
            if (from.equals((Object)to)) break block5;
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = BlockPos.m_274446_((Position)from).m_122032_();
            ChunkAccess workingChunk = chunk;
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                block6: {
                    BlockState state;
                    block7: {
                        Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                        if (BlockPos.m_274446_((Position)vec).equals((Object)pos)) break block6;
                        pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                        state = stateCache.get(pos);
                        if (state != null) break block7;
                        if (workingChunk == null || !workingChunk.m_7697_().equals((Object)new ChunkPos((BlockPos)pos))) {
                            workingChunk = WorldHelper.getChunk((LevelAccessor)level, (BlockPos)pos);
                        }
                        if (workingChunk == null) break block6;
                        state = workingChunk.m_8055_((BlockPos)pos);
                        stateCache.put(pos.m_7949_(), state);
                    }
                    if (!state.m_60795_() && --maxHits <= 0) break;
                    rayTracer.accept(state, (BlockPos)pos);
                }
                ++i;
            }
        }
    }

    public static void forBlocksInRay(Vec3 from, Vec3 to, Level level, BiConsumer<BlockState, BlockPos> rayTracer, int maxHits) {
        WorldHelper.forBlocksInRay(from, to, level, WorldHelper.getChunk((LevelAccessor)level, BlockPos.m_274446_((Position)from)), new HashMap<BlockPos, BlockState>(), rayTracer, maxHits);
    }

    public static Entity raycastEntity(Vec3 from, Vec3 to, Level level, Predicate<Entity> filter) {
        if (!from.equals((Object)to)) {
            Vec3 ray = to.m_82546_(from);
            Vec3 normalRay = ray.m_82541_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i < ray.m_82553_()) {
                Vec3 vec = from.m_82549_(normalRay.m_82490_((double)i));
                if (!BlockPos.m_274446_((Position)vec).equals((Object)pos)) {
                    pos.m_122169_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                    List entities = level.m_6443_(Entity.class, new AABB((BlockPos)pos), filter);
                    if (!entities.isEmpty()) {
                        return (Entity)entities.get(0);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void spawnParticle(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (!level.f_46443_) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x, y, z, xSpeed, ySpeed, zSpeed));
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)WorldHelper.getChunk((LevelAccessor)level, (int)x >> 4, (int)z >> 4)), (Object)particles);
        } else {
            level.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public static void spawnParticleBatch(Level level, ParticleOptions particle, double x, double y, double z, double xSpread, double ySpread, double zSpread, double count, double speed) {
        Random rand = new Random();
        if (!level.f_46443_) {
            ParticleBatchMessage particles = new ParticleBatchMessage();
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_().m_82490_(speed);
                particles.addParticle(particle, new ParticleBatchMessage.ParticlePlacement(x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.f_82479_, vec.f_82480_, vec.f_82481_));
                ++i;
            }
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)particles);
        } else {
            int i = 0;
            while ((double)i < count) {
                Vec3 vec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_().m_82490_(speed);
                level.m_7106_(particle, x + xSpread - rand.nextDouble() * (xSpread * 2.0), y + ySpread - rand.nextDouble() * (ySpread * 2.0), z + zSpread - rand.nextDouble() * (zSpread * 2.0), vec.f_82479_, vec.f_82480_, vec.f_82481_);
                ++i;
            }
        }
    }

    public static ItemEntity dropItem(Level level, BlockPos pos, ItemStack stack) {
        return WorldHelper.dropItem(level, pos, stack, 6000);
    }

    public static ItemEntity dropItem(Level level, BlockPos pos, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        item.m_20256_(item.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
        Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"f_31985_");
        age.setAccessible(true);
        try {
            age.set(item, 6000 - lifeTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack) {
        return WorldHelper.entityDropItem(entity, stack, 6000);
    }

    public static ItemEntity entityDropItem(Entity entity, ItemStack stack, int lifeTime) {
        Random rand = new Random();
        ItemEntity item = entity.m_5552_(stack, entity.m_20206_());
        if (item != null) {
            item.m_20256_(item.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            item.lifespan = lifeTime;
        }
        return item;
    }

    public static Vec3 getClosestPointOnEntity(LivingEntity entity, Vec3 pos) {
        double playerRadius = entity.m_20205_() / 2.0f;
        return new Vec3(CSMath.clamp(pos.f_82479_, entity.m_20185_() - playerRadius, entity.m_20185_() + playerRadius), CSMath.clamp(pos.f_82480_, entity.m_20186_(), entity.m_20186_() + (double)entity.m_20206_()), CSMath.clamp(pos.f_82481_, entity.m_20189_() - playerRadius, entity.m_20189_() + playerRadius));
    }

    public static void syncEntityForgeData(Entity entity, ServerPlayer destination) {
        ColdSweatPacketHandler.INSTANCE.send(destination != null ? PacketDistributor.PLAYER.with(() -> destination) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncForgeDataMessage(entity));
    }

    public static void syncBlockEntityData(BlockEntity be) {
        if (be.m_58904_() == null || be.m_58904_().f_46443_) {
            return;
        }
        ChunkAccess ichunk = WorldHelper.getChunk((LevelAccessor)be.m_58904_(), be.m_58899_());
        if (ichunk instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)ichunk;
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new BlockDataUpdateMessage(be));
        }
    }

    public static ServerLevel getServerLevel(Level level) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(level.m_46472_());
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(LevelAccessor level, Holder<Biome> biome) {
        return WorldHelper.getBiomeTemperatureRange(level.m_9598_(), biome);
    }

    public static Pair<Double, Double> getBiomeTemperatureRange(RegistryAccess registryAccess, Holder<Biome> biome) {
        double variance = 1.0f / Math.max(1.0f, 2.0f + ((Biome)biome.m_203334_()).getModifiedClimateSettings().f_47683_() * 2.0f);
        double baseTemp = ((Biome)biome.m_203334_()).m_47554_();
        Pair biomeTemp = Optional.ofNullable(ConfigSettings.BIOME_TEMPS.get(registryAccess).get(biome)).filter(data -> !data.isDisabled()).map(data -> Pair.of((Object)data.minTemp(), (Object)data.maxTemp())).orElse(Pair.of((Object)(baseTemp - variance), (Object)(baseTemp + variance)));
        Pair configOffset = Optional.ofNullable(ConfigSettings.BIOME_OFFSETS.get(registryAccess).get(biome)).filter(data -> !data.isDisabled()).map(data -> Pair.of((Object)data.minTemp(), (Object)data.maxTemp())).orElse(Pair.of((Object)0.0, (Object)0.0));
        return CSMath.addPairs(Pair.of((Object)((Double)biomeTemp.getFirst()), (Object)((Double)biomeTemp.getSecond())), Pair.of((Object)((Double)configOffset.getFirst()), (Object)((Double)configOffset.getSecond())));
    }

    public static double getBiomeTemperature(LevelAccessor level, Holder<Biome> biome) {
        Pair<Double, Double> temps = WorldHelper.getBiomeTemperatureRange(level, biome);
        return CSMath.blend((Double)temps.getFirst(), (Double)temps.getSecond(), WorldHelper.getTimeMultiplier(level), -1.0, 1.0);
    }

    public static double getTimeMultiplier(LevelAccessor level) {
        return Math.sin((double)level.m_8044_() / 3819.7186342054883);
    }

    public static double getRoughTemperatureAt(Level level, BlockPos pos, int flags) {
        boolean sensitive = (flags & 1) != 0;
        boolean forceUpdate = (flags & 2) != 0;
        Map snapshots = TEMPERATURE_CHECKS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), dim -> new HashMap());
        int tickSpeedMultiplier = 1 + level.m_46469_().m_46215_(GameRules.f_46143_) / 20;
        BlockPos segment = new BlockPos(pos.m_123341_() >> 3, pos.m_123342_() >> 3, pos.m_123343_() >> 3);
        if (!forceUpdate) {
            long gameTime;
            int interval = sensitive ? 200 : 1000;
            TempSnapshot snapshot = (TempSnapshot)snapshots.get(segment);
            if (snapshot != null && (gameTime = level.m_46467_()) - snapshot.timestamp < (long)(interval / tickSpeedMultiplier)) {
                return snapshot.temperature();
            }
        }
        DummyEntity dummy = WorldHelper.getDummyEntity(level);
        dummy.m_146884_(CSMath.getCenterPos(pos));
        ArrayList<TempModifier> modifiers = new ArrayList<TempModifier>(Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD));
        Pair<Integer, Integer> maxCoolingHeating = WorldHelper.getInsulationAt(level, pos, 2);
        if ((Integer)maxCoolingHeating.getFirst() > 0) {
            modifiers.add(new FrigidnessTempModifier((Integer)maxCoolingHeating.getFirst()));
        }
        if ((Integer)maxCoolingHeating.getSecond() > 0) {
            modifiers.add(new WarmthTempModifier((Integer)maxCoolingHeating.getSecond()));
        }
        double tempAt = Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, modifiers, true);
        snapshots.put(segment, new TempSnapshot(level.m_46467_(), tempAt));
        return tempAt;
    }

    public static double getRoughTemperatureAt(Level level, BlockPos pos) {
        return WorldHelper.getRoughTemperatureAt(level, pos, 0);
    }

    public static double getBlockTemperature(Level level, BlockState block) {
        Collection<BlockTemp> blockTemps = BlockTempRegistry.getBlockTempsFor(block);
        for (BlockTemp blockTemp : blockTemps) {
            if (!blockTemp.isValid(level, BlockPos.f_121853_, block)) continue;
            return blockTemp.getTemperature(level, null, block, BlockPos.f_121853_, 0.0);
        }
        return 0.0;
    }

    public static double getTemperatureAt(Level level, BlockPos pos) {
        DummyPlayer dummy = WorldHelper.getDummyPlayer(level);
        dummy.m_146884_(CSMath.getCenterPos(pos));
        ArrayList<TempModifier> modifiers = new ArrayList<TempModifier>(Temperature.getModifiers((LivingEntity)dummy, Temperature.Trait.WORLD));
        Pair<Integer, Integer> maxCoolingHeating = WorldHelper.getInsulationAt(level, pos, 2);
        if ((Integer)maxCoolingHeating.getFirst() > 0) {
            modifiers.add(new FrigidnessTempModifier((Integer)maxCoolingHeating.getFirst()));
        }
        if ((Integer)maxCoolingHeating.getSecond() > 0) {
            modifiers.add(new WarmthTempModifier((Integer)maxCoolingHeating.getSecond()));
        }
        return Temperature.apply(0.0, (LivingEntity)dummy, Temperature.Trait.WORLD, modifiers, true);
    }

    public static DummyPlayer getDummyPlayer(Level level) {
        ResourceKey dimension = level.m_46472_();
        DummyPlayer dummy = DUMMY_PLAYERS.get(dimension);
        if (dummy == null || dummy.m_9236_() != level) {
            dummy = new DummyPlayer(level);
            DUMMY_PLAYERS.put((ResourceKey<Level>)dimension, dummy);
            Map<Temperature.Trait, List<TempModifier>> defaultModifiers = EntityTempManager.gatherTempModifiers((LivingEntity)dummy);
            defaultModifiers.get((Object)Temperature.Trait.WORLD).forEach(mod -> mod.tickRate(1));
            Temperature.getModifiers((LivingEntity)dummy).putAll(defaultModifiers);
        }
        return dummy;
    }

    public static DummyEntity getDummyEntity(Level level) {
        ResourceKey dimension = level.m_46472_();
        DummyEntity dummy = DUMMY_ENTITIES.get(dimension);
        if (dummy == null || dummy.m_9236_() != level) {
            dummy = new DummyEntity(level);
            DUMMY_ENTITIES.put((ResourceKey<Level>)dimension, dummy);
            Map<Temperature.Trait, List<TempModifier>> defaultModifiers = EntityTempManager.gatherTempModifiers((LivingEntity)dummy);
            defaultModifiers.get((Object)Temperature.Trait.WORLD).forEach(mod -> mod.tickRate(1));
            Temperature.getModifiers((LivingEntity)dummy).putAll(defaultModifiers);
        }
        return dummy;
    }

    public Map<ResourceKey<Level>, DummyPlayer> getDummyPlayers() {
        return DUMMY_PLAYERS;
    }

    public Map<ResourceKey<Level>, DummyEntity> getDummyEntities() {
        return DUMMY_ENTITIES;
    }

    public Map<ResourceKey<Level>, Map<BlockPos, TempSnapshot>> getWorldTempCache() {
        return TEMPERATURE_CHECKS;
    }

    public static boolean allAdjacentBlocksMatch(BlockPos pos, Predicate<BlockPos> predicate) {
        BlockPos.MutableBlockPos pos2 = pos.m_122032_();
        for (int i = 0; i < Direction.values().length; ++i) {
            BlockPos.MutableBlockPos offset = pos2.m_122159_((Vec3i)pos, Direction.values()[i]);
            if (predicate.test((BlockPos)offset)) continue;
            return false;
        }
        return true;
    }

    public static BlockState waterlog(BlockState state, Level level, BlockPos pos) {
        boolean waterAt = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterAt));
    }

    public static boolean shouldFreeze(LevelAccessor levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.m_123342_() >= levelReader.m_141937_() && pos.m_123342_() < levelReader.m_151558_() && levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            Holder biome = levelReader.m_204166_(pos);
            if (biome.m_203656_(ModBiomeTags.HAS_HOT_WATER)) {
                return false;
            }
            if (WorldHelper.surroundedByBlock(levelReader, pos, Blocks.f_50126_)) {
                return true;
            }
            DynamicHolder<Boolean> freezingTemp = DynamicHolder.create(null, () -> WorldHelper.getRoughTemperatureAt((Level)serverLevel, pos) < 0.0);
            if (!mustBeAtEdge) {
                return freezingTemp.get();
            }
            return !WorldHelper.surroundedByFluid(levelReader, pos, (Fluid)Fluids.f_76193_) && freezingTemp.get() != false;
        }
        return false;
    }

    public static boolean shouldMelt(LevelAccessor levelReader, BlockPos pos, boolean mustBeAtEdge) {
        if (pos.m_123342_() >= levelReader.m_141937_() && pos.m_123342_() < levelReader.m_151558_() && levelReader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelReader;
            Holder biome = levelReader.m_204166_(pos);
            if (biome.m_203656_(ModBiomeTags.HAS_HOT_WATER)) {
                return true;
            }
            if (mustBeAtEdge && WorldHelper.surroundedByBlock(levelReader, pos, Blocks.f_50126_)) {
                return false;
            }
            return WorldHelper.getRoughTemperatureAt((Level)serverLevel, pos) >= 0.0;
        }
        return false;
    }

    public static boolean surroundedByBlock(LevelAccessor level, BlockPos pos, Block block) {
        return level.m_8055_(pos.m_122012_()).m_60713_(block) && level.m_8055_(pos.m_122019_()).m_60713_(block) && level.m_8055_(pos.m_122029_()).m_60713_(block) && level.m_8055_(pos.m_122024_()).m_60713_(block);
    }

    public static boolean surroundedByFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        return level.m_8055_(pos.m_122012_()).m_60819_().m_192917_(fluid) && level.m_8055_(pos.m_122019_()).m_60819_().m_192917_(fluid) && level.m_8055_(pos.m_122029_()).m_60819_().m_192917_(fluid) && level.m_8055_(pos.m_122024_()).m_60819_().m_192917_(fluid);
    }

    public static boolean nextToSoulFire(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos pos2 = pos.m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState state = level.m_8055_((BlockPos)pos2.m_122154_((Vec3i)pos, x, y, z));
                    if (!state.m_60713_(Blocks.f_50084_) && (!state.m_60713_(Blocks.f_50684_) || !((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Pair<Integer, Integer> getInsulationAt(Level level, BlockPos pos, int chunkRadius) {
        int maxCoolingLevel = 0;
        int maxHeatingLevel = 0;
        ChunkPos chunkPos = new ChunkPos(pos);
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, chunkPos.f_45578_ + x, chunkPos.f_45579_ + z);
                if (chunk == null) continue;
                for (BlockPos bePos : chunk.m_5928_()) {
                    HearthBlockEntity hearth;
                    BlockEntity be = chunk.m_7702_(bePos);
                    if (!(be instanceof HearthBlockEntity) || !(hearth = (HearthBlockEntity)be).getPathLookup().containsKey((Object)pos)) continue;
                    maxCoolingLevel = Math.max(maxCoolingLevel, hearth.getCoolingLevel());
                    maxHeatingLevel = Math.max(maxHeatingLevel, hearth.getHeatingLevel());
                }
            }
        }
        return Pair.of((Object)maxCoolingLevel, (Object)maxHeatingLevel);
    }

    public static List<BlockPos> getOccupiedPositions(AABB bb) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int minX = (int)Math.floor(bb.f_82288_);
        int minY = (int)Math.floor(bb.f_82289_);
        int minZ = (int)Math.floor(bb.f_82290_);
        int maxX = (int)Math.ceil(bb.f_82291_);
        int maxY = (int)Math.ceil(bb.f_82292_);
        int maxZ = (int)Math.ceil(bb.f_82293_);
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        return positions;
    }

    public record TempSnapshot(long timestamp, double temperature) {
    }
}

