/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.event.vanilla.RenderHeartEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeHeartsEffect
extends TempEffect {
    private static final ResourceLocation HEART_TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/hearts_frozen.png");
    private int heartIndex = 0;

    public FreezeHeartsEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderHeart(RenderHeartEvent event) {
        int v;
        int u;
        if (!this.test((Entity)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        if (!ConfigSettings.SHOW_FROZEN_HEALTH.get().booleanValue()) {
            return;
        }
        Gui.HeartType heartType = event.getHeartType();
        boolean halfHeart = event.isHalfHeart();
        int x = event.getX();
        int y = event.getY();
        if (heartType == Gui.HeartType.CONTAINER) {
            ++this.heartIndex;
        }
        double effect = this.getEffectFactor();
        double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
        if (heartsFreezePercentage == 0.0) {
            return;
        }
        float maxHealth = this.entity().m_21233_();
        boolean isHardcore = this.entity().m_9236_().m_6106_().m_5466_();
        float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
        if (maxFrozenHealth == 0.0f) {
            return;
        }
        int frozenHealth = (int)Math.round(CSMath.blend(0.0, (double)maxHealth * heartsFreezePercentage, effect, 0.0, 1.0));
        int frozenHearts = Math.round((float)frozenHealth / 2.0f);
        boolean partialFrozen = frozenHealth % 2 == 1 && this.heartIndex == frozenHearts;
        int n = u = isHardcore ? 7 : 0;
        int n2 = partialFrozen ? (halfHeart ? 21 : 14) : (v = halfHeart ? 7 : 0);
        if (this.heartIndex <= frozenHearts) {
            int oldTexture = RenderSystem.m_157203_((int)0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HEART_TEXTURE);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (heartType == Gui.HeartType.CONTAINER) {
                AbstractContainerScreen.m_93133_((PoseStack)event.getPoseStack(), (int)(x + 1), (int)(y + 1), (float)14.0f, (float)v, (int)7, (int)7, (int)21, (int)28);
            } else {
                AbstractContainerScreen.m_93133_((PoseStack)event.getPoseStack(), (int)(x + 1), (int)(y + 1), (float)u, (float)v, (int)7, (int)7, (int)21, (int)28);
            }
            RenderSystem.m_69461_();
            RenderSystem.m_157453_((int)0, (int)oldTexture);
        }
    }

    @SubscribeEvent
    public void resetHeartIndex(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.heartIndex = 0;
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

