/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterTempModifier
extends TempModifier {
    public WaterTempModifier() {
        this(-0.01);
    }

    public WaterTempModifier(double temperature) {
        this.getNBT().m_128347_("Temperature", temperature);
    }

    public double getTemperature() {
        return this.getNBT().m_128459_("Temperature");
    }

    public double getTargetTemperature(LivingEntity entity) {
        Number[] waterTemps = (Double[])WorldHelper.getPositionGrid(entity.m_20183_(), 9, 4).stream().map(pos -> WorldHelper.getWaterTemperatureAt(entity.f_19853_, pos)).toArray(Double[]::new);
        return CSMath.average(waterTemps);
    }

    @Override
    public Function<Double, Double> calculate(LivingEntity entity, Temperature.Trait trait) {
        double worldTemp = Temperature.get(entity, Temperature.Trait.WORLD);
        double minWorldTemp = ConfigSettings.MIN_TEMP.get();
        double maxWorldTemp = ConfigSettings.MAX_TEMP.get();
        double configDrySpeed = ConfigSettings.DRYOFF_SPEED.get();
        double temperature = this.getTemperature();
        double target = this.getTargetTemperature(entity);
        double addAmount = WorldHelper.isInWater((Entity)entity) ? (temperature < target ? Math.min(ConfigSettings.WATER_SOAK_SPEED.get(), target - temperature) : Math.max(-ConfigSettings.WATER_SOAK_SPEED.get().doubleValue(), target - temperature)) : (WorldHelper.isRainingAt(entity.f_19853_, entity.m_20183_()) ? Math.max(-ConfigSettings.RAIN_SOAK_SPEED.get().doubleValue(), -ConfigSettings.MAX_RAIN_SOAK.get().doubleValue() - temperature) : 0.0);
        double dryAmount = CSMath.blendExp(configDrySpeed / 1.5, configDrySpeed * 5.0, worldTemp, minWorldTemp, maxWorldTemp, 20.0);
        double tickRate = (double)this.getTickRate() / 5.0;
        double newTemperature = CSMath.shrink(temperature + addAmount * tickRate, dryAmount * tickRate);
        if (newTemperature == 0.0) {
            this.expires(0);
        }
        this.getNBT().m_128347_("Temperature", newTemperature);
        if (temperature != newTemperature) {
            this.markDirty();
        }
        return temp -> temp + newTemperature;
    }

    @Override
    public void tick(LivingEntity entity) {
        if (entity.f_19853_.m_5776_() && ConfigSettings.WATER_EFFECT_SETTING.get().showParticles() && !entity.m_20069_() && Math.random() < Math.abs(this.getNBT().m_128459_("Temperature")) * 2.0) {
            double randX = (double)entity.m_20205_() * (Math.random() - 0.5);
            double randY = (double)entity.m_20206_() * Math.random();
            double randZ = (double)entity.m_20205_() * (Math.random() - 0.5);
            entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_() + randX, entity.m_20186_() + randY, entity.m_20189_() + randZ, 0.0, 0.0, 0.0);
        }
    }
}

