/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderLampHand {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHandRender(RenderHandEvent event) {
        if (event.getItemStack().m_41720_() == ModItems.SOULSPRING_LAMP && ConfigSettings.POSE_SOULSPRING_LAMP.get().booleanValue()) {
            event.setCanceled(true);
            PoseStack ms = event.getPoseStack();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            boolean isRightHand = EntityHelper.getArmFromHand(event.getHand(), (Player)player) == HumanoidArm.RIGHT;
            PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
            ItemInHandRenderer handRenderer = Minecraft.m_91087_().f_91063_.f_109055_;
            ms.m_85836_();
            ms.m_85837_(0.0, 0.2, -0.3);
            ms.m_85836_();
            float swingProgress = event.getSwingProgress();
            float equipProgress = event.getEquipProgress();
            float handX = isRightHand ? 1.0f : -1.0f;
            ms.m_85837_(isRightHand ? 0.0 : -0.698, 0.6, isRightHand ? 0.7 : 0.76);
            float sqrtSwing = Mth.m_14116_((float)swingProgress);
            float handSwingX = -0.3f * Mth.m_14031_((float)(sqrtSwing * (float)Math.PI));
            float handSwingY = 0.4f * Mth.m_14031_((float)(sqrtSwing * ((float)Math.PI * 2)));
            float handSwingZ = -0.4f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
            float swingSize = isRightHand ? (float)(equipProgress != 0.0f && equipProgress < 1.0f ? 2 : 4) : (equipProgress != 0.0f && equipProgress < 1.0f ? 1.5f : 7.0f);
            ms.m_85837_((double)(handX * (handSwingX + 0.64000005f)), (double)(handSwingY / swingSize + -0.6f + equipProgress * -0.6f), (double)(handSwingZ / (swingSize * 6.0f) + -0.71999997f));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(handX * 45.0f));
            float handFlailZ = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
            float handFlailX = Mth.m_14031_((float)(sqrtSwing * (float)Math.PI));
            ms.m_85845_(Vector3f.f_122225_.m_122240_(handX * handFlailX * (isRightHand ? 1.0f : 20.0f)));
            ms.m_85845_(Vector3f.f_122223_.m_122240_(handX * handFlailX * (isRightHand ? -10.0f : 1.0f)));
            ms.m_85845_(Vector3f.f_122227_.m_122240_(handX * handFlailZ * 20.0f));
            ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            if (isRightHand) {
                ms.m_85845_(Vector3f.f_122227_.m_122240_(-130.0f));
            } else {
                ms.m_85845_(Vector3f.f_122227_.m_122240_(-230.0f));
            }
            ms.m_85841_(0.5f, 0.5f, 0.5f);
            if (isRightHand) {
                ms.m_85837_(0.5, -0.1, 0.5);
            } else {
                ms.m_85837_(-1.2, -0.1, 0.5);
            }
            RenderLampHand.renderHand(ms, event.getMultiBufferSource(), event.getPackedLight(), player, isRightHand, event.getHand(), handRenderer, playerRenderer, event.getItemStack());
            ms.m_85849_();
            ms.m_85849_();
        }
    }

    public static void transformArm(LivingEntity entity, ModelPart arm, HumanoidArm side) {
        Player player;
        if (entity instanceof Player && EntityHelper.holdingLamp((LivingEntity)(player = (Player)entity), side)) {
            float sideMultiplier = side == HumanoidArm.RIGHT ? 1.0f : -1.0f;
            arm.f_104205_ += 1.5707964f * sideMultiplier;
            arm.f_104204_ = -arm.f_104203_ * sideMultiplier - 1.5707964f * sideMultiplier * 1.04f;
            arm.f_104203_ = -1.5707964f;
            arm.f_104200_ -= 1.0f * sideMultiplier;
            if (player.m_6047_()) {
                arm.f_104203_ -= 0.4f;
            }
            if (player.f_20911_ && side == EntityHelper.getArmFromHand(player.f_20912_, player)) {
                RenderLampHand.swingArm(arm, (LivingEntity)player, side);
            }
        }
    }

    private static void swingArm(ModelPart arm, LivingEntity player, HumanoidArm side) {
        float sideMultiplier = side == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        float partialTick = Minecraft.m_91087_().m_91296_();
        float attackAnim = player.m_21324_(partialTick);
        float playerPitch = player.m_5686_(partialTick);
        float pitchFactor = RenderLampHand.getSwingHorizontalOffset(side, playerPitch);
        float windUpTime = 0.3f;
        float windUpPoint = 1.5f;
        float midSwingTime = 0.7f;
        arm.f_104203_ = attackAnim < windUpTime / 3.0f ? (arm.f_104203_ += CSMath.blendLog(0.0f, windUpPoint, attackAnim, 0.0f, windUpTime / 3.0f, 1.0) / pitchFactor) : (attackAnim < windUpTime ? (arm.f_104203_ += CSMath.blendLog(windUpPoint, 1.0f, attackAnim, windUpTime / 3.0f, windUpTime, 1.0) / pitchFactor) : (attackAnim < midSwingTime ? (arm.f_104203_ += CSMath.blend(1.0f, 0.2f, attackAnim, windUpTime, midSwingTime) / pitchFactor) : (arm.f_104203_ += CSMath.blendExp(0.2f, 0.0f, attackAnim, midSwingTime, 1.0f) / pitchFactor)));
        float pitchSwingHeight = playerPitch < 0.0f ? playerPitch / 20.0f : playerPitch / 60.0f;
        arm.f_104204_ = (float)((double)arm.f_104204_ + (Math.pow((double)attackAnim - 0.5, 2.0) - 0.25) * (double)pitchSwingHeight * (double)sideMultiplier);
        if (side == HumanoidArm.LEFT) {
            arm.f_104205_ = (float)((double)arm.f_104205_ + Math.sin((double)attackAnim * Math.PI) * 0.5);
        }
    }

    private static float getSwingHorizontalOffset(HumanoidArm side, float playerPitch) {
        float pitchFactor = side == HumanoidArm.RIGHT ? (playerPitch < 0.0f ? CSMath.blend(1.8f, 0.6f, playerPitch, 0.0f, -90.0f) : CSMath.blend(1.8f, 3.0f, playerPitch, 0.0f, 90.0f)) : (playerPitch < 0.0f ? CSMath.blend(3.0f, 0.5f, playerPitch, 0.0f, -90.0f) : CSMath.blend(3.0f, 3.0f, playerPitch, 0.0f, 90.0f));
        return pitchFactor;
    }

    private static void renderHand(PoseStack ms, MultiBufferSource bufferSource, int light, LocalPlayer player, boolean isRightHand, InteractionHand hand, ItemInHandRenderer handRenderer, PlayerRenderer playerRenderer, ItemStack itemStack) {
        boolean isSelected = player.m_21120_(hand).m_150930_(ModItems.SOULSPRING_LAMP);
        ms.m_85836_();
        ms.m_85836_();
        ms.m_85841_(1.0f, 1.2f, 1.0f);
        ms.m_85845_(Vector3f.f_122223_.m_122240_(-25.0f));
        ms.m_85837_(0.0, -0.2, 0.25);
        if (!isSelected) {
            ms.m_85837_(0.0, isRightHand ? -0.012 : 0.015, 0.0);
            ms.m_85845_(Vector3f.f_122227_.m_122240_(2.4f * (float)(isRightHand ? -1 : 1)));
            ms.m_85845_(Vector3f.f_122223_.m_122240_(2.3f));
        }
        if (isRightHand) {
            if (isSelected) {
                ms.m_85837_(-0.365, -0.2, -0.075);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                ms.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            } else {
                ms.m_85837_(-0.3925, 0.06, 0.38);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
            }
            playerRenderer.m_117770_(ms, bufferSource, light, (AbstractClientPlayer)player);
        } else {
            if (isSelected) {
                ms.m_85837_(-0.335, -0.2, -0.075);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                ms.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            } else {
                ms.m_85837_(-0.325, 0.06, 0.38);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(87.0f));
            }
            playerRenderer.m_117813_(ms, bufferSource, light, (AbstractClientPlayer)player);
        }
        ms.m_85849_();
        ms.m_85836_();
        ms.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        ms.m_85837_(-0.35, 0.1, 0.625);
        ms.m_85841_(1.0f, 1.0f, 0.8f);
        if (isRightHand) {
            ms.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            ms.m_85837_(-0.1, 0.125, 0.0);
            handRenderer.m_109322_((LivingEntity)player, itemStack, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, ms, bufferSource, light);
        } else {
            ms.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            ms.m_85837_(-0.1, 0.125, 0.0);
            handRenderer.m_109322_((LivingEntity)player, itemStack, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, false, ms, bufferSource, light);
        }
        ms.m_85849_();
        ms.m_85849_();
    }
}

