/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.momosoftworks.coldsweat.common.block.BoilerBlock;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.BoilerContainer;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlockEntities;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class BoilerBlockEntity
extends HearthBlockEntity {
    public static int[] WATERSKIN_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static int[] FUEL_SLOT = new int[]{0};
    protected boolean hasWaterskins = false;
    protected boolean hasDrinkables = false;
    LazyOptional<? extends IItemHandler>[] slotHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public BoilerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BOILER, pos, state);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cold_sweat.boiler");
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof BoilerBlockEntity) {
            BoilerBlockEntity boilerTE = (BoilerBlockEntity)te;
            boilerTE.tick(level, state, pos);
        }
    }

    public void tick(Level level, BlockState state, BlockPos pos) {
        super.tick(level, pos);
        if (!level.m_5776_() && this.getFuel() > 0) {
            ItemStack stack;
            int i;
            if (this.ticksExisted % (int)(20.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0) {
                this.hasWaterskins = false;
                for (i = 1; i < 10; ++i) {
                    stack = this.m_8020_(i);
                    CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
                    double itemTemp = tag.m_128459_("Temperature");
                    if (!stack.m_150930_(ModItems.FILLED_WATERSKIN) || !(itemTemp < 50.0)) continue;
                    tag.m_128347_("Temperature", Math.min(50.0, itemTemp + 1.0));
                    this.hasWaterskins = true;
                }
            }
            if ((double)this.ticksExisted % (200.0 / Math.max(1.0, ConfigSettings.TEMP_RATE.get())) == 0.0) {
                this.hasDrinkables = false;
                for (i = 1; i < 10; ++i) {
                    stack = this.m_8020_(i);
                    if (!CompatManager.isThirstLoaded() || !CompatManager.Thirst.hasPurity(stack) || CompatManager.Thirst.getPurity(stack) >= 3) continue;
                    CompatManager.Thirst.setPurity(stack, CompatManager.Thirst.getPurity(stack) + 1);
                    this.hasDrinkables = true;
                }
            }
        }
    }

    public void checkForItems() {
        this.hasWaterskins = false;
        this.hasDrinkables = false;
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = this.m_8020_(i);
            CompoundTag tag = NBTHelper.getTagOrEmpty(stack);
            double itemTemp = tag.m_128459_("Temperature");
            if (stack.m_150930_(ModItems.FILLED_WATERSKIN) && itemTemp < 50.0) {
                this.hasWaterskins = true;
                continue;
            }
            if (!CompatManager.isThirstLoaded() || !CompatManager.Thirst.hasPurity(stack) || CompatManager.Thirst.getPurity(stack) >= 3) continue;
            this.hasDrinkables = true;
        }
    }

    @Override
    protected void init() {
        super.init();
        this.checkForItems();
    }

    @Override
    public int getSpreadRange() {
        return ConfigSettings.BOILER_RANGE.get();
    }

    @Override
    public int getMaxRange() {
        return ConfigSettings.BOILER_MAX_RANGE.get();
    }

    @Override
    public int getMaxPaths() {
        return ConfigSettings.BOILER_MAX_VOLUME.get();
    }

    @Override
    public int getInsulationTime() {
        return ConfigSettings.BOILER_WARM_UP_TIME.get();
    }

    @Override
    public int getMaxInsulationLevel() {
        return ConfigSettings.BOILER_MAX_INSULATION.get();
    }

    @Override
    public SoundEvent getFuelDepleteSound() {
        return ModSounds.BOILER_DEPLETE;
    }

    @Override
    public boolean hasSmokestack() {
        return this.hasSmokestack;
    }

    @Override
    protected boolean isSmartEnabled() {
        return ConfigSettings.SMART_BOILER.get();
    }

    @Override
    protected void tickPaths(int firstIndex, int lastIndex) {
        if (this.hasSmokestack) {
            super.tickPaths(firstIndex, lastIndex);
        }
    }

    @Override
    protected int getFuelDrainInterval() {
        return ConfigSettings.BOILER_FUEL_INTERVAL.get();
    }

    @Override
    public boolean isUsingHotFuel() {
        return super.isUsingHotFuel() || this.hasDrinkables || this.hasWaterskins;
    }

    @Override
    public void checkForStateChange() {
        super.checkForStateChange();
        this.ensureState(BoilerBlock.LIT, this.isUsingHotFuel());
    }

    @Override
    public List<Direction> getHeatingSides() {
        return Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN);
    }

    @Override
    public List<Direction> getCoolingSides() {
        return List.of();
    }

    @Override
    public boolean supportsCooling() {
        return false;
    }

    @Override
    public int getItemFuel(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.BOILER_FUEL, item.m_41720_(), data -> data.test(item)), FuelData::fuel, 0.0).intValue();
    }

    @Override
    protected void storeFuel(ItemStack stack, int amount) {
        if ((double)this.getFuel() < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.m_41613_() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - this.getFuel()) / (double)Math.abs(amount)), stack.m_41613_());
                stack.m_41774_(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.m_6836_(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    public int getFuel() {
        return this.getHotFuel();
    }

    public void setFuel(int amount) {
        this.setHotFuel(amount, true);
    }

    @Override
    public void addFuel(int amount) {
        this.addHotFuel(amount, true);
    }

    @Override
    protected boolean isFuelChanged() {
        return this.ticksExisted % 10 == 0;
    }

    @Override
    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new BoilerContainer(id, playerInv, this);
    }

    @Override
    protected void tickParticles() {
        if (this.hasSmokestack) {
            super.tickParticles();
        }
    }

    @Override
    public int m_6643_() {
        return 10;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return side.m_122434_() == Direction.Axis.Y ? WATERSKIN_SLOTS : FUEL_SLOT;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        if (slot == 0) {
            return this.getItemFuel(stack) != 0;
        }
        return stack.m_204117_(ModItemTags.BOILER_VALID) || CompatManager.isThirstLoaded() && CompatManager.Thirst.hasPurity(stack);
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return slot > 0;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction face) {
        if (!this.f_58859_ && face != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return switch (face) {
                case Direction.UP -> this.slotHandlers[0].cast();
                case Direction.DOWN -> this.slotHandlers[1].cast();
                default -> this.slotHandlers[2].cast();
            };
        }
        return super.getCapability(capability, face);
    }
}

