/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.blockentity;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.event.vanilla.BlockStateChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.ThermalSourceTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.HearthDebugRenderer;
import com.momosoftworks.coldsweat.common.block.HearthBottomBlock;
import com.momosoftworks.coldsweat.common.block.SmokestackBlock;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.init.ParticleTypesInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.HearthResetMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.tag.ModFluidTags;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.entity.DummyPlayer;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.registries.ModFluids;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.SpreadPath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class HearthBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    List<SpreadPath> paths = new ArrayList<SpreadPath>(this.getMaxPaths());
    Set<BlockPos> pathLookup = new HashSet<BlockPos>(this.getMaxPaths());
    Map<Pair<Integer, Integer>, Pair<Integer, Boolean>> seeSkyMap = new FastMap<Pair<Integer, Integer>, Pair<Integer, Boolean>>(this.getMaxPaths());
    List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    FuelFluidHandler hotFuelHandler = new FuelFluidHandler(FuelType.HOT);
    final LazyOptional<IFluidHandler> hotFuelHolder = LazyOptional.of(() -> this.hotFuelHandler);
    FuelFluidHandler coldFuelHandler = new FuelFluidHandler(FuelType.COLD);
    final LazyOptional<IFluidHandler> coldFuelHolder = LazyOptional.of(() -> this.coldFuelHandler);
    NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of(null, null);
    int x = 0;
    int y = 0;
    int z = 0;
    int lastHotFuel = 0;
    int lastColdFuel = 0;
    boolean isCoolingOn = false;
    boolean isHeatingOn = false;
    boolean usingHotFuel = false;
    boolean usingColdFuel = false;
    int insulationLevel = 0;
    boolean isEntityNearby = false;
    List<LivingEntity> entities = new ArrayList<LivingEntity>();
    int rebuildCooldown = 0;
    boolean forceRebuild = false;
    List<BlockPos> queuedUpdates = new ArrayList<BlockPos>();
    public int ticksExisted = 0;
    boolean registeredLocation = false;
    boolean showParticles = true;
    int frozenPaths = 0;
    boolean spreading = true;
    boolean hasSmokestack = false;
    Map<BlockPos, Direction> pipeEnds = new HashMap<BlockPos, Direction>();
    static final Direction[] DIRECTIONS = Direction.values();
    static Method TICK_DOWN_EFFECT;
    ChunkAccess workingChunk = null;

    public HearthBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public HearthBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityInit.HEARTH_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @SubscribeEvent
    public void onBlockUpdate(BlockStateChangedEvent event) {
        BlockPos pos = event.getPosition();
        Level level = event.getLevel();
        BlockState oldState = event.getOldState();
        BlockState newState = event.getNewState();
        if (oldState == null || newState == null) {
            return;
        }
        if (level == this.f_58857_ && this.pathLookup.contains(pos) && !oldState.m_60812_((BlockGetter)level, pos).equals(newState.m_60812_((BlockGetter)level, pos))) {
            if (!level.m_5776_()) {
                this.sendBlockUpdate(pos);
            }
            if (this.isTransferPipe(oldState) || this.isTransferPipe(newState)) {
                this.searchForPipeEnds(this.m_58899_().m_7494_(), Direction.UP);
            }
        }
    }

    @SubscribeEvent
    public void onLevelUnloaded(LevelEvent.Unload event) {
        if (event.getLevel().equals(this.f_58857_)) {
            this.cleanup();
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkAccess chunk = event.getChunk();
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            for (BlockEntity te : levelChunk.m_62954_().values()) {
                if (!(te instanceof HearthBlockEntity)) continue;
                HearthBlockEntity hearth = (HearthBlockEntity)te;
                hearth.cleanup();
            }
        }
    }

    public int getSpreadRange() {
        return ConfigSettings.HEARTH_RANGE.get();
    }

    public int getMaxRange() {
        return ConfigSettings.HEARTH_MAX_RANGE.get();
    }

    public int getMaxPaths() {
        return ConfigSettings.HEARTH_MAX_VOLUME.get();
    }

    public int getMaxFuel() {
        return 1000;
    }

    public int getInsulationTime() {
        return ConfigSettings.HEARTH_WARM_UP_TIME.get();
    }

    public int getCoolingLevel() {
        return this.usingColdFuel ? this.insulationLevel : 0;
    }

    public int getHeatingLevel() {
        return this.usingHotFuel ? this.insulationLevel : 0;
    }

    public int getMaxInsulationLevel() {
        return ConfigSettings.HEARTH_MAX_INSULATION.get();
    }

    public boolean hasSmokestack() {
        return true;
    }

    protected boolean isSmartEnabled() {
        return ConfigSettings.SMART_HEARTH.get();
    }

    protected int getFuelDrainInterval() {
        return ConfigSettings.HEARTH_FUEL_INTERVAL.get();
    }

    public boolean supportsHeating() {
        return true;
    }

    public List<Direction> getHeatingSides() {
        return Arrays.asList(Direction.EAST, Direction.SOUTH);
    }

    public boolean isHeatingSide(Direction side) {
        if (side == null) {
            return false;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        Direction rotatedSide = CSMath.directionToRotation(facing).m_55954_(side);
        return this.getHeatingSides().contains(rotatedSide);
    }

    public boolean supportsCooling() {
        return true;
    }

    public List<Direction> getCoolingSides() {
        return Arrays.asList(Direction.WEST, Direction.DOWN);
    }

    public boolean isCoolingSide(Direction side) {
        if (side == null) {
            return false;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        Direction rotatedSide = CSMath.directionToRotation(facing).m_55954_(side);
        return this.getCoolingSides().contains(rotatedSide);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.cold_sweat.hearth");
    }

    public Component m_5446_() {
        return this.m_7770_() != null ? this.m_7770_() : this.m_6820_();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static <T extends BlockEntity> void tickSelf(Level level, BlockPos pos, BlockState state, T te) {
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            hearth.tick(level, pos);
        }
    }

    public void tick(Level level, BlockPos pos) {
        if (this.ticksExisted == 0) {
            this.init();
        }
        boolean isClient = level.f_46443_;
        ++this.ticksExisted;
        if (this.rebuildCooldown > 0) {
            --this.rebuildCooldown;
        }
        if (this.f_58857_ != null && this.ticksExisted % 20 == 0) {
            this.isEntityNearby = false;
            this.entities.clear();
            AABB searchArea = new AABB(pos).m_82400_((double)this.getMaxRange());
            if (CompatManager.isValkyrienSkiesLoaded()) {
                searchArea = CompatManager.Valkyrien.transformIfShipPos(level, searchArea);
            }
            for (Entity entity : this.f_58857_.m_6249_((Entity)null, searchArea, EntityTempManager::isTemperatureEnabled)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.entities.add(living);
                this.isEntityNearby = true;
            }
        }
        this.tickPotionEffects();
        if (!(this.usingColdFuel || this.usingHotFuel || this.paths.isEmpty())) {
            this.forceUpdate();
        }
        if (this.forceRebuild || this.rebuildCooldown <= 0 && !this.queuedUpdates.isEmpty()) {
            this.resetPaths();
        }
        if (this.getColdFuel() > 0 || this.getHotFuel() > 0) {
            if (this.insulationLevel < this.getInsulationTime()) {
                ++this.insulationLevel;
            }
            if (this.usingColdFuel || this.usingHotFuel || this.isSmartEnabled() && this.isEntityNearby) {
                if (this.ticksExisted % 20 == 0) {
                    boolean bl = this.showParticles = isClient && Minecraft.m_91087_().f_91066_.m_231929_().m_231551_() == ParticleStatus.ALL && !HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);
                }
                if (this.paths.isEmpty()) {
                    this.addPath(new SpreadPath(pos.m_6630_(1)).setOrigin(pos.m_6630_(1)));
                    this.pathLookup.add(pos.m_6630_(1));
                    this.searchForPipeEnds(this.m_58899_().m_7494_(), Direction.UP);
                }
                this.spreading = this.frozenPaths < this.paths.size();
                int pathCount = this.paths.size();
                int partSize = this.spreading ? CSMath.clamp(pathCount / 3, 100, 4000) : CSMath.clamp(pathCount / 20, 10, 100);
                int partCount = (int)Math.ceil((float)pathCount / (float)partSize);
                int lastIndex = partSize * (this.ticksExisted % partCount + 1);
                int firstIndex = Math.max(0, lastIndex - partSize);
                if (this.paths.size() > 1 || this.ticksExisted % 20 == 0) {
                    this.tickPaths(firstIndex, lastIndex);
                }
                if (isClient && this.spreading && this.paths.size() != pathCount) {
                    HearthDebugRenderer.updatePaths(this);
                }
                if (!isClient && this.ticksExisted % 20 == 0) {
                    boolean isProvidingInsulation = false;
                    for (int i = 0; i < this.entities.size(); ++i) {
                        LivingEntity entity = this.entities.get(i);
                        if (entity == null || entity instanceof DummyPlayer) continue;
                        AABB playerBB = entity.m_20191_();
                        playerBB = playerBB.m_165893_(Math.max(playerBB.f_82292_, playerBB.f_82289_ + 2.0));
                        if (CompatManager.isValkyrienSkiesLoaded()) {
                            playerBB = CompatManager.Valkyrien.transformIfShipPos(level, playerBB);
                        }
                        if (!this.isAffectingPos(WorldHelper.getOccupiedPositions(playerBB)) || WorldHelper.canSeeSky((LevelAccessor)level, new BlockPos(playerBB.m_82399_()), 64)) continue;
                        isProvidingInsulation |= this.insulateEntity(entity);
                    }
                    if (this.isSmartEnabled() && !isProvidingInsulation) {
                        this.clearFuelUsage();
                    }
                }
                if (!isClient) {
                    this.tickDrainFuel();
                }
                if (level.f_46443_) {
                    this.spawnRandomAirParticles();
                }
            }
        }
        if (this.ticksExisted % 40 == 0) {
            this.checkForFuel();
        }
        if (!isClient) {
            this.checkForStateChange();
        }
        if (!isClient && this.isFuelChanged()) {
            this.updateFuelState();
        }
        if (isClient) {
            this.tickParticles();
        }
    }

    protected <T extends Comparable<T>> void ensureState(Property<T> property, T value) {
        BlockState state = this.m_58900_();
        if (state.m_61138_(property) && state.m_61143_(property) != value) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_(property, value), 2);
        }
    }

    public void checkForStateChange() {
        if (this.m_58900_().m_60713_(ModBlocks.HEARTH_BOTTOM)) {
            this.ensureState((Property)HearthBottomBlock.SMART, this.isSmartEnabled());
            this.ensureState((Property)HearthBottomBlock.LIT, this.isUsingHotFuel());
            this.ensureState((Property)HearthBottomBlock.FROSTED, this.getColdFuel() > 0);
            this.ensureState((Property)HearthBottomBlock.HEATING, this.isHeatingOn);
            this.ensureState((Property)HearthBottomBlock.COOLING, this.isCoolingOn);
        }
    }

    protected void tickPaths(int firstIndex, int lastIndex) {
        int pathCount = this.paths.size();
        for (int i = firstIndex; i < Math.min(this.paths.size(), lastIndex); ++i) {
            SpreadPath spreadPath = this.paths.get(i);
            BlockPos pathPos = spreadPath.pos;
            if (spreadPath.origin == null) {
                spreadPath.setOrigin(this.m_58899_());
            }
            int spX = spreadPath.x;
            int spY = spreadPath.y;
            int spZ = spreadPath.z;
            if (spreadPath.frozen) {
                if (this.spreading || Math.abs(spY % 2) == 0 != (Math.abs(spX % 2) == Math.abs(spZ % 2))) continue;
                this.paths.remove(i);
                --i;
                continue;
            }
            if (pathCount < this.getMaxPaths() && spreadPath.withinDistance((Vec3i)spreadPath.origin, this.getSpreadRange()) && CSMath.withinCubeDistance(spreadPath.origin, this.m_58899_(), this.getMaxRange())) {
                boolean canSeeSky;
                if (this.workingChunk == null || !this.workingChunk.m_7697_().equals((Object)new ChunkPos(pathPos))) {
                    this.workingChunk = WorldHelper.getChunk((LevelAccessor)this.f_58857_, pathPos);
                }
                BlockState state = this.workingChunk != null ? this.workingChunk.m_8055_(pathPos) : this.f_58857_.m_8055_(pathPos);
                Pair flatPos = Pair.of((Object)spX, (Object)spZ);
                Pair<Integer, Boolean> seeSkyState = this.seeSkyMap.get(flatPos);
                if (seeSkyState == null || (Integer)seeSkyState.getFirst() < spY != (Boolean)seeSkyState.getSecond()) {
                    canSeeSky = WorldHelper.canSeeSky((LevelAccessor)this.f_58857_, pathPos.m_7494_(), 64);
                    this.seeSkyMap.put((Pair<Integer, Integer>)flatPos, (Pair<Integer, Boolean>)Pair.of((Object)spY, (Object)canSeeSky));
                } else {
                    canSeeSky = (Boolean)seeSkyState.getSecond();
                }
                if (!canSeeSky || this.isTransferPipe(state)) {
                    for (int d = 0; d < DIRECTIONS.length; ++d) {
                        Direction direction = DIRECTIONS[d];
                        Direction pathDir = spreadPath.direction;
                        if (direction == pathDir.m_122424_()) continue;
                        BlockPos tryPos = pathPos.m_121945_(direction);
                        SpreadPath newPath = new SpreadPath(tryPos, direction).setOrigin(spreadPath.origin);
                        if (!this.pathLookup.add(tryPos) || !this.canSpread(this.f_58857_, pathPos, tryPos, state, spreadPath.direction, direction, newPath)) continue;
                        this.addPath(newPath);
                    }
                } else {
                    this.pathLookup.remove(pathPos);
                    this.paths.remove(i);
                    --i;
                    continue;
                }
            }
            spreadPath.frozen = true;
            ++this.frozenPaths;
        }
    }

    protected void spawnRandomAirParticles() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.showParticles && (!Minecraft.m_91087_().f_91066_.f_92063_ || !ConfigSettings.HEARTH_DEBUG.get().booleanValue())) {
            if (this.paths.isEmpty()) {
                return;
            }
            RandomSource random = this.f_58857_.f_46441_;
            int count = Math.max(1, this.paths.size() / 100);
            for (int i = 0; i < count; ++i) {
                SpreadPath path = this.paths.get(random.m_188503_(this.paths.size()));
                this.spawnAirParticle(path.x, path.y, path.z, random);
            }
        }
    }

    public void checkInputSignal() {
        if (!this.f_58857_.m_5776_() && !this.isSmartEnabled()) {
            boolean wasHeatingOn = this.isHeatingOn;
            boolean wasCoolingOn = this.isCoolingOn;
            this.isHeatingOn = this.hasHeatingSignal();
            this.isCoolingOn = this.hasCoolingSignal();
            this.usingColdFuel = this.hasSmokestack && this.isCoolingOn && this.getColdFuel() > 0;
            this.usingHotFuel = this.hasSmokestack && this.isHeatingOn && this.getHotFuel() > 0;
            this.syncInputSignal(wasHeatingOn, wasCoolingOn);
        }
    }

    protected boolean hasCoolingSignal() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        for (Direction side : this.getCoolingSides()) {
            Direction rotatedSide = CSMath.directionToRotation(facing).m_55954_(side);
            if (!this.f_58857_.m_46616_(this.m_58899_().m_121945_(rotatedSide), rotatedSide)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasHeatingSignal() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HearthBottomBlock.FACING);
        for (Direction side : this.getHeatingSides()) {
            Direction rotatedSide = CSMath.directionToRotation(facing).m_55954_(side);
            if (!this.f_58857_.m_46616_(this.m_58899_().m_121945_(rotatedSide), rotatedSide)) continue;
            return true;
        }
        return false;
    }

    protected void syncInputSignal(boolean wasHeatingOn, boolean wasCoolingOn) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (wasHeatingOn != this.isHeatingOn || wasCoolingOn != this.isCoolingOn) {
                serverLevel.m_7726_().m_8450_(this.m_58899_());
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForFuel();
    }

    public void checkForFuel() {
        BlockPos pos = this.m_58899_();
        ItemStack fuelStack = (ItemStack)this.m_7086_().get(0);
        if (!fuelStack.m_41619_()) {
            List itemEffects = PotionUtils.m_43547_((ItemStack)fuelStack);
            if (ConfigSettings.HEARTH_POTIONS_ENABLED.get().booleanValue() && !itemEffects.isEmpty() && !itemEffects.equals(this.effects) && itemEffects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.m_19544_()))) {
                if (fuelStack.m_41720_() instanceof PotionItem) {
                    this.m_7086_().set(0, (Object)Items.f_42590_.m_7968_());
                } else if (!fuelStack.hasCraftingRemainingItem() || fuelStack.m_41613_() > 1) {
                    fuelStack.m_41774_(1);
                } else {
                    this.m_7086_().set(0, (Object)fuelStack.getCraftingRemainingItem());
                }
                this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                this.effects.addAll(itemEffects.stream().map(eff -> eff.m_19555_(new CompoundTag())).map(MobEffectInstance::m_19560_).toList());
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else if (fuelStack.m_150930_(Items.f_42455_) && !this.effects.isEmpty()) {
                this.m_7086_().set(0, (Object)fuelStack.getCraftingRemainingItem());
                this.f_58857_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.effects.clear();
                WorldHelper.syncBlockEntityData((BlockEntity)this);
            } else {
                int itemFuel = this.getItemFuel(fuelStack);
                if (itemFuel != 0) {
                    this.storeFuel(fuelStack, itemFuel);
                }
            }
        }
    }

    protected boolean isFuelChanged() {
        return this.getColdFuel() != this.lastColdFuel || this.getHotFuel() != this.lastHotFuel;
    }

    protected void storeFuel(ItemStack stack, int amount) {
        int fuel;
        int n = fuel = amount > 0 ? this.getHotFuel() : this.getColdFuel();
        if ((double)fuel < (double)this.getMaxFuel() - (double)Math.abs(amount) * 0.75) {
            if (!stack.hasCraftingRemainingItem() || stack.m_41613_() > 1) {
                int consumeCount = Math.min((int)Math.floor((double)(this.getMaxFuel() - fuel) / (double)Math.abs(amount)), stack.m_41613_());
                stack.m_41774_(consumeCount);
                this.addFuel(amount * consumeCount);
            } else {
                this.m_6836_(0, stack.getCraftingRemainingItem());
                this.addFuel(amount);
            }
        }
    }

    protected void drainFuel() {
        if (this.isUsingColdFuel()) {
            this.drainColdFuel(1, true);
        }
        if (this.isUsingHotFuel()) {
            this.drainHotFuel(1, true);
        }
    }

    protected void tickDrainFuel() {
        int fuelInterval = this.getFuelDrainInterval();
        if (fuelInterval > 0 && this.ticksExisted % fuelInterval == 0) {
            this.drainFuel();
        }
    }

    protected void clearFuelUsage() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.usingColdFuel = false;
            this.usingHotFuel = false;
        }
    }

    boolean insulateEntity(LivingEntity entity) {
        for (int i = 0; i < this.effects.size(); ++i) {
            MobEffectInstance effect = this.effects.get(i);
            entity.m_7292_(new MobEffectInstance(effect.m_19544_(), effect.m_19544_() == MobEffects.f_19611_ ? 399 : 119, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
        }
        if (!this.isSmartEnabled() || this.shouldInsulateEntity(entity)) {
            int maxEffect = this.getMaxInsulationLevel() - 1;
            int effectLevel = (int)Math.min((double)maxEffect, (double)this.insulationLevel / (double)this.getInsulationTime() * (double)maxEffect);
            if (this.usingColdFuel) {
                entity.m_7292_(new MobEffectInstance(ModEffects.FRIGIDNESS, 60, effectLevel, false, false, true));
            }
            if (this.usingHotFuel) {
                entity.m_7292_(new MobEffectInstance(ModEffects.WARMTH, 60, effectLevel, false, false, true));
            }
            return this.usingColdFuel || this.usingHotFuel;
        }
        return false;
    }

    protected boolean shouldInsulateEntity(LivingEntity entity) {
        AtomicBoolean shouldInsulate = new AtomicBoolean(false);
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            double lastOutput;
            double lastInput;
            Optional<ThermalSourceTempModifier> existingMod;
            double min = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            double max = cap.getTrait(Temperature.Trait.BURNING_POINT);
            double temp = cap.getTrait(Temperature.Trait.WORLD);
            if (CSMath.betweenInclusive(temp, min, max) && (existingMod = Temperature.getModifier(cap, Temperature.Trait.WORLD, ThermalSourceTempModifier.class)).isPresent() && ((lastInput = existingMod.get().getLastInput(Temperature.Trait.WORLD)) != (lastOutput = existingMod.get().getLastOutput(Temperature.Trait.WORLD)) || lastInput != 0.0)) {
                temp = lastInput;
            }
            this.usingHotFuel |= this.getHotFuel() > 0 && temp < min;
            this.usingColdFuel |= this.getColdFuel() > 0 && temp > max;
            shouldInsulate.set(!CSMath.betweenInclusive(temp, min, max));
        });
        return shouldInsulate.get();
    }

    protected boolean canSpread(Level level, BlockPos fromPos, BlockPos toPos, BlockState fromState, Direction fromDirection, Direction toDirection, SpreadPath newPath) {
        Block fromBlock = fromState.m_60734_();
        if (fromBlock instanceof SmokestackBlock) {
            SmokestackBlock.Facing toFacing;
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)fromState.m_61143_(SmokestackBlock.FACING));
            boolean isJunction = facing == SmokestackBlock.Facing.BEND;
            BlockState toState = level.m_8055_(toPos);
            boolean isToSmokestack = toState.m_60734_() instanceof SmokestackBlock;
            SmokestackBlock.Facing facing2 = toFacing = isToSmokestack ? (SmokestackBlock.Facing)((Object)toState.m_61143_(SmokestackBlock.FACING)) : null;
            if (isJunction) {
                return isToSmokestack && (toFacing == SmokestackBlock.Facing.BEND || toFacing.getAxis() == toDirection.m_122434_());
            }
            if (facing.getAxis() == toDirection.m_122434_()) {
                newPath.setOrigin(toPos);
                return true;
            }
            return false;
        }
        if (CompatManager.isCreateLoaded() && (fromBlock instanceof FluidPipeBlock && (Boolean)fromState.m_61143_((Property)PipeBlock.f_55154_.get(toDirection)) != false || fromBlock instanceof GlassFluidPipeBlock && fromState.m_61143_((Property)RotatedPillarBlock.f_55923_) == toDirection.m_122434_() || fromBlock instanceof EncasedPipeBlock && ((Boolean)fromState.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(toDirection))).booleanValue())) {
            newPath.setOrigin(toPos);
            return true;
        }
        return !WorldHelper.isSpreadBlocked((LevelAccessor)level, fromState, fromPos, fromDirection, toDirection);
    }

    protected boolean isTransferPipe(BlockState state) {
        return state.m_60734_() instanceof SmokestackBlock || CompatManager.Create.isFluidPipe(state);
    }

    protected boolean connectsTo(BlockState state, BlockState otherState, Direction direction) {
        boolean otherIsSamePipe = state.m_60734_() instanceof SmokestackBlock == otherState.m_60734_() instanceof SmokestackBlock && CompatManager.Create.isFluidPipe(otherState) == CompatManager.Create.isFluidPipe(state);
        return this.pipePointingTo(state, otherState, direction) && otherIsSamePipe;
    }

    protected boolean pipePointingTo(BlockState state, BlockState otherState, Direction direction) {
        if (state.m_60734_() instanceof SmokestackBlock) {
            SmokestackBlock.Facing facing = (SmokestackBlock.Facing)((Object)state.m_61143_(SmokestackBlock.FACING));
            return facing == SmokestackBlock.Facing.BEND ? otherState.m_60734_() instanceof SmokestackBlock : facing.getAxis() == direction.m_122434_();
        }
        if (CompatManager.isCreateLoaded()) {
            if (state.m_60734_() instanceof FluidPipeBlock) {
                return (Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction));
            }
            if (state.m_60734_() instanceof GlassFluidPipeBlock) {
                return state.m_61143_((Property)RotatedPillarBlock.f_55923_) == direction.m_122434_();
            }
            if (state.m_60734_() instanceof EncasedPipeBlock) {
                return (Boolean)state.m_61143_((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(direction));
            }
        }
        return false;
    }

    protected void searchForPipeEnds(BlockPos startPos, Direction fromDir) {
        if (this.hasSmokestack && this.f_58857_ != null) {
            this.pipeEnds.clear();
            this.searchForPipeEndsRecursive(startPos, this.f_58857_.m_8055_(startPos), fromDir, new HashSet<BlockPos>());
        }
    }

    protected void searchForPipeEndsRecursive(BlockPos pos, BlockState state, Direction fromDir, Set<BlockPos> visited) {
        visited.add(pos);
        for (int d = 0; d < DIRECTIONS.length; ++d) {
            BlockPos tryPos;
            Direction direction = DIRECTIONS[d];
            if (direction == fromDir.m_122424_() || visited.contains(tryPos = pos.m_121945_(direction)) || !CSMath.withinCubeDistance(this.m_58899_(), tryPos, this.getMaxRange())) continue;
            BlockState otherState = this.f_58857_.m_8055_(tryPos);
            if (this.isTransferPipe(otherState) && this.connectsTo(state, otherState, direction)) {
                this.searchForPipeEndsRecursive(tryPos, otherState, direction, visited);
                continue;
            }
            if (WorldHelper.isSpreadBlocked((LevelAccessor)this.f_58857_, otherState, tryPos, fromDir.m_122424_(), direction) || !this.pipePointingTo(state, otherState, direction)) continue;
            this.pipeEnds.put(tryPos, direction.m_122424_());
        }
    }

    protected void init() {
        this.registerLocation();
        this.checkForSmokestack();
        this.checkInputSignal();
    }

    private void registerLocation() {
        if (!this.registeredLocation) {
            this.levelPos = Pair.of((Object)this.m_58899_(), (Object)this.f_58857_.m_46472_().m_135782_());
            HearthSaveDataHandler.HEARTH_POSITIONS.add(this.levelPos);
            this.x = this.m_58899_().m_123341_();
            this.y = this.m_58899_().m_123342_();
            this.z = this.m_58899_().m_123343_();
            this.registeredLocation = true;
        }
    }

    private void unregisterLocation() {
        if (this.registeredLocation) {
            HearthSaveDataHandler.HEARTH_POSITIONS.remove(this.levelPos);
            this.registeredLocation = false;
        }
    }

    protected void tickPotionEffects() {
        if (!this.effects.isEmpty()) {
            this.effects.removeIf(effect -> {
                try {
                    TICK_DOWN_EFFECT.invoke(effect, new Object[0]);
                    if (effect.m_19557_() <= 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            });
        }
    }

    public boolean isAffectingPos(List<BlockPos> positions) {
        boolean isSmall = positions.size() <= 1;
        BlockPos.MutableBlockPos checkerboardPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.paths.size(); ++i) {
            SpreadPath path = this.paths.get(i);
            for (int j = 0; j < positions.size(); ++j) {
                BlockPos pos = positions.get(j);
                if (pos.equals((Object)path.pos)) {
                    return true;
                }
                if (!isSmall || !pos.equals((Object)checkerboardPos.m_122190_((Vec3i)path.pos).m_7918_(1, 1, 1))) continue;
                return true;
            }
        }
        return false;
    }

    void resetPaths() {
        this.rebuildCooldown = 100;
        this.paths.clear();
        this.pathLookup.clear();
        if (this.forceRebuild) {
            this.seeSkyMap.clear();
        } else {
            for (int i = 0; i < this.queuedUpdates.size(); ++i) {
                BlockPos pos = this.queuedUpdates.get(i);
                this.seeSkyMap.remove(Pair.of((Object)pos.m_123341_(), (Object)pos.m_123343_()));
            }
        }
        this.frozenPaths = 0;
        this.spreading = true;
        this.sendResetPacket();
        if (this.f_58857_.f_46443_) {
            HearthDebugRenderer.updatePaths(this);
        }
        this.forceRebuild = false;
        this.queuedUpdates.clear();
        this.searchForPipeEnds(this.m_58899_().m_7494_(), Direction.UP);
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public int getItemFuel(ItemStack item) {
        return CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.HEARTH_FUEL, item.m_41720_(), data -> data.test(item)), FuelData::fuel, 0.0).intValue();
    }

    public int getHotFuel() {
        return this.hotFuelHandler.getFuelAmount();
    }

    public int getColdFuel() {
        return this.coldFuelHandler.getFuelAmount();
    }

    public boolean isUsingColdFuel() {
        return this.usingColdFuel;
    }

    public boolean isUsingHotFuel() {
        return this.usingHotFuel;
    }

    protected FuelFluidHandler getFuelHandler(FuelType fuelType) {
        return fuelType == FuelType.COLD ? this.coldFuelHandler : this.hotFuelHandler;
    }

    protected void addFuel(FuelType fuelType, int amount, boolean update) {
        FluidStack fillStack;
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        int filledAmount = handler.fill(fillStack = new FluidStack(handler.getDefaultFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (filledAmount > 0 && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void drainFuel(FuelType fuelType, int amount, boolean update) {
        FluidStack drainStack;
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        FluidStack drained = handler.drain(drainStack = new FluidStack(handler.getDefaultFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (drained.getAmount() > 0 && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void setFuel(FuelType fuelType, int amount, boolean update) {
        FuelFluidHandler handler = this.getFuelHandler(fuelType);
        FluidStack currentFluid = handler.getFluid();
        FluidStack newFluid = new FluidStack(fuelType.getFluid(), amount);
        newFluid.setTag(currentFluid.getTag());
        handler.setFluid(newFluid);
        if (currentFluid.getAmount() != amount && update) {
            this.onFuelChanged(fuelType);
        }
    }

    protected void onFuelChanged(FuelType fuelType) {
        boolean nowEmpty = this.getFuelHandler(fuelType).getFluid().isEmpty();
        if (nowEmpty && this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), this.getFuelDepleteSound(), SoundSource.BLOCKS, 1.0f, (float)Math.random() * 0.2f + 0.9f);
        }
        this.updateFuelState();
        this.checkInputSignal();
    }

    public void addHotFuel(int amount, boolean update) {
        this.addFuel(FuelType.HOT, amount, update);
    }

    public void addColdFuel(int amount, boolean update) {
        this.addFuel(FuelType.COLD, amount, update);
    }

    public void drainHotFuel(int amount, boolean update) {
        this.drainFuel(FuelType.HOT, amount, update);
    }

    public void drainColdFuel(int amount, boolean update) {
        this.drainFuel(FuelType.COLD, amount, update);
    }

    public void setHotFuel(int amount, boolean update) {
        this.setFuel(FuelType.HOT, amount, update);
    }

    public void setColdFuel(int amount, boolean update) {
        this.setFuel(FuelType.COLD, amount, update);
    }

    public void addFuel(int amount) {
        if (amount > 0) {
            this.addHotFuel(amount, true);
        } else if (amount < 0) {
            this.addColdFuel(Math.abs(amount), true);
        }
    }

    public void updateFuelState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            WorldHelper.syncBlockEntityData((BlockEntity)this);
            this.lastColdFuel = this.getColdFuel();
            this.lastHotFuel = this.getHotFuel();
        }
    }

    protected SoundEvent getFuelDepleteSound() {
        return ModSounds.HEARTH_DEPLETE;
    }

    public boolean checkForSmokestack() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState aboveState = this.f_58857_.m_8055_(this.m_58899_().m_7494_());
        boolean hadSmokestack = this.hasSmokestack;
        this.hasSmokestack = aboveState.m_60734_() instanceof SmokestackBlock;
        if (this.hasSmokestack && !hadSmokestack) {
            this.registerLocation();
            if (this.f_58857_.f_46443_) {
                ClientOnlyHelper.addHearthPosition(this.m_58899_());
            }
            this.m_58900_().m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 3);
        } else if (!this.hasSmokestack && hadSmokestack) {
            this.forceUpdate();
            this.resetPaths();
            this.unregisterLocation();
            if (this.f_58857_.f_46443_) {
                ClientOnlyHelper.removeHearthPosition(this.m_58899_());
            }
        }
        return this.hasSmokestack;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickParticles() {
        ParticleStatus status = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
        if (!this.hasSmokestack() || status == ParticleStatus.MINIMAL) {
            return;
        }
        RandomSource rand = this.f_58857_.f_46441_;
        for (Map.Entry<BlockPos, Direction> entry : this.pipeEnds.entrySet()) {
            double d5;
            double d4;
            double d3;
            double d2;
            double d1;
            double d0;
            BlockPos pos = entry.getKey();
            Direction face = entry.getValue();
            if (this.usingColdFuel && rand.m_188500_() < (double)this.getColdFuel() / 3000.0) {
                d0 = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.35;
                d1 = (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.35;
                d2 = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.35;
                d3 = (rand.m_188500_() - 0.5) / 4.0;
                d4 = (rand.m_188500_() - 0.5) / 4.0;
                d5 = (rand.m_188500_() - 0.5) / 4.0;
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypesInit.STEAM.get(), d0 + d3, d1 + d4, d2 + d5, 0.0, 0.04, 0.0);
            }
            if (!this.usingHotFuel || !(rand.m_188500_() < (double)this.getHotFuel() / 3000.0)) continue;
            d0 = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.35;
            d1 = (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.35;
            d2 = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.35;
            d3 = (rand.m_188500_() - 0.5) / 2.0;
            d4 = (rand.m_188500_() - 0.5) / 2.0;
            d5 = (rand.m_188500_() - 0.5) / 2.0;
            SimpleParticleType particle = rand.m_188500_() < 0.5 ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_;
            this.f_58857_.m_7106_((ParticleOptions)particle, d0 + d3, d1 + d4, d2 + d5, 0.0, 0.0, 0.0);
        }
    }

    public ParticleOptions getAirParticle() {
        return (ParticleOptions)ParticleTypesInit.HEARTH_AIR.get();
    }

    public void spawnAirParticle(int x, int y, int z, RandomSource rand) {
        ParticleStatus status = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_();
        if (status != ParticleStatus.ALL) {
            return;
        }
        float f = rand.m_188501_();
        float f2 = this.spreading ? 0.002f : 0.032f;
        if (f > f2) {
            return;
        }
        float xr = rand.m_188501_();
        float yr = rand.m_188501_();
        float zr = rand.m_188501_();
        float xm = rand.m_188501_() / 20.0f - 0.025f;
        float zm = rand.m_188501_() / 20.0f - 0.025f;
        this.f_58857_.m_6493_(this.getAirParticle(), false, (double)((float)x + xr), (double)((float)y + yr), (double)((float)z + zr), (double)xm, 0.0, (double)zm);
    }

    public int m_6643_() {
        return 1;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory playerInv) {
        return new HearthContainer(id, playerInv, this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.loadEffects(tag);
        this.getFuelHandler(FuelType.COLD).setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("ColdFuel")));
        this.getFuelHandler(FuelType.HOT).setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("HotFuel")));
        this.insulationLevel = tag.m_128451_("InsulationLevel");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        this.saveEffects(tag);
        tag.m_128365_("ColdFuel", (Tag)this.getFuelHandler(FuelType.COLD).getFluid().writeToNBT(new CompoundTag()));
        tag.m_128365_("HotFuel", (Tag)this.getFuelHandler(FuelType.HOT).getFluid().writeToNBT(new CompoundTag()));
        tag.m_128405_("InsulationLevel", this.insulationLevel);
    }

    void saveEffects(CompoundTag tag) {
        if (!this.effects.isEmpty()) {
            ListTag list = new ListTag();
            for (MobEffectInstance effect : this.effects) {
                list.add((Object)effect.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("Effects", (Tag)list);
        }
    }

    void loadEffects(CompoundTag tag) {
        this.effects.clear();
        if (tag.m_128441_("Effects")) {
            ListTag list = tag.m_128437_("Effects", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.effects.add(MobEffectInstance.m_19560_((CompoundTag)list.m_128728_(i)));
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("HotFuel", this.getHotFuel());
        tag.m_128405_("ColdFuel", this.getColdFuel());
        tag.m_128379_("ShouldUseColdFuel", this.usingColdFuel);
        tag.m_128379_("ShouldUseHotFuel", this.usingHotFuel);
        tag.m_128405_("InsulationLevel", this.insulationLevel);
        tag.m_128379_("IsCooling", this.isCoolingOn);
        tag.m_128379_("IsHeating", this.isHeatingOn);
        tag.m_128379_("HasSmokestack", this.hasSmokestack);
        this.saveEffects(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setHotFuel(tag.m_128451_("HotFuel"), false);
        this.setColdFuel(tag.m_128451_("ColdFuel"), false);
        this.usingColdFuel = tag.m_128471_("ShouldUseColdFuel");
        this.usingHotFuel = tag.m_128471_("ShouldUseHotFuel");
        this.insulationLevel = tag.m_128451_("InsulationLevel");
        this.isCoolingOn = tag.m_128471_("IsCooling");
        this.isHeatingOn = tag.m_128471_("IsHeating");
        this.hasSmokestack = tag.m_128471_("HasSmokestack");
        this.loadEffects(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction face) {
        return capability == ForgeCapabilities.FLUID_HANDLER && face != null ? (this.isHeatingSide(face) ? this.hotFuelHolder.cast() : (this.isCoolingSide(face) ? this.coldFuelHolder.cast() : super.getCapability(capability, face))) : super.getCapability(capability, face);
    }

    public void addPath(SpreadPath path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<SpreadPath> newPaths) {
        this.paths.addAll(newPaths);
    }

    public void sendResetPacket() {
        if (this.f_58857_ instanceof ServerLevel) {
            ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)WorldHelper.getChunk((LevelAccessor)this.f_58857_, this.m_58899_())), (Object)new HearthResetMessage(this.m_58899_()));
        }
    }

    public void sendBlockUpdate(BlockPos pos) {
        this.queuedUpdates.add(pos);
    }

    public void forceUpdate() {
        this.forceRebuild = true;
        this.sendBlockUpdate(this.m_58899_());
    }

    protected void cleanup() {
        HearthSaveDataHandler.HEARTH_POSITIONS.remove(Pair.of((Object)this.m_58899_(), (Object)this.m_58904_().m_46472_().m_135782_()));
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        if (this.f_58857_.f_46443_) {
            ClientOnlyHelper.removeHearthPosition(this.m_58899_());
        }
    }

    public Set<BlockPos> getPathLookup() {
        return this.pathLookup;
    }

    public List<SpreadPath> getPaths() {
        return this.paths;
    }

    public boolean isSpreading() {
        return this.spreading;
    }

    public boolean isCoolingOn() {
        return this.isCoolingOn;
    }

    public boolean isHeatingOn() {
        return this.isHeatingOn;
    }

    public void setCooling(boolean isPowered) {
        this.isCoolingOn = isPowered;
    }

    public void setHeating(boolean isPowered) {
        this.isHeatingOn = isPowered;
    }

    public Map<BlockPos, Direction> getPipeEnds() {
        return this.pipeEnds;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0};
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction pDirection) {
        return this.getItemFuel(stack) != 0;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return true;
    }

    private static /* synthetic */ BlockPos lambda$tickPaths$2(SpreadPath p) {
        return p.pos;
    }

    static {
        try {
            TICK_DOWN_EFFECT = ObfuscationReflectionHelper.findMethod(MobEffectInstance.class, (String)"m_19579_", (Class[])new Class[0]);
            TICK_DOWN_EFFECT.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class FuelFluidHandler
    implements IFluidHandler {
        private FluidStack fuel;
        private final FuelType fuelType;

        protected FuelFluidHandler(FuelType fuelType) {
            this.fuelType = fuelType;
            this.fuel = new FluidStack(this.fuelType.getFluid(), 0);
        }

        public int getTanks() {
            return 1;
        }

        public FuelType getFuelType() {
            return this.fuelType;
        }

        public int getFuelAmount() {
            return this.fuel.getAmount();
        }

        public FluidStack getFluid() {
            return this.fuel;
        }

        public void setFluid(FluidStack fluidStack) {
            this.fuel = fluidStack;
        }

        public Fluid getDefaultFluid() {
            return this.fuelType.getFluid();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.fuel;
        }

        public int getTankCapacity(int tank) {
            return HearthBlockEntity.this.getMaxFuel();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
            return fluidStack.getFluid().m_205067_(this.fuelType.getValidFluidTag());
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack.getFluid().m_205067_(this.fuelType.getValidFluidTag())) {
                int amount = Math.min(fluidStack.getAmount(), this.getTankCapacity(0) - this.fuel.getAmount());
                if (fluidAction.execute()) {
                    if (this.fuel.isEmpty()) {
                        this.fuel = fluidStack.copy();
                    } else {
                        this.fuel.grow(amount);
                    }
                }
                return amount;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            return this.isFluidValid(0, fluidStack) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
        }

        public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
            int drained = Math.min(this.fuel.getAmount(), amount);
            if (drained == 0) {
                return new FluidStack(this.fuelType.getFluid(), 0);
            }
            FluidStack stack = new FluidStack(this.fuel, drained);
            if (fluidAction.execute() && drained > 0) {
                this.fuel.shrink(drained);
            }
            HearthBlockEntity.this.m_6596_();
            return stack;
        }
    }

    public static enum FuelType {
        COLD(0),
        HOT(1);

        private final int tankIndex;

        private FuelType(int tankIndex) {
            this.tankIndex = tankIndex;
        }

        public int getTankIndex() {
            return this.tankIndex;
        }

        public Fluid getFluid() {
            return this == COLD ? ModFluids.SLUSH : Fluids.f_76195_;
        }

        public TagKey<Fluid> getValidFluidTag() {
            return this == COLD ? ModFluidTags.COLD : ModFluidTags.HOT;
        }
    }
}

