/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.api.event.common.insulation.InsulateItemEvent;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.capability.insulation.IInsulatableCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SewingContainer
extends ItemCombinerMenu {
    protected boolean quickMoving = false;
    protected Inventory playerInventory;

    public SewingContainer(int containerId, Inventory inventory) {
        this((MenuType)MenuInit.SEWING_CONTAINER_TYPE.get(), containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public SewingContainer(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(i, inventory);
    }

    public SewingContainer(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess chunkAccess) {
        super(menuType, containerId, inventory, chunkAccess);
        this.playerInventory = inventory;
        this.f_38839_.set(0, (Object)new Slot(this.f_39769_, 0, 43, 26){
            {
                this.f_40219_ = 0;
            }

            public boolean m_5857_(ItemStack stack) {
                return ItemInsulationManager.isInsulatable(stack);
            }
        });
        this.f_38839_.set(1, (Object)new Slot(this.f_39769_, 1, 43, 53){
            {
                this.f_40219_ = 1;
            }

            public boolean m_5857_(ItemStack stack) {
                return ConfigSettings.INSULATION_ITEMS.get().containsKey((Object)stack.m_41720_()) || stack.m_204117_(Tags.Items.SHEARS);
            }
        });
        this.f_38839_.set(2, (Object)new Slot((Container)this.f_39768_, 2, 121, 39){
            {
                this.f_40219_ = 2;
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return SewingContainer.this.m_6560_(player, this.m_6657_());
            }

            public void m_142406_(Player player, ItemStack stack) {
                SewingContainer.this.m_142365_(player, stack);
            }
        });
    }

    public int getResultSlot() {
        return 2;
    }

    public ItemStack getItem(int index) {
        return this.getContainerForSlot(index).m_8020_(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.getContainerForSlot(index).m_6836_(index, stack);
    }

    protected Container getContainerForSlot(int index) {
        return index == this.getResultSlot() ? this.f_39768_ : this.f_39769_;
    }

    public void growItem(int index, int amount) {
        ItemStack stack = this.getItem(index);
        stack.m_41769_(amount);
        this.setItem(index, stack);
    }

    protected boolean m_6560_(Player player, boolean hasStack) {
        return true;
    }

    protected void m_142365_(Player player, ItemStack stack) {
        ItemStack input1 = this.getItem(0);
        ItemStack input2 = this.getItem(1);
        if (this.isRemovingInsulation()) {
            ItemInsulationManager.getInsulationCap(input1).ifPresent(cap -> {
                if (!cap.getInsulation().isEmpty()) {
                    if (!player.m_150110_().f_35937_) {
                        input2.m_41622_(1, (LivingEntity)player, item -> {});
                    }
                    cap.removeInsulationItem(cap.getInsulationItem(cap.getInsulation().size() - 1));
                    player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.8f, 1.0f);
                }
            });
            this.m_6640_();
            this.m_150429_();
        } else if (ItemInsulationManager.isInsulatable(stack)) {
            if (!this.quickMoving) {
                this.growItem(0, -1);
                this.growItem(1, -1);
            }
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_12100_, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementTriggers.ARMOR_INSULATED.trigger(serverPlayer, input1, input2);
            }
        }
        SoundEvent equipSound = stack.m_41720_().m_142602_();
        if (equipSound != null) {
            player.f_19853_.m_5594_(null, player.m_20183_(), equipSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected boolean m_8039_(BlockState state) {
        return state.m_60713_(ModBlocks.SEWING_TABLE);
    }

    public void m_6640_() {
        if (this.quickMoving) {
            return;
        }
        ItemStack wearableItem = this.getItem(0);
        ItemStack insulatorItem = this.getItem(1);
        if (wearableItem.m_41619_() || insulatorItem.m_41619_()) {
            this.setItem(this.getResultSlot(), ItemStack.f_41583_);
            return;
        }
        if (ItemInsulationManager.isInsulatable(wearableItem)) {
            ItemStack processed;
            if (this.isRemovingInsulation()) {
                ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> {
                    if (!cap.getInsulation().isEmpty()) {
                        this.setItem(this.getResultSlot(), cap.getInsulationItem(cap.getInsulation().size() - 1).m_41777_());
                    }
                });
            } else if (!(ConfigSettings.INSULATION_ITEMS.get().get((Object)insulatorItem.m_41720_()).isEmpty() || insulatorItem.m_41720_() instanceof Wearable && LivingEntity.m_147233_((ItemStack)wearableItem) != LivingEntity.m_147233_((ItemStack)insulatorItem) || !this.insulateArmorItem(processed = wearableItem.m_41777_(), insulatorItem))) {
                ItemInsulationManager.getInsulationCap(wearableItem).ifPresent(cap -> processed.m_41784_().m_128391_((CompoundTag)cap.serializeNBT()));
                this.setItem(this.getResultSlot(), processed);
            }
        }
    }

    private boolean insulateArmorItem(ItemStack armorItem, ItemStack insulatorItem) {
        if (!ItemInsulationManager.isInsulatable(armorItem)) {
            return false;
        }
        InsulateItemEvent insulateEvent = new InsulateItemEvent(armorItem, insulatorItem, this.f_39771_);
        MinecraftForge.EVENT_BUS.post((Event)insulateEvent);
        if (insulateEvent.isCanceled()) {
            return false;
        }
        insulatorItem = insulateEvent.getInsulator();
        IInsulatableCap insulCap = (IInsulatableCap)ItemInsulationManager.getInsulationCap(armorItem).orElseThrow(() -> new IllegalStateException(String.format("Item %s does not have insulation capability", armorItem)));
        ItemStack insulator = insulatorItem.m_41777_();
        insulator.m_41764_(1);
        if (!insulCap.canAddInsulationItem(armorItem, insulator)) {
            return false;
        }
        insulCap.addInsulationItem(insulator);
        if (armorItem.m_41792_()) {
            Map armorEnch = EnchantmentHelper.m_44831_((ItemStack)armorItem);
            insulator.m_41785_().removeIf(nbt -> {
                CompoundTag enchantTag = (CompoundTag)nbt;
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantTag.m_128461_("id")));
                if (ench == null) {
                    return false;
                }
                if (ench.m_6081_(armorItem) && armorEnch.keySet().stream().allMatch(ench2 -> ench2.m_44695_(ench))) {
                    armorItem.m_41663_(ench, enchantTag.m_128451_("lvl"));
                    return true;
                }
                return false;
            });
        }
        return true;
    }

    public boolean isRemovingInsulation() {
        return this.getItem(1).m_204117_(Tags.Items.SHEARS);
    }

    public void m_6877_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < this.f_39769_.m_6643_(); ++i) {
                ItemStack itemStack = this.m_38853_(i).m_7993_();
                if (itemStack.m_41619_()) continue;
                if (player.m_6084_() && !serverPlayer.m_9232_()) {
                    player.m_150109_().m_150079_(itemStack);
                    continue;
                }
                player.m_36176_(itemStack, true);
            }
        }
        super.m_6877_(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_7648_(Player player, int index) {
        try {
            if (index == this.getResultSlot() && !this.isRemovingInsulation()) {
                this.quickMoving = true;
                Slot resultSlot = (Slot)this.f_38839_.get(index);
                ItemStack result = resultSlot.m_7993_();
                if (result.m_41619_()) {
                    ItemStack itemStack = result;
                    return itemStack;
                }
                do {
                    this.growItem(0, -1);
                    this.growItem(1, -1);
                } while (this.insulateArmorItem(result, this.getItem(1)));
            }
        }
        finally {
            this.quickMoving = false;
        }
        return super.m_7648_(player, index);
    }
}

