/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.fluid;

import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class SlushFluidType
extends FluidType {
    public SlushFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public double motionScale(Entity entity) {
        return 0.00235;
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation SLUSH_STILL = new ResourceLocation("cold_sweat", "block/slush_still");
            private static final ResourceLocation SLUSH_FLOW = new ResourceLocation("cold_sweat", "block/slush_flow");

            public ResourceLocation getStillTexture() {
                return SLUSH_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return SLUSH_FLOW;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                int color = BiomeColors.m_108811_((BlockAndTintGetter)getter, (BlockPos)pos);
                int red = FastColor.ARGB32.m_13665_((int)color);
                int green = FastColor.ARGB32.m_13667_((int)color);
                int blue = FastColor.ARGB32.m_13669_((int)color);
                int alphaColor = FastColor.ARGB32.m_13660_((int)240, (int)red, (int)green, (int)blue);
                int white = FastColor.ARGB32.m_13660_((int)240, (int)255, (int)255, (int)255);
                return CSMath.blendColors(alphaColor, white, 0.5f);
            }
        });
    }
}

