/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeTempData
extends ConfigData {
    final NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes;
    final double min;
    final double max;
    final Temperature.Units units;
    final double waterTemp;
    final boolean isOffset;
    final boolean isDisabled;
    public static final Codec<BiomeTempData> CODEC = BiomeTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registry.f_122885_)).fieldOf("biomes").forGetter(BiomeTempData::biomes), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("min_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(BiomeTempData::min), (App)Codec.mapEither((MapCodec)Codec.DOUBLE.fieldOf("temperature"), (MapCodec)Codec.DOUBLE.fieldOf("max_temp")).xmap(either -> (Double)either.map(left -> left, right -> right), Either::right).forGetter(BiomeTempData::max), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(BiomeTempData::units), (App)Codec.DOUBLE.optionalFieldOf("water_temp", (Object)Double.NaN).forGetter(BiomeTempData::waterTemp), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(BiomeTempData::isOffset), (App)Codec.BOOL.optionalFieldOf("disable", (Object)false).forGetter(BiomeTempData::isDisabled)).apply((Applicative)instance, BiomeTempData::new)));

    public BiomeTempData(NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes, double min, double max, Temperature.Units units, double waterTemp, boolean isOffset, boolean isDisabled, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.biomes = biomes;
        this.min = min;
        this.max = max;
        this.units = units;
        this.isOffset = isOffset;
        this.isDisabled = isDisabled;
        if (Double.isNaN(waterTemp)) {
            waterTemp = isOffset ? 0.0 : ConfigSettings.DEFAULT_WATER_TEMPERATURE.get();
        }
        this.waterTemp = waterTemp;
    }

    public BiomeTempData(NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes, double min, double max, Temperature.Units units, double waterTemp, boolean isOffset, boolean isDisabled) {
        this(biomes, min, max, units, waterTemp, isOffset, isDisabled, new NegatableList<String>());
    }

    public BiomeTempData(OptionalHolder<Biome> biome, double min, double max, Temperature.Units units, double waterTemp, boolean isOffset, boolean isDisabled) {
        this(new NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>>(Either.right(biome)), min, max, units, waterTemp, isOffset, isDisabled);
    }

    public NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes() {
        return this.biomes;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public double waterTemp() {
        return this.waterTemp;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public double minTemp() {
        return Temperature.convert(this.min, this.units, Temperature.Units.MC, !this.isOffset);
    }

    public double maxTemp() {
        return Temperature.convert(this.max, this.units, Temperature.Units.MC, !this.isOffset);
    }

    @Nullable
    public static BiomeTempData fromToml(List<?> entry, boolean isOffset, RegistryAccess registryAccess) {
        String string;
        if (!(entry.size() == 2 && entry.get(1) instanceof String || entry.size() >= 3)) {
            ColdSweat.LOGGER.error("Error parsing biome config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<Biome>, OptionalHolder<Biome>>> biomes = ConfigHelper.parseRegistryItems(Registry.f_122885_, registryAccess, (String)entry.get(0));
        if (biomes.isEmpty()) {
            return null;
        }
        Temperature.Units units = Temperature.Units.MC;
        double min = 0.0;
        double max = 0.0;
        double waterTemp = Double.NaN;
        boolean isDisabled = false;
        Object obj = entry.get(1);
        if (obj instanceof String && (string = (String)obj).equals("disable")) {
            isDisabled = true;
        } else {
            min = ((Number)entry.get(1)).doubleValue();
            max = ((Number)entry.get(2)).doubleValue();
            if (entry.size() >= 4) {
                units = Temperature.Units.fromID(((String)entry.get(3)).toUpperCase());
            }
            if (entry.size() >= 5) {
                waterTemp = Temperature.convert(((Number)entry.get(4)).doubleValue(), units, Temperature.Units.MC, true);
            }
        }
        return new BiomeTempData(biomes, min, max, units, waterTemp, isOffset, isDisabled);
    }

    public Codec<BiomeTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeTempData that = (BiomeTempData)obj;
        return super.equals(obj) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0 && this.isOffset == that.isOffset && this.biomes.equals(that.biomes) && this.units == that.units;
    }
}

