/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.data.codec.util.WorldTempBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public record LocationRequirement(IntegerBounds x, IntegerBounds y, IntegerBounds z, int xOffset, int yOffset, int zOffset, NegatableList<Either<TagKey<Biome>, ResourceKey<Biome>>> biome, NegatableList<Either<TagKey<Structure>, ResourceKey<Structure>>> structure, NegatableList<Either<TagKey<Level>, ResourceKey<Level>>> dimension, IntegerBounds light, BlockRequirement block, FluidRequirement fluid, WorldTempBounds temperature, Optional<Predicate<BlockInWorld>> predicate) {
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntegerBounds.CODEC.optionalFieldOf("x", (Object)IntegerBounds.NONE).forGetter(location -> location.x), (App)IntegerBounds.CODEC.optionalFieldOf("y", (Object)IntegerBounds.NONE).forGetter(location -> location.y), (App)IntegerBounds.CODEC.optionalFieldOf("z", (Object)IntegerBounds.NONE).forGetter(location -> location.z), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(location -> location.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(location -> location.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(location -> location.zOffset), (App)NegatableList.codec(ConfigHelper.tagOrResourceKeyCodec(Registry.f_122885_)).optionalFieldOf("biome", new NegatableList()).forGetter(location -> location.biome), (App)NegatableList.codec(ConfigHelper.tagOrResourceKeyCodec(Registry.f_235725_)).optionalFieldOf("structure", new NegatableList()).forGetter(location -> location.structure), (App)NegatableList.codec(ConfigHelper.tagOrResourceKeyCodec(Registry.f_122819_)).optionalFieldOf("dimension", new NegatableList()).forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light", (Object)IntegerBounds.NONE).forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block", (Object)BlockRequirement.NONE).forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid", (Object)FluidRequirement.NONE).forGetter(location -> location.fluid), (App)WorldTempBounds.CODEC.optionalFieldOf("temperature", (Object)WorldTempBounds.NONE).forGetter(location -> location.temperature)).apply((Applicative)instance, LocationRequirement::new));
    public static final LocationRequirement NONE = new LocationRequirement(IntegerBounds.NONE, IntegerBounds.NONE, IntegerBounds.NONE, 0, 0, 0, new NegatableList<Either<TagKey<Biome>, ResourceKey<Biome>>>(), new NegatableList<Either<TagKey<Structure>, ResourceKey<Structure>>>(), new NegatableList<Either<TagKey<Level>, ResourceKey<Level>>>(), IntegerBounds.NONE, BlockRequirement.NONE, FluidRequirement.NONE, WorldTempBounds.NONE);

    public LocationRequirement(IntegerBounds x, IntegerBounds y, IntegerBounds z, int xOffset, int yOffset, int zOffset, NegatableList<Either<TagKey<Biome>, ResourceKey<Biome>>> biome, NegatableList<Either<TagKey<Structure>, ResourceKey<Structure>>> structure, NegatableList<Either<TagKey<Level>, ResourceKey<Level>>> dimension, IntegerBounds light, BlockRequirement block, FluidRequirement fluid, WorldTempBounds temperature) {
        this(x, y, z, xOffset, yOffset, zOffset, biome, structure, dimension, light, block, fluid, temperature, Optional.empty());
    }

    public LocationRequirement(Predicate<BlockInWorld> predicate) {
        this(IntegerBounds.NONE, IntegerBounds.NONE, IntegerBounds.NONE, 0, 0, 0, new NegatableList<Either<TagKey<Biome>, ResourceKey<Biome>>>(), new NegatableList<Either<TagKey<Structure>, ResourceKey<Structure>>>(), new NegatableList<Either<TagKey<Level>, ResourceKey<Level>>>(), IntegerBounds.NONE, BlockRequirement.NONE, FluidRequirement.NONE, WorldTempBounds.NONE, Optional.of(predicate));
    }

    public boolean test(Level level, Vec3 pos) {
        return this.test(level, new BlockPos(pos));
    }

    public boolean test(Level level, BlockPos origin) {
        StructureManager structureManager;
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(new BlockInWorld((LevelReader)level, origin, true));
        }
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        pos.m_122184_(this.xOffset, this.yOffset, this.zOffset);
        if (!this.x.test(pos.m_123341_())) {
            return false;
        }
        if (!this.y.test(pos.m_123342_())) {
            return false;
        }
        if (!this.z.test(pos.m_123343_())) {
            return false;
        }
        if (!this.dimension.test(either -> (Boolean)either.map(tag -> level.m_204156_().m_203373_(tag.f_203868_()), key -> level.m_46472_().equals(key)))) {
            return false;
        }
        if (!this.biome.test(either -> (Boolean)either.map(tag -> level.m_7062_().m_204216_((BlockPos)pos).m_203656_(tag), key -> level.m_7062_().m_204216_((BlockPos)pos).m_203565_(key)))) {
            return false;
        }
        if (!this.structure.isEmpty() && !this.structure.test(arg_0 -> LocationRequirement.lambda$test$22(structureManager = WorldHelper.getServerLevel(level).m_215010_(), pos, arg_0))) {
            return false;
        }
        if (!this.light.test(level.m_46803_((BlockPos)pos))) {
            return false;
        }
        if (!this.block.test(level, (BlockPos)pos)) {
            return false;
        }
        if (!this.fluid.test(level, (BlockPos)pos)) {
            return false;
        }
        return this.temperature == WorldTempBounds.NONE || this.temperature.test(WorldHelper.getRoughTemperatureAt(level, (BlockPos)pos));
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }

    private static /* synthetic */ boolean lambda$test$22(StructureManager structureManager, BlockPos.MutableBlockPos pos, Either either) {
        StructureStart structureStart = (StructureStart)either.map(tag -> structureManager.m_220491_((BlockPos)pos, tag), key -> structureManager.m_220488_((BlockPos)pos, key));
        return structureStart != null && structureStart != StructureStart.f_73561_;
    }
}

