/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FreezeShiverEffect
extends TempEffect {
    public FreezeShiverEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void shiverCamera(EntityViewRenderEvent.CameraSetup event) {
        if (!this.test((Entity)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        LivingEntity entity = this.entity();
        if (!Minecraft.m_91087_().m_91104_() && ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
            double effect = this.getEffectFactor();
            double tickTime = (double)entity.f_19797_ + event.getPartialTicks();
            float shiverIntensity = (float)CSMath.blend(0.0, (Math.sin(tickTime / 10.0) + 1.0) * (double)0.03f + (double)0.01f, effect, 0.0, 1.0);
            shiverIntensity = (float)((double)shiverIntensity * ConfigSettings.SHIVER_INTENSITY.get());
            float shiverRotation = (float)(Math.sin(tickTime * 2.5) * (double)(shiverIntensity *= Minecraft.m_91087_().m_91297_() * 10.0f));
            entity.m_146922_(entity.m_146908_() + shiverRotation);
        }
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

