/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.mojang.math.Vector4f;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.temperature.effect.player.AbstractVignetteEffect;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HeatVignetteEffect
extends AbstractVignetteEffect {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cold_sweat", "textures/gui/overlay/haze.png");

    public HeatVignetteEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected Vector4f getColor(float tickTime) {
        float vignetteBrightness = (float)(Math.sin((double)(tickTime + 3.0f) / Math.PI) / 2.0 + 0.5);
        return new Vector4f(0.231f, 0.0f, 0.0f, vignetteBrightness);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void render(float opacity, float tickTime, RenderGameOverlayEvent.PreLayer event) {
        opacity = (float)((double)opacity * ConfigSettings.HEATSTROKE_BORDER_OPACITY.get());
        super.render(opacity, tickTime, event);
    }
}

