/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.particle;

import com.momosoftworks.coldsweat.client.particle.ParticleUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VaporParticle
extends TextureSheetParticle {
    private final SpriteSet ageSprite;
    private final boolean hasGravity;
    private boolean collidedY;
    private float maxAlpha;
    VaporType type;

    protected VaporParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, VaporType type) {
        super(world, x, y, z);
        this.ageSprite = spriteSet;
        this.f_107230_ = 0.0f;
        this.maxAlpha = (float)(Math.random() / 3.0 + 0.5);
        this.m_6569_(3.0f + (float)(Math.random() / 2.5));
        this.m_107250_(this.f_107663_ / 10.0f, this.f_107663_ / 10.0f);
        this.f_107225_ = 40 + (int)(Math.random() * 20.0 - 10.0);
        this.f_107219_ = true;
        this.m_172260_(vx, vy, vz);
        this.m_108339_(spriteSet);
        this.hasGravity = type == VaporType.GROUND_MIST;
        this.type = type;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case STEAM: {
                float f = -0.04f;
                break;
            }
            case GROUND_MIST: {
                float f = 0.04f;
                break;
            }
            case MIST: {
                float f = this.f_107226_ = 0.0f;
            }
        }
        if (type == VaporType.MIST) {
            this.maxAlpha = 0.2f;
        }
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return ParticleUtil.PARTICLE_SHEET_TRANSPARENT;
    }

    public void m_5989_() {
        if (Minecraft.m_91087_().f_91066_.f_92073_ == ParticleStatus.MINIMAL) {
            this.m_107274_();
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_ * (this.f_107218_ ? 1.0 : 0.2), this.f_107216_, this.f_107217_ * (this.f_107218_ ? 1.0 : 0.2));
            this.f_107215_ *= 0.99;
            this.f_107216_ *= 0.99;
            this.f_107215_ *= 0.99;
        }
        this.m_108339_(this.ageSprite);
        if (this.type == VaporType.GROUND_MIST) {
            if (this.f_107230_ < this.maxAlpha) {
                this.f_107230_ += 0.02f;
            } else if (this.f_107224_ > 32) {
                this.f_107230_ -= 0.02f;
            }
            if ((double)this.f_107230_ < 0.035 && this.f_107224_ > 10) {
                this.m_107274_();
            }
        } else if (this.type == VaporType.MIST || this.type == VaporType.STEAM) {
            if (this.f_107230_ < this.maxAlpha) {
                this.f_107230_ += this.maxAlpha / 20.0f;
            } else if ((float)this.f_107224_ > this.maxAlpha / (this.maxAlpha / 20.0f)) {
                this.f_107230_ -= this.maxAlpha / 20.0f;
            }
            if ((double)this.f_107230_ < 0.02 && this.f_107224_ > 10) {
                this.m_107274_();
            }
        }
    }

    public void m_6257_(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 vec3 = Entity.m_198894_((Entity)null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec3.f_82479_;
            y = vec3.f_82480_;
            z = vec3.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, this.collidedY ? 0.0 : y, z));
            AABB axisalignedbb = this.m_107277_();
            this.f_107212_ = (axisalignedbb.f_82288_ + axisalignedbb.f_82291_) / 2.0;
            this.f_107213_ = axisalignedbb.f_82289_ + (this.hasGravity ? 0.2 : 0.0);
            this.f_107214_ = (axisalignedbb.f_82290_ + axisalignedbb.f_82293_) / 2.0;
        }
        if (Math.abs(d1) >= 1.0E-5 && Math.abs(y) < 1.0E-5) {
            this.collidedY = true;
        }
        boolean bl = this.f_107218_ = d1 != y && d1 < 0.0;
        if (d0 != x) {
            this.f_107215_ = 0.0;
        }
        if (d2 != z) {
            this.f_107217_ = 0.0;
        }
    }

    public static enum VaporType {
        STEAM,
        GROUND_MIST,
        MIST;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MistFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public MistFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GroundMistFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GroundMistFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.GROUND_MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SteamFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SteamFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (Minecraft.m_91087_().f_91066_.f_92073_ != ParticleStatus.MINIMAL) {
                return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.STEAM);
            }
            return null;
        }
    }
}

