/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.event;

import com.momosoftworks.coldsweat.api.event.core.init.EnableTemperatureEvent;
import com.momosoftworks.coldsweat.api.event.vanilla.ServerConfigsLoadedEvent;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModAttributes;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class AddTempAttributes {
    private static final Field FORGE_ATTRIBUTES;

    private static Map<EntityType<? extends LivingEntity>, AttributeSupplier> getForgeAttributes() {
        try {
            return (Map)FORGE_ATTRIBUTES.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onEntitiesCreated(ServerConfigsLoadedEvent event) {
        for (EntityType entityType : ForgeRegistries.ENTITIES.getValues()) {
            EntityType type;
            try {
                type = entityType;
            }
            catch (ClassCastException e) {
                continue;
            }
            if (type == EntityType.f_20532_) continue;
            EnableTemperatureEvent enableEvent = new EnableTemperatureEvent(type);
            MinecraftForge.EVENT_BUS.post((Event)enableEvent);
            if (!enableEvent.isEnabled() || enableEvent.isCanceled()) continue;
            EntityTempManager.TEMPERATURE_ENABLED_ENTITIES.add((EntityType<? extends LivingEntity>)type);
            AttributeSupplier attributes = CSMath.orElse(AddTempAttributes.getForgeAttributes().get(type), DefaultAttributes.m_22297_((EntityType)type));
            if (attributes == null) continue;
            AttributeSupplier.Builder builder = new AttributeSupplier.Builder(attributes);
            builder.m_22268_(ModAttributes.COLD_DAMPENING, Double.NaN);
            builder.m_22268_(ModAttributes.HEAT_DAMPENING, Double.NaN);
            builder.m_22268_(ModAttributes.COLD_RESISTANCE, Double.NaN);
            builder.m_22268_(ModAttributes.HEAT_RESISTANCE, Double.NaN);
            builder.m_22268_(ModAttributes.BURNING_POINT, Double.NaN);
            builder.m_22268_(ModAttributes.FREEZING_POINT, Double.NaN);
            builder.m_22268_(ModAttributes.BASE_BODY_TEMPERATURE, Double.NaN);
            builder.m_22268_(ModAttributes.WORLD_TEMPERATURE, Double.NaN);
            builder.m_22268_(ModAttributes.TEMP_RATE, Double.NaN);
            AddTempAttributes.getForgeAttributes().put((EntityType<? extends LivingEntity>)type, builder.m_22265_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEnableTemperatureEvent(EnableTemperatureEvent event) {
        if (event.getEntityType() == ModEntities.CHAMELEON || ConfigSettings.ENABLE_ENTITY_CLIMATES.get().booleanValue() && EntityTempManager.hasClimateData(event.getEntityType())) {
            event.setEnabled(true);
        }
    }

    static {
        try {
            FORGE_ATTRIBUTES = ForgeHooks.class.getDeclaredField("FORGE_ATTRIBUTES");
            FORGE_ATTRIBUTES.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForPlayer {
        @SubscribeEvent
        public static void addPlayerAttributes(EntityAttributeModificationEvent event) {
            event.add(EntityType.f_20532_, ModAttributes.COLD_DAMPENING, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.HEAT_DAMPENING, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.COLD_RESISTANCE, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.HEAT_RESISTANCE, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.BURNING_POINT, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.FREEZING_POINT, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.BASE_BODY_TEMPERATURE, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.WORLD_TEMPERATURE, Double.NaN);
            event.add(EntityType.f_20532_, ModAttributes.TEMP_RATE, Double.NaN);
        }
    }
}

