/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.init;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.core.registry.BlockTempRegisterEvent;
import com.momosoftworks.coldsweat.api.event.core.registry.TempModifierRegisterEvent;
import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.FurnaceBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.NetherPortalBlockTemp;
import com.momosoftworks.coldsweat.api.temperature.modifier.AcclimationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ArmorInsulationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.BlockTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.CaveBiomeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ElevationTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntitiesTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.EntityClimateTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FreezingTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.FrigidnessTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.InventoryItemsTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.MountTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.ShadeTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SimpleTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulLampTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.SoulSproutTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WarmthTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigLoadingHandler;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TempModifierInit {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void fireRegisterModifiers(ServerAboutToStartEvent event) {
        TempModifierInit.buildModifierRegistries();
    }

    public static void buildModifierRegistries() {
        TempModifierRegistry.flush();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new TempModifierRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering TempModifiers failed!");
            throw e;
        }
    }

    public static void buildBlockRegistries() {
        try {
            MinecraftForge.EVENT_BUS.post((Event)new BlockTempRegisterEvent());
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Registering BlockTemps failed!");
            throw e;
        }
    }

    public static void buildBlockConfigs() {
        List blockTemps = WorldSettingsConfig.BLOCK_TEMPERATURES.get().stream().map(BlockTempData::fromToml).filter(Objects::nonNull).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        ConfigLoadingHandler.modifyEntries(blockTemps, ModRegistries.BLOCK_TEMP_DATA);
        for (BlockTempData blockConfig : blockTemps) {
            ConfiguredBlockTemp blockTemp = new ConfiguredBlockTemp(blockConfig);
            BlockTempRegistry.register(blockTemp);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerBlockTemps(BlockTempRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        event.register(new FurnaceBlockTemp());
        event.register(new NetherPortalBlockTemp());
        ColdSweat.LOGGER.debug("Registered BlockTemps in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerTempModifiers(TempModifierRegisterEvent event) {
        long startMS = System.currentTimeMillis();
        event.register(new ResourceLocation("cold_sweat", "blocks"), BlockTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "biomes"), BiomeTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "shade"), ShadeTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "elevation"), ElevationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "cave_biomes"), CaveBiomeTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "armor"), ArmorInsulationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "mount"), MountTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "waterskin"), WaterskinTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soulspring_lamp"), SoulLampTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "water"), WaterTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "warming"), WarmthTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "cooling"), FrigidnessTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "food"), FoodTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "freezing"), FreezingTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "soul_sprout"), SoulSproutTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "inventory_items"), InventoryItemsTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "entities"), EntitiesTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "acclimation"), AcclimationTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "climate"), EntityClimateTempModifier::new);
        event.register(new ResourceLocation("cold_sweat", "simple"), SimpleTempModifier::new);
        String compatPath = "com.momosoftworks.coldsweat.api.temperature.modifier.compat.";
        String sereneSeasons = compatPath + "SereneSeasonsTempModifier";
        String weatherStorms = compatPath + "StormTempModifier";
        String curios = compatPath + "CuriosTempModifier";
        String valkyrienSkies = compatPath + "ValkShipBlockTempModifier";
        if (CompatManager.isSereneSeasonsLoaded()) {
            event.registerByClassName(new ResourceLocation("sereneseasons", "season"), sereneSeasons, new Object[0]);
        }
        if (CompatManager.isWeather2Loaded()) {
            event.registerByClassName(new ResourceLocation("weather2", "storm"), weatherStorms, new Object[0]);
        }
        if (CompatManager.isCuriosLoaded()) {
            event.registerByClassName(new ResourceLocation("curios", "curios"), curios, new Object[0]);
        }
        if (CompatManager.isValkyrienSkiesLoaded()) {
            event.registerByClassName(new ResourceLocation("valkyrienskies", "ship_blocks"), valkyrienSkies, new Object[0]);
        }
        ColdSweat.LOGGER.debug("Registered TempModifiers in {}ms", (Object)(System.currentTimeMillis() - startMS));
    }
}

