/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class EntityMountMessage {
    int entity;
    int vehicle;
    Action action;

    public EntityMountMessage(int entity, int vehicle, Action action) {
        this.entity = entity;
        this.vehicle = vehicle;
        this.action = action;
    }

    public static void encode(EntityMountMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entity);
        buffer.writeInt(message.vehicle);
        buffer.m_130068_((Enum)message.action);
    }

    public static EntityMountMessage decode(FriendlyByteBuf buffer) {
        return new EntityMountMessage(buffer.readInt(), buffer.readInt(), (Action)buffer.m_130066_(Action.class));
    }

    public static void handle(EntityMountMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                Entity entity = mc.f_91073_.m_6815_(message.entity);
                Entity vehicle = mc.f_91073_.m_6815_(message.vehicle);
                if (message.action == Action.MOUNT) {
                    entity.m_7998_(vehicle, true);
                } else if (entity.m_20202_().m_142049_() == message.vehicle) {
                    entity.m_8127_();
                }
            });
        }
        context.setPacketHandled(true);
    }

    public static enum Action {
        MOUNT,
        DISMOUNT;

    }
}

