/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkEvent;

public class SyncPreferencesMessage {
    EnumMap<Preference, Object> preferences = new EnumMap(Preference.class);

    public static SyncPreferencesMessage create() {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        for (Preference preference : Preference.values()) {
            message.preferences.put(preference, preference.getter().get());
        }
        return message;
    }

    public static void encode(SyncPreferencesMessage message, FriendlyByteBuf buffer) {
        if (EffectiveSide.get().isClient()) {
            SyncPreferencesMessage.savePreferences(ClientOnlyHelper.getClientPlayer(), message.preferences);
        }
        AtomicReference pref = new AtomicReference();
        buffer.writeInt(message.preferences.size());
        message.preferences.forEach((key, value) -> {
            pref.set(key);
            buffer.m_130068_((Enum)key);
            ((Preference)((Object)((Object)pref.get()))).writer().accept(buffer, value);
        });
    }

    public static SyncPreferencesMessage decode(FriendlyByteBuf buffer) {
        SyncPreferencesMessage message = new SyncPreferencesMessage();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            Preference preference = (Preference)buffer.m_130066_(Preference.class);
            Object value = preference.reader().apply(buffer);
            message.preferences.put(preference, value);
        }
        return message;
    }

    public static void handle(SyncPreferencesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer() && context.getSender() != null) {
                ServerPlayer player = context.getSender();
                SyncPreferencesMessage.savePreferences((Player)player, message.preferences);
            }
        });
        context.setPacketHandled(true);
    }

    private static void savePreferences(Player player, EnumMap<Preference, Object> preferences) {
        CompoundTag nbt = player.getPersistentData();
        CompoundTag preferencesTag = new CompoundTag();
        for (Preference preference : Preference.values()) {
            preferencesTag.m_128365_(preference.key(), NBTHelper.serialize(preferences.get((Object)preference)));
        }
        nbt.m_128365_("ColdSweatPreferences", (Tag)preferencesTag);
    }
}

