/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.RegistryHolder;
import com.momosoftworks.coldsweat.data.codec.configuration.BiomeTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.BlockTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DepthTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DimensionTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.DryingItemData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemInsulationSlotsData;
import com.momosoftworks.coldsweat.data.codec.configuration.ItemTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.MountData;
import com.momosoftworks.coldsweat.data.codec.configuration.RegistryModifierData;
import com.momosoftworks.coldsweat.data.codec.configuration.SpawnBiomeData;
import com.momosoftworks.coldsweat.data.codec.configuration.StructureTempData;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.util.math.FastMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ModRegistries {
    private static final Map<ResourceLocation, RegistryHolder<? extends ConfigData>> REGISTRIES = new FastMap<ResourceLocation, RegistryHolder<? extends ConfigData>>();
    public static final RegistryHolder<InsulatorData> INSULATOR_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/insulator"), InsulatorData.CODEC, InsulatorData.class);
    public static final RegistryHolder<FuelData> FUEL_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/fuel"), FuelData.CODEC, FuelData.class);
    public static final RegistryHolder<FoodData> FOOD_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/food"), FoodData.CODEC, FoodData.class);
    public static final RegistryHolder<ItemTempData> ITEM_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/item_temp"), ItemTempData.CODEC, ItemTempData.class);
    public static final RegistryHolder<DryingItemData> DRYING_ITEM_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/drying_item"), DryingItemData.CODEC, DryingItemData.class);
    public static final RegistryHolder<ItemInsulationSlotsData> INSULATION_SLOTS_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "item/insulation_slots"), ItemInsulationSlotsData.CODEC, ItemInsulationSlotsData.class);
    public static final RegistryHolder<BlockTempData> BLOCK_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "block/block_temp"), BlockTempData.CODEC, BlockTempData.class);
    public static final RegistryHolder<BiomeTempData> BIOME_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "world/biome_temp"), BiomeTempData.CODEC, BiomeTempData.class);
    public static final RegistryHolder<DimensionTempData> DIMENSION_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "world/dimension_temp"), DimensionTempData.CODEC, DimensionTempData.class);
    public static final RegistryHolder<StructureTempData> STRUCTURE_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "world/structure_temp"), StructureTempData.CODEC, StructureTempData.class);
    public static final RegistryHolder<DepthTempData> DEPTH_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "world/temp_region"), DepthTempData.CODEC, DepthTempData.class);
    public static final RegistryHolder<MountData> MOUNT_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "entity/mount"), MountData.CODEC, MountData.class);
    public static final RegistryHolder<SpawnBiomeData> ENTITY_SPAWN_BIOME_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "entity/spawn_biome"), SpawnBiomeData.CODEC, SpawnBiomeData.class);
    public static final RegistryHolder<EntityTempData> ENTITY_TEMP_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "entity/entity_temp"), EntityTempData.CODEC, EntityTempData.class);
    public static final RegistryHolder<EntityClimateData> ENTITY_CLIMATE_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "entity/climate"), EntityClimateData.CODEC, EntityClimateData.class);
    public static final RegistryHolder<TempEffectsData> TEMP_EFFECTS_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "entity/temp_effects"), TempEffectsData.CODEC, TempEffectsData.class);
    public static final RegistryHolder<RegistryModifierData<?>> REGISTRY_MODIFIER_DATA = ModRegistries.createRegistry(new ResourceLocation("cold_sweat", "modifier"), RegistryModifierData.CODEC, RegistryModifierData.class);

    public static <V extends ConfigData> RegistryHolder<V> createRegistry(ResourceLocation registry, Codec<V> codec, Class<V> type) {
        RegistryHolder<V> registryHolder = new RegistryHolder<V>(ResourceKey.m_135788_((ResourceLocation)registry), codec, type);
        REGISTRIES.put(registry, registryHolder);
        return registryHolder;
    }

    public static Map<ResourceLocation, RegistryHolder<?>> getRegistries() {
        return ImmutableMap.copyOf(REGISTRIES);
    }

    public static ResourceKey<? extends Registry<? extends ConfigData>> getRegistryKey(ResourceLocation name) {
        return Optional.ofNullable(REGISTRIES.get(name)).map(RegistryHolder::key).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + name)));
    }

    public static <T extends ConfigData> RegistryHolder<T> getRegistry(ResourceKey<Registry<T>> key) {
        return Optional.ofNullable(REGISTRIES.get(key.m_135782_())).map(reg -> reg).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + key.m_135782_())));
    }

    public static <T extends ConfigData> Codec<T> getCodec(ResourceKey<Registry<T>> registry) {
        return Optional.of(REGISTRIES.get(registry.m_135782_())).map(RegistryHolder::codec).orElseThrow(() -> (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Unknown Cold Sweat registry: " + registry.m_135782_().m_135815_())));
    }
}

