/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.data.ModRegistries;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class RegistryModifierData<T extends ConfigData>
extends ConfigData
implements IForgeRegistryEntry<RegistryModifierData<T>> {
    private final ResourceKey<Registry<T>> registry;
    private final List<ConfigData.Type> registryTypes;
    private final NegatableList<NbtRequirement> matches;
    private final List<ResourceLocation> entries;
    private final List<Operation> operations;
    private static final Codec<List<ConfigData.Type>> CONFIG_TYPE_CODEC = Codec.either(ConfigData.Type.CODEC, (Codec)ConfigData.Type.CODEC.listOf()).xmap(either -> (List)either.map(List::of, r -> r), Either::right);
    public static final Codec<RegistryModifierData<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.xmap(s -> ModRegistries.getRegistryKey(s), key -> key.m_135782_()).fieldOf("registry").forGetter(data -> data.registry()), (App)CONFIG_TYPE_CODEC.optionalFieldOf("config_type", List.of()).forGetter(RegistryModifierData::configTypes), (App)NegatableList.listCodec(NbtRequirement.CODEC).optionalFieldOf("matches", new NegatableList()).forGetter(RegistryModifierData::matches), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("entries", List.of()).forGetter(RegistryModifierData::entries), (App)Operation.CODEC.listOf().optionalFieldOf("operations", List.of()).forGetter(data -> data.operations)).apply((Applicative)instance, RegistryModifierData::new));

    public RegistryModifierData(ResourceKey<Registry<T>> registry, List<ConfigData.Type> registryTypes, NegatableList<NbtRequirement> matches, List<ResourceLocation> entries, List<Operation> operations) {
        super(new NegatableList<String>());
        this.registry = registry;
        this.registryTypes = registryTypes;
        this.matches = matches;
        this.entries = entries;
        this.operations = operations;
    }

    public ResourceKey<Registry<T>> registry() {
        return this.registry;
    }

    public List<ConfigData.Type> configTypes() {
        return this.registryTypes;
    }

    public NegatableList<NbtRequirement> matches() {
        return this.matches;
    }

    public List<ResourceLocation> entries() {
        return this.entries;
    }

    public List<Operation> modifications() {
        return this.operations;
    }

    private boolean checkType(T object) {
        return this.registryTypes.isEmpty() || this.registryTypes.contains((Object)((ConfigData)object).configType());
    }

    public boolean matches(T object) {
        if (!this.checkType(object)) {
            return false;
        }
        if (this.matches.isEmpty()) {
            return false;
        }
        Optional serializedOpt = ((ConfigData)object).getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, object).result();
        return serializedOpt.map(serialized -> this.matches.test(nbt -> nbt.test((CompoundTag)serialized))).orElse(false);
    }

    public boolean matches(Holder<T> holder) {
        if (!this.checkType((ConfigData)holder.m_203334_())) {
            return false;
        }
        ResourceLocation key = holder.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (key != null && this.entries.contains(key)) {
            return true;
        }
        return this.matches((ConfigData)holder.m_203334_());
    }

    @Nullable
    public T applyModifications(T object) {
        T modifiedObject = object;
        for (Operation operation : this.operations) {
            T result = operation.modify(modifiedObject);
            if (result == null) {
                return null;
            }
            modifiedObject = result;
        }
        return modifiedObject;
    }

    public Codec<? extends ConfigData> getCodec() {
        return CODEC;
    }

    public RegistryModifierData setRegistryName(ResourceLocation name) {
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<RegistryModifierData<T>> getRegistryType() {
        return RegistryModifierData.class;
    }

    public record Operation(Type type, CompoundTag data) {
        public static final Codec<Operation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Type.CODEC.fieldOf("type").forGetter(Operation::type), (App)CompoundTag.f_128325_.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(Operation::data)).apply((Applicative)instance, Operation::new));

        @Nullable
        public <T extends ConfigData> T modify(T element) {
            Codec codec = element.getCodec();
            CompoundTag elementTag = codec.encodeStart((DynamicOps)NbtOps.f_128958_, element).result().orElse(new CompoundTag());
            switch (this.type) {
                case DISABLE: {
                    return null;
                }
                case REPLACE: {
                    for (String key : this.data.m_128431_()) {
                        if (!elementTag.m_128441_(key)) continue;
                        elementTag.m_128365_(key, this.data.m_128423_(key));
                    }
                    break;
                }
                case MERGE: {
                    elementTag = Operation.mergeCompounds(elementTag, this.data);
                    break;
                }
                case APPEND: {
                    elementTag = Operation.appendCompound(elementTag, this.data);
                    break;
                }
                case REMOVE: {
                    elementTag = Operation.removeCompound(elementTag, this.data);
                }
            }
            CompoundTag resultTag = elementTag;
            Optional result = codec.parse((DynamicOps)NbtOps.f_128958_, (Object)resultTag).result();
            return (T)result.orElseGet(() -> {
                ColdSweat.LOGGER.error("Failed to apply registry modification of type {} with data {} to data {}", (Object)this.type, (Object)this.data, (Object)resultTag);
                return element;
            });
        }

        private static CompoundTag mergeCompounds(CompoundTag original, CompoundTag toMerge) {
            CompoundTag merged = original.m_6426_();
            for (String key : toMerge.m_128431_()) {
                Tag originalValue = merged.m_128423_(key);
                Tag toMergeValue = toMerge.m_128423_(key);
                if (originalValue != null) {
                    StringTag operation;
                    if (originalValue instanceof CompoundTag) {
                        CompoundTag originalCompound = (CompoundTag)originalValue;
                        if (toMergeValue instanceof CompoundTag) {
                            CompoundTag toMergeCompound = (CompoundTag)toMergeValue;
                            merged.m_128365_(key, (Tag)Operation.mergeCompounds(originalCompound, toMergeCompound));
                            continue;
                        }
                    }
                    if (originalValue instanceof ListTag) {
                        ListTag originalList = (ListTag)originalValue;
                        if (toMergeValue instanceof ListTag) {
                            ListTag toMergeList = (ListTag)toMergeValue;
                            merged.m_128365_(key, (Tag)Operation.mergeLists(originalList, toMergeList));
                            continue;
                        }
                    }
                    if (!(originalValue instanceof NumericTag)) continue;
                    NumericTag originalNumber = (NumericTag)originalValue;
                    if (!(toMergeValue instanceof StringTag) || (operation = (StringTag)toMergeValue).m_7916_().length() <= 2) continue;
                    double operand = Double.parseDouble(operation.m_7916_().substring(2));
                    double numberValue = originalNumber.m_7061_();
                    switch (operation.m_7916_().substring(0, 2)) {
                        case "+=": {
                            numberValue += operand;
                            break;
                        }
                        case "-=": {
                            numberValue -= operand;
                            break;
                        }
                        case "*=": {
                            numberValue *= operand;
                            break;
                        }
                        case "/=": {
                            numberValue /= operand;
                            break;
                        }
                        case "^=": {
                            numberValue = Math.pow(numberValue, operand);
                            break;
                        }
                        case "%=": {
                            numberValue %= operand;
                            break;
                        }
                        default: {
                            merged.m_128365_(key, toMergeValue);
                        }
                    }
                    if (originalNumber instanceof ByteTag) {
                        merged.m_128344_(key, (byte)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof ShortTag) {
                        merged.m_128376_(key, (short)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof IntTag) {
                        merged.m_128405_(key, (int)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof LongTag) {
                        merged.m_128356_(key, (long)numberValue);
                        continue;
                    }
                    if (originalNumber instanceof FloatTag) {
                        merged.m_128350_(key, (float)numberValue);
                        continue;
                    }
                    if (!(originalNumber instanceof DoubleTag)) continue;
                    merged.m_128347_(key, numberValue);
                    continue;
                }
                merged.m_128365_(key, toMergeValue);
            }
            return merged;
        }

        private static ListTag mergeLists(ListTag original, ListTag toMerge) {
            final HashSet merged = new HashSet(original.m_6426_());
            merged.addAll(toMerge);
            return new ListTag(){
                {
                    this.addAll(merged);
                }
            };
        }

        private static CompoundTag appendCompound(CompoundTag original, CompoundTag toAppend) {
            CompoundTag appended = original.m_6426_();
            for (String key : toAppend.m_128431_()) {
                Tag originalValue = appended.m_128423_(key);
                Tag toAppendValue = toAppend.m_128423_(key);
                if (originalValue == null) {
                    appended.m_128365_(key, toAppendValue);
                    continue;
                }
                if (!(originalValue instanceof CompoundTag)) continue;
                CompoundTag originalCompound = (CompoundTag)originalValue;
                if (!(toAppendValue instanceof CompoundTag)) continue;
                CompoundTag toAppendCompound = (CompoundTag)toAppendValue;
                appended.m_128365_(key, (Tag)Operation.appendCompound(originalCompound, toAppendCompound));
            }
            return appended;
        }

        private static CompoundTag removeCompound(CompoundTag original, CompoundTag toRemove) {
            CompoundTag modified = original.m_6426_();
            for (String key : toRemove.m_128431_()) {
                Tag originalValue = modified.m_128423_(key);
                Tag toRemoveValue = toRemove.m_128423_(key);
                if (originalValue == null) continue;
                if (toRemoveValue instanceof CompoundTag) {
                    CompoundTag toRemoveCompound = (CompoundTag)toRemoveValue;
                    if (!(originalValue instanceof CompoundTag)) continue;
                    CompoundTag originalCompound = (CompoundTag)originalValue;
                    modified.m_128365_(key, (Tag)Operation.removeCompound(originalCompound, toRemoveCompound));
                    continue;
                }
                if (toRemoveValue instanceof StringTag) {
                    modified.m_128473_(key);
                    continue;
                }
                if (!(toRemoveValue instanceof ListTag)) continue;
                ListTag toRemoveList = (ListTag)toRemoveValue;
                if (!(originalValue instanceof ListTag)) continue;
                ListTag originalList = (ListTag)originalValue;
                ListTag newList = originalList.m_6426_();
                newList.removeAll((Collection)toRemoveList);
                modified.m_128365_(key, (Tag)newList);
            }
            return modified;
        }
    }

    public static enum Type implements StringRepresentable
    {
        DISABLE("disable"),
        REPLACE("replace"),
        MERGE("merge"),
        APPEND("append"),
        REMOVE("remove");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Type byName(String name) {
            return (Type)EnumHelper.byName((Enum[])Type.values(), (String)name);
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Type.values());
        }
    }
}

