/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.data.codec.LootEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddDropsModifier
extends LootModifier {
    private final List<LootEntry> additions;
    private final List<Item> removals;

    protected AddDropsModifier(LootItemCondition[] conditionsIn, List<LootEntry> additions, List<Item> removals) {
        super(conditionsIn);
        this.additions = additions;
        this.removals = removals;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        for (LootEntry entry : this.additions) {
            int countRange = entry.count().max() - entry.count().min();
            generatedLoot.add(new ItemStack((ItemLike)entry.item(), context.m_78933_().nextInt(entry.count().min(), entry.count().max() + 1) + context.m_78933_().nextInt(0, countRange * context.getLootingModifier() + 1)));
        }
        if (!this.removals.isEmpty()) {
            generatedLoot.removeIf(stack -> this.removals.contains(stack.m_41720_()));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddDropsModifier> {
        public AddDropsModifier read(@Nonnull ResourceLocation location, JsonObject object, LootItemCondition[] conditionsIn) {
            ArrayList<LootEntry> additions = new ArrayList<LootEntry>();
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"additions")) {
                additions.add((LootEntry)LootEntry.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElseThrow(RuntimeException::new));
            }
            ArrayList<Item> removals = new ArrayList<Item>();
            if (object.has("removals")) {
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"removals")) {
                    removals.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString())));
                }
            }
            return new AddDropsModifier(conditionsIn, additions, removals);
        }

        public JsonObject write(AddDropsModifier instance) {
            JsonObject object = new JsonObject();
            JsonArray additions = new JsonArray();
            JsonArray removals = new JsonArray();
            for (LootEntry entry : instance.additions) {
                additions.add((JsonElement)LootEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry).result().orElseThrow(RuntimeException::new));
            }
            for (Item item : instance.removals) {
                removals.add(item.getRegistryName().toString());
            }
            object.add("additions", (JsonElement)additions);
            object.add("removals", (JsonElement)removals);
            return object;
        }
    }
}

