/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.event.core.init.InitDynamicTagsEvent;
import com.momosoftworks.coldsweat.data.tag.TagHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public class MixinTagLoading {
    private static String DIRECTORY = null;
    @Shadow
    @Final
    private String f_13449_;
    private static final Field MANAGER_ACCESS = ObfuscationReflectionHelper.findField(TagManager.class, (String)"f_144569_");

    @Inject(method={"build"}, at={@At(value="HEAD")})
    private <T> void onBuildStart(Map<ResourceLocation, Tag.Builder> builders, CallbackInfoReturnable<Map<ResourceLocation, Tag<T>>> cir) {
        DIRECTORY = this.f_13449_;
        if (TagHelper.EVENT_TAGS.isEmpty()) {
            InitDynamicTagsEvent event = new InitDynamicTagsEvent(TagHelper.REGISTRY_ACCESS);
            MinecraftForge.EVENT_BUS.post((Event)event);
            TagHelper.EVENT_TAGS.putAll(event.getTags());
        }
    }

    @Inject(method={"lambda$build$10(Ljava/util/Map;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/tags/Tag;)V"}, at={@At(value="TAIL")})
    private static <T> void onTagBuild(Map<ResourceLocation, Tag<T>> map, ResourceLocation tagID, Tag<T> tag, CallbackInfo ci) {
        String directory = DIRECTORY;
        Collection<T> newValues = MixinTagLoading.getTagValues(directory, tagID);
        if (!newValues.isEmpty()) {
            map.put(tagID, new Tag(newValues));
        }
    }

    private static <T> Collection<T> getTagValues(String directory, ResourceLocation tag) {
        directory = directory.replace("tags/", "");
        boolean endsWithS = directory.endsWith("s");
        String[] components = directory.split("/");
        ResourceLocation registry = ModList.get().getModFileById(components[0]) != null ? new ResourceLocation(components[0], directory.substring(directory.indexOf("/") + 1)) : new ResourceLocation(directory);
        Collection<Holder<?>> values = TagHelper.getTagValues(registry, tag);
        if (values.isEmpty() && endsWithS) {
            return MixinTagLoading.getTagValues(directory.substring(0, directory.length() - 1), tag);
        }
        return values;
    }

    static {
        MANAGER_ACCESS.setAccessible(true);
    }

    @Mixin(value={TagManager.class})
    public static final class Manager {
        @Shadow
        @Final
        private RegistryAccess f_144569_;

        @Inject(method={"createLoader"}, at={@At(value="HEAD")})
        private void onCreateLoader(CallbackInfoReturnable<TagLoader> cir) {
            TagHelper.REGISTRY_ACCESS = this.f_144569_;
        }
    }
}

