package com.momosoftworks.coldsweat.client.renderer.layer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;

public class ChameleonColorLayer<T extends Entity, M extends EntityModel<T>> extends RenderLayer<T, M>
{
    private static final RenderType CHAMELEON_SHED = RenderType.entityTranslucent(ChameleonEntityRenderer.CHAMELEON_SHED);
    private static final RenderType CHAMELEON_RED = RenderType.entityTranslucent(ChameleonEntityRenderer.CHAMELEON_RED);
    private static final RenderType CHAMELEON_BLUE = RenderType.entityTranslucent(ChameleonEntityRenderer.CHAMELEON_BLUE);

    public ChameleonColorLayer(RenderLayerParent<T, M> parentLayer)
    {
        super(parentLayer);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch)
    {
        if (entity instanceof Chameleon chameleon)
        {
            // Overlay color
            float midTemp = (float) CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());

            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (!CSMath.betweenInclusive(chameleon.getTemperature(), CSMath.average(ConfigSettings.MIN_TEMP.get(), midTemp), CSMath.average(ConfigSettings.MAX_TEMP.get(), midTemp)))
            {
                if (chameleon.getTemperature() > midTemp)
                {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(CHAMELEON_RED);
                    float alpha = chameleon.hurtTime > 0 ? 0 : (float) CSMath.blend(0f, 1f, chameleon.getTemperature(), CSMath.average(ConfigSettings.MAX_TEMP.get(), midTemp), ConfigSettings.MAX_TEMP.get());
                    if (alpha > 0)
                        ((ChameleonModel<Chameleon>) this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY,
                                                                                           FastColor.ARGB32.colorFromFloat(alpha * chameleon.opacity, 1, 1, 1), true);
                }
                else
                {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(CHAMELEON_BLUE);
                    float alpha = chameleon.hurtTime > 0 ? 0 : (float) CSMath.blend(1f, 0f, chameleon.getTemperature(), ConfigSettings.MIN_TEMP.get(), CSMath.average(ConfigSettings.MIN_TEMP.get(), midTemp));
                    if (alpha > 0)
                        ((ChameleonModel<Chameleon>) this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY,
                                                                                           FastColor.ARGB32.colorFromFloat(alpha * chameleon.opacity, 1, 1, 1), true);
                }
            }

            // Overlay shedding skin
            if (chameleon.isShedding())
            {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(CHAMELEON_SHED);
                float alpha = chameleon.hurtTime > 0 || chameleon.getLastShed() == 0 ? 0 : CSMath.blend(0, 0.7f, chameleon.getAgeSecs() * 20 - chameleon.getLastShed(), 0, chameleon.getTimeToShed());
                if (alpha > 0)
                    ((ChameleonModel<Chameleon>) this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY,
                                                                                       FastColor.ARGB32.colorFromFloat(alpha * chameleon.opacity, 1, 1, 1), true);
            }
            RenderSystem.disableBlend();
        }
    }
}
