/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.HearthContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class HearthScreen
extends AbstractHearthScreen<HearthContainer> {
    private static final ResourceLocation HEARTH_GUI = new ResourceLocation("cold_sweat", "textures/gui/screen/hearth_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((HearthContainer)this.f_97732_).te;
    }

    public HearthScreen(HearthContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, (Component)Component.m_237115_((String)"container.cold_sweat.hearth"));
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(HEARTH_GUI, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int maxGaugeHeight = 14;
        int hotGaugeHeight = ((HearthContainer)this.f_97732_).getHotFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.f_97732_).getHotFuel(), 0.0f, ((HearthContainer)this.f_97732_).te.getMaxFuel()));
        int coldGaugeHeight = ((HearthContainer)this.f_97732_).getColdFuel() <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, ((HearthContainer)this.f_97732_).getColdFuel(), 0.0f, ((HearthContainer)this.f_97732_).te.getMaxFuel()));
        graphics.m_280163_(HEARTH_GUI, this.f_97735_ + 62, this.f_97736_ + 49 + (maxGaugeHeight - hotGaugeHeight), 176.0f, (float)(maxGaugeHeight - hotGaugeHeight), 14, hotGaugeHeight, 256, 256);
        graphics.m_280163_(HEARTH_GUI, this.f_97735_ + 100, this.f_97736_ + 49 + (maxGaugeHeight - coldGaugeHeight), 190.0f, (float)(maxGaugeHeight - coldGaugeHeight), 14, coldGaugeHeight, 256, 256);
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue()) {
            boolean coolingOn = ((HearthContainer)this.f_97732_).te.isCoolingOn();
            boolean heatingOn = ((HearthContainer)this.f_97732_).te.isHeatingOn();
            graphics.m_280163_(HEARTH_GUI, this.f_97735_ + 63, this.f_97736_ + 64, 176.0f, heatingOn ? 28.0f : 32.0f, 13, 4, 256, 256);
            graphics.m_280163_(HEARTH_GUI, this.f_97735_ + 101, this.f_97736_ + 64, 176.0f, coolingOn ? 28.0f : 32.0f, 13, 4, 256, 256);
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 60, this.f_97735_ + 76) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_257404_((Component)Component.m_237115_((String)(heatingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
            if (CSMath.betweenInclusive(mouseX, this.f_97735_ + 98, this.f_97735_ + 114) && CSMath.betweenInclusive(mouseY, this.f_97736_ + 61, this.f_97736_ + 67)) {
                this.m_257404_((Component)Component.m_237115_((String)(coolingOn ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

