/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.momosoftworks.coldsweat.ColdSweat;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.joml.Matrix4f;

public class PostProcessShaderManager
implements AutoCloseable {
    private static final PostProcessShaderManager INSTANCE = new PostProcessShaderManager(Minecraft.m_91087_().m_91385_(), Minecraft.m_91087_().m_91098_());
    private static final Map<String, PostChain> ACTIVE_EFFECTS = new HashMap<String, PostChain>();
    private final RenderTarget mainTarget;
    private final ResourceManager resourceManager;
    private boolean screenSizeUpdated = false;
    public static final ResourceLocation BLOBS = new ResourceLocation("minecraft", "shaders/post/blobs2.json");
    private static final Field POST_PASSES = ObfuscationReflectionHelper.findField(PostChain.class, (String)"f_110009_");
    private static final Field ORTHO_MATRIX = ObfuscationReflectionHelper.findField(PostPass.class, (String)"f_110059_");

    public PostProcessShaderManager(RenderTarget mainTarget, ResourceManager resourceManager) {
        this.mainTarget = mainTarget;
        this.resourceManager = resourceManager;
    }

    public static PostProcessShaderManager getInstance() {
        return INSTANCE;
    }

    public void loadEffect(String id, ResourceLocation shaderLocation) {
        try {
            PostChain postChain = new PostChain(Minecraft.m_91087_().m_91097_(), this.resourceManager, this.mainTarget, shaderLocation);
            if (ACTIVE_EFFECTS.put(id, postChain) != null) {
                this.closeEffect(id);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            ColdSweat.LOGGER.error("Failed to load shader effect: " + id, e);
        }
    }

    public void closeEffect(String id) {
        PostChain chain = ACTIVE_EFFECTS.remove(id);
        if (chain != null) {
            chain.close();
        }
    }

    public void process(float partialTicks) {
        for (PostChain chain : ACTIVE_EFFECTS.values()) {
            if (PostProcessShaderManager.getPostPasses(chain).stream().anyMatch(pass -> PostProcessShaderManager.getOrthoMatrix(pass) == null)) {
                chain.m_110025_(this.mainTarget.f_83915_, this.mainTarget.f_83916_);
            }
            chain.m_110023_(partialTicks);
        }
    }

    public void resize(int width, int height) {
        for (PostChain chain : ACTIVE_EFFECTS.values()) {
            chain.m_110025_(width, height);
        }
    }

    public boolean hasEffect(String id) {
        return ACTIVE_EFFECTS.containsKey(id);
    }

    public PostChain getEffect(String id) {
        return ACTIVE_EFFECTS.get(id);
    }

    public List<PostPass> getPostPasses(String effectId) {
        PostChain chain = ACTIVE_EFFECTS.get(effectId);
        if (chain == null) {
            return List.of();
        }
        try {
            return (List)POST_PASSES.get(chain);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get post passes for effect: " + effectId, (Throwable)e);
            return List.of();
        }
    }

    public static List<PostPass> getPostPasses(PostChain chain) {
        try {
            return (List)POST_PASSES.get(chain);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get post passes for effect: " + chain, (Throwable)e);
            return List.of();
        }
    }

    public static Matrix4f getOrthoMatrix(PostPass pass) {
        try {
            return (Matrix4f)ORTHO_MATRIX.get(pass);
        }
        catch (Exception e) {
            ColdSweat.LOGGER.error("Failed to get ortho matrix for pass: " + pass, (Throwable)e);
            return new Matrix4f();
        }
    }

    @Override
    public void close() {
        for (PostChain chain : ACTIVE_EFFECTS.values()) {
            chain.close();
        }
        ACTIVE_EFFECTS.clear();
    }

    static {
        POST_PASSES.setAccessible(true);
        ORTHO_MATRIX.setAccessible(true);
    }
}

