/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.item;

import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterskinTempModifier;
import com.momosoftworks.coldsweat.api.util.Placement;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.init.ItemInit;
import com.momosoftworks.coldsweat.core.network.message.ParticleBatchMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class FilledWaterskinItem
extends Item {
    public static final double EFFECT_RATE = 0.5;
    public static final String NBT_TEMPERATURE = "Temperature";
    private static final DispenseItemBehavior DISPENSE_BEHAVIOR = (source, stack) -> {
        final BlockPos pos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        ServerLevel level = source.m_7727_();
        ChunkAccess chunk = WorldHelper.getChunk((LevelAccessor)level, pos);
        double itemTemp = stack.m_41784_().m_128459_(NBT_TEMPERATURE);
        if (chunk == null) {
            return stack;
        }
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.WATERSKIN_POUR, SoundSource.BLOCKS, 1.0f, (float)(Math.random() / 5.0 + 0.9));
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> FilledWaterskinItem.lambda$static$1(rand, pos, (Level)level), i);
        }
        new Object((Level)level, itemTemp, chunk){
            double acceleration = 0.0;
            int tick = 0;
            AABB aabb = new AABB(pos).m_82400_(0.5);
            Set<Player> affectedPlayers = new HashSet<Player>();
            final /* synthetic */ Level val$level;
            final /* synthetic */ double val$itemTemp;
            final /* synthetic */ ChunkAccess val$chunk;
            {
                this.val$level = level;
                this.val$itemTemp = d;
                this.val$chunk = chunkAccess;
            }

            void start() {
                MinecraftForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void onTick(TickEvent.LevelTickEvent event) {
                if (event.level.f_46443_ == this.val$level.f_46443_ && event.phase == TickEvent.Phase.START) {
                    double waterTemp = CSMath.blend(this.val$itemTemp, this.val$itemTemp / 5.0, (double)this.tick, 20.0, 100.0);
                    double effectAmount = waterTemp * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
                    double wetnessTemp = 0.05 * (double)CSMath.sign(waterTemp + 0.01);
                    this.aabb = this.aabb.m_82386_(0.0, -this.acceleration, 0.0);
                    BlockPos pos2 = BlockPos.m_274561_((double)this.aabb.f_82288_, (double)this.aabb.f_82289_, (double)this.aabb.f_82290_);
                    if (WorldHelper.isSpreadBlocked((LevelAccessor)this.val$level, this.val$chunk.m_8055_(pos2), pos2, Direction.DOWN, Direction.DOWN)) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                        return;
                    }
                    this.val$level.m_45976_(Player.class, this.aabb).forEach(player -> {
                        if (!this.affectedPlayers.contains(player)) {
                            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
                            Temperature.addOrReplaceModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
                            this.affectedPlayers.add((Player)player);
                        }
                    });
                    this.acceleration += 0.0052;
                    ++this.tick;
                    if (this.tick > 100) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        }.start();
        return stack.getCraftingRemainingItem();
    };

    public FilledWaterskinItem() {
        super(new Item.Properties().m_41487_(1).m_41495_((Item)ItemInit.WATERSKIN.get()));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_BEHAVIOR);
    }

    public static ItemStack getDisplayStack() {
        return new ItemStack((ItemLike)ModItems.FILLED_WATERSKIN);
    }

    public int getMaxDamage(ItemStack stack) {
        return ConfigSettings.WATERSKIN_USES.get();
    }

    public int m_142159_(ItemStack stack) {
        return 2973406;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41773_() > 0;
    }

    private static int getDurability(ItemStack stack) {
        return Math.max(0, stack.m_41776_() - stack.m_41773_());
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(itemstack, world, entity, slot, isSelected);
        if (entity.f_19797_ % 5 == 0 && entity instanceof Player) {
            Player player = (Player)entity;
            double itemTemp = itemstack.m_41784_().m_128459_(NBT_TEMPERATURE);
            if (itemTemp != 0.0 && slot <= 8 || player.m_21206_().equals(itemstack)) {
                double drainAmt = 0.025 * ConfigSettings.WATERSKIN_NEUTRALIZE_SPEED.get();
                double newTemp = CSMath.shrink(itemTemp, drainAmt * 5.0);
                double tempEffect = 0.05 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
                itemstack.m_41784_().m_128347_(NBT_TEMPERATURE, newTemp);
                Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(tempEffect * (double)CSMath.sign(itemTemp)).expires(5), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
            }
        }
    }

    public static boolean performPourAction(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (stack.m_150930_(ModItems.FILLED_WATERSKIN)) break block6;
            }
            return false;
        }
        if (!player.m_9236_().f_46443_) {
            double temperature = stack.m_41784_().m_128459_(NBT_TEMPERATURE);
            double effectAmount = temperature * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
            Temperature.addModifier((LivingEntity)player, new WaterskinTempModifier(effectAmount).expires(0), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
            double wetnessTemp = 0.05 * (double)CSMath.sign(temperature == 0.0 ? 1.0 : temperature);
            Temperature.addOrReplaceModifier((LivingEntity)player, new WaterTempModifier(wetnessTemp).tickRate(5), Temperature.Trait.WORLD, Placement.Duplicates.BY_CLASS);
            WorldHelper.playEntitySound(ModSounds.WATERSKIN_POUR, (Entity)player, player.m_5720_(), 2.0f, (float)(Math.random() / 5.0 + 0.9));
        }
        FilledWaterskinItem.consumeWaterskin(stack, (LivingEntity)player, hand);
        player.m_21011_(hand, true);
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            TaskScheduler.scheduleServer(() -> {
                ParticleBatchMessage particleBatch = new ParticleBatchMessage(2);
                for (int p = 0; p < 10; ++p) {
                    AABB playerBB = player.m_6972_(player.m_20089_()).m_20393_(player.m_20182_()).m_82400_(0.2);
                    particleBatch.addParticle((ParticleOptions)ParticleTypes.f_123804_, Mth.m_14139_((double)rand.nextFloat(), (double)playerBB.f_82288_, (double)playerBB.f_82291_), playerBB.f_82292_, Mth.m_14139_((double)rand.nextFloat(), (double)playerBB.f_82290_, (double)playerBB.f_82293_), 0.3, 0.3, 0.3);
                }
                particleBatch.sendEntity((Entity)player);
            }, i);
        }
        player.m_20095_();
        player.m_36335_().m_41524_(ModItems.FILLED_WATERSKIN, 10);
        player.m_36335_().m_41524_(ModItems.WATERSKIN, 10);
        return true;
    }

    public static ItemStack consumeWaterskin(ItemStack stack, LivingEntity entity, InteractionHand usedHand) {
        Player player;
        ItemStack emptyStack = stack.getCraftingRemainingItem();
        if (entity instanceof Player && (player = (Player)entity).m_150109_().m_36063_(emptyStack)) {
            player.m_36356_(emptyStack);
            player.m_21008_(usedHand, ItemStack.f_41583_);
            return ItemStack.f_41583_;
        }
        entity.m_21008_(usedHand, emptyStack);
        return emptyStack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.DRINK), level, player, hand);
        }
        return FilledWaterskinItem.performAction(Preference.getOrDefault(player, Preference.WATERSKIN_PRIMARY, Preference.WaterskinAction.POUR), level, player, hand);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        super.m_5929_(level, entity, stack, remainingTicks);
        if (remainingTicks % 5 == 0 && remainingTicks < this.m_8105_(stack) - 5) {
            Vec3 playerPos = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
            Vec3 lookVec = new Vec3(entity.m_20154_().f_82479_, 0.0, entity.m_20154_().f_82481_).m_82541_();
            Vec3 particlePos = playerPos.m_82549_(lookVec.m_82490_(0.3));
            WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123769_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.2, 0.2, 0.2, 4.0, 0.0);
        }
    }

    private static InteractionResultHolder<ItemStack> performAction(Preference.WaterskinAction action, Level level, Player player, InteractionHand hand) {
        switch (action) {
            case DRINK: {
                return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
            }
            case POUR: {
                if (!FilledWaterskinItem.performPourAction(player.m_21120_(hand), (LivingEntity)player, hand)) break;
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152476_)) {
            int waterLevel;
            boolean hasWater = state.m_60713_(Blocks.f_152476_);
            int n = waterLevel = hasWater ? (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) : 0;
            if (waterLevel >= 3) {
                return InteractionResult.PASS;
            }
            state = hasWater ? (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel + 1)) : (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, state, 3);
            if (!level.f_46443_) {
                level.m_5594_(null, pos, ModSounds.WATERSKIN_FILL, SoundSource.BLOCKS, 2.0f, (float)Math.random() / 5.0f + 0.9f);
                WorldHelper.spawnParticleBatch(level, (ParticleOptions)ParticleTypes.f_123769_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5, 0.5, 0.5, 0.5, 10.0, 0.0);
            }
            if (player != null) {
                FilledWaterskinItem.consumeWaterskin(context.m_43722_(), (LivingEntity)player, context.m_43724_());
                player.m_36335_().m_41524_(ModItems.WATERSKIN, 10);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        double amount = stack.m_41784_().m_128459_(NBT_TEMPERATURE) * ((double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0);
        Temperature.addModifier(entity, new WaterskinTempModifier(amount / (double)(100 * stack.m_41776_())).expires(100), Temperature.Trait.CORE, Placement.Duplicates.ALLOW);
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return stack;
        }
        if (FilledWaterskinItem.getDurability(stack) <= 1) {
            return FilledWaterskinItem.consumeWaterskin(stack, entity, entity.m_7655_());
        }
        stack.m_41721_(stack.m_41773_() + 1);
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        double temp = CSMath.round(stack.m_41784_().m_128459_(NBT_TEMPERATURE), 2);
        double multiplier = (double)ConfigSettings.WATERSKIN_CONSUME_STRENGTH.get().intValue() / 50.0;
        MutableComponent filledLabel = Component.m_237115_((String)"item.cold_sweat.waterskin.filled").m_130940_(ChatFormatting.GRAY);
        if (ConfigSettings.ENABLE_HINTS.get().booleanValue() && !TooltipHandler.isShiftDown()) {
            filledLabel.m_7220_((Component)Component.m_237113_((String)" ").m_7220_(TooltipHandler.EXPAND_TOOLTIP));
        }
        tooltip.add((Component)filledLabel);
        int useEffect = (int)Math.round(temp * multiplier);
        MutableComponent tempText = useEffect > 0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + useEffect}).m_130948_(TooltipHandler.HOT) : (useEffect == 0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + useEffect}).m_130940_(ChatFormatting.WHITE) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{useEffect}).m_130948_(TooltipHandler.COLD));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.cold_sweat.used").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)tempText);
        if (TooltipHandler.isShiftDown()) {
            if (ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
                String crouchKey = Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_().getString();
                String crouchAction = switch (Preference.getOrDefault((Player)Minecraft.m_91087_().f_91074_, Preference.WATERSKIN_SECONDARY, Preference.WaterskinAction.POUR)) {
                    case Preference.WaterskinAction.DRINK -> "tooltip.cold_sweat.waterskin.drink";
                    case Preference.WaterskinAction.POUR -> "tooltip.cold_sweat.waterskin.pour";
                    default -> "";
                };
                if (!crouchAction.isEmpty()) {
                    tooltip.add(2, (Component)Component.m_237110_((String)crouchAction, (Object[])new Object[]{Component.m_237113_((String)crouchKey).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            String perSecond = Component.m_237115_((String)"tooltip.cold_sweat.per_second").getString();
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.cold_sweat.hotbar").m_130940_(ChatFormatting.GRAY));
            double effectRate = 0.5 * ConfigSettings.WATERSKIN_HOTBAR_STRENGTH.get();
            MutableComponent tempEffectText = (temp > 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.round(effectRate, 2)}).m_130948_(TooltipHandler.HOT) : (temp == 0.0 ? Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+0"}).m_130940_(ChatFormatting.WHITE) : Component.m_237110_((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"-" + CSMath.round(effectRate, 2)}).m_130948_(TooltipHandler.COLD))).m_130946_(perSecond);
            tooltip.add((Component)tempEffectText);
        }
        super.m_7373_(stack, level, tooltip, advanced);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (stack.m_41720_() instanceof FilledWaterskinItem) {
            ItemStack emptyWaterskin = new ItemStack((ItemLike)ModItems.WATERSKIN);
            emptyWaterskin.m_41751_(stack.m_41783_());
            emptyWaterskin.m_41749_(NBT_TEMPERATURE);
            emptyWaterskin.m_41749_("Damage");
            emptyWaterskin.m_41749_("Purity");
            return emptyWaterskin;
        }
        return stack;
    }

    public String m_5524_() {
        return Component.m_237115_((String)"item.cold_sweat.waterskin").getString();
    }

    private static /* synthetic */ void lambda$static$1(Random rand, BlockPos pos, Level level) {
        ParticleBatchMessage particles = new ParticleBatchMessage(2);
        for (int p = 0; p < rand.nextInt(5) + 5; ++p) {
            particles.addParticle((ParticleOptions)ParticleTypes.f_123804_, new ParticleBatchMessage.ParticlePlacement((double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + rand.nextDouble(), (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.0, 0.0));
        }
        particles.sendWorld(level);
    }
}

