/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.capability.handler.ShearableFurManager;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SyncShearableDataMessage {
    private final int entityId;
    private final CompoundTag nbt;

    public SyncShearableDataMessage(int entityId, CompoundTag nbt) {
        this.entityId = entityId;
        this.nbt = nbt;
    }

    public static void encode(SyncShearableDataMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.m_130079_(msg.nbt);
    }

    public static SyncShearableDataMessage decode(FriendlyByteBuf buffer) {
        return new SyncShearableDataMessage(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(SyncShearableDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                try {
                    Entity entity;
                    Level level = ClientOnlyHelper.getClientLevel();
                    if (level != null && (entity = level.m_6815_(message.entityId)) instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        ShearableFurManager.getFurCap((Entity)living).ifPresent(cap -> cap.deserializeNBT(message.nbt));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        context.setPacketHandled(true);
    }
}

