/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public abstract class TempModifier {
    private CompoundTag nbt = new CompoundTag();
    private int expireTicks = -1;
    private int ticksExisted = 0;
    private int tickRate = 1;
    private final Double[] lastInput = new Double[Temperature.Trait.values().length];
    private final Double[] lastOutput = new Double[Temperature.Trait.values().length];
    private final Function<Double, Double>[] function = new Function[Temperature.Trait.values().length];
    private boolean changed = false;

    public final <T extends TempModifier> T tickRate(int interval) {
        this.tickRate = Math.max(1, interval);
        return (T)this;
    }

    public final <T extends TempModifier> T expires(int ticks) {
        this.expireTicks = ticks;
        return (T)this;
    }

    protected abstract Function<Double, Double> calculate(LivingEntity var1, Temperature.Trait var2);

    public void tick(LivingEntity entity) {
    }

    public final double update(double temp, LivingEntity entity, Temperature.Trait trait) {
        TempModifierEvent.Calculate.Pre pre = new TempModifierEvent.Calculate.Pre(this, entity, temp, trait);
        NeoForge.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            this.setFunction(trait, pre.getFunction());
            return this.apply(trait, pre.getTemperature());
        }
        TempModifierEvent.Calculate.Post post = new TempModifierEvent.Calculate.Post(this, entity, pre.getTemperature(), this.calculate(entity, trait), trait);
        NeoForge.EVENT_BUS.post((Event)post);
        this.setFunction(trait, post.getFunction());
        return this.apply(trait, post.getTemperature());
    }

    public double apply(Temperature.Trait trait, double temp) {
        this.setLastInput(trait, temp);
        double output = this.getFunction(trait).apply(temp);
        this.setLastOutput(trait, output);
        return output;
    }

    public void onAdded(LivingEntity entity, Temperature.Trait trait) {
    }

    public void onRemoved(LivingEntity entity, Temperature.Trait trait) {
    }

    public void onSiblingAdded(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
    }

    public void onSiblingRemoved(LivingEntity entity, Temperature.Trait trait, TempModifier sibling) {
    }

    public final int getExpireTime() {
        return this.expireTicks;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public final int getTickRate() {
        return this.tickRate;
    }

    public final Function<Double, Double> getFunction(Temperature.Trait trait) {
        Function<Double, Double> func = this.function[trait.ordinal()];
        if (func == null) {
            func = temp -> temp;
            this.setFunction(trait, func);
        }
        return func;
    }

    protected final void setFunction(Temperature.Trait trait, Function<Double, Double> func) {
        this.function[trait.ordinal()] = func;
    }

    public final double getLastInput(Temperature.Trait trait) {
        return CSMath.orElse(this.lastInput[trait.ordinal()], 0.0);
    }

    protected final void setLastInput(Temperature.Trait trait, double temp) {
        this.lastInput[trait.ordinal()] = temp;
    }

    public final double getLastOutput(Temperature.Trait trait) {
        return CSMath.orElse(this.lastOutput[trait.ordinal()], 0.0);
    }

    protected final void setLastOutput(Temperature.Trait trait, double temp) {
        this.lastOutput[trait.ordinal()] = temp;
    }

    public final CompoundTag getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundTag data) {
        this.nbt = data;
    }

    public String toString() {
        return TempModifierRegistry.getKey(this).toString();
    }

    public void markDirty() {
        this.changed = true;
    }

    public boolean isDirty() {
        return this.changed;
    }

    public void markClean() {
        this.changed = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TempModifier)) return false;
        TempModifier mod = (TempModifier)obj;
        if (!this.getClass().equals(mod.getClass())) return false;
        if (!mod.getNBT().equals((Object)this.getNBT())) return false;
        return true;
    }
}

