/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.api.annotation.Internal;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TempModifierEvent;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.placement.Matcher;
import com.momosoftworks.coldsweat.api.util.placement.Mode;
import com.momosoftworks.coldsweat.api.util.placement.Order;
import com.momosoftworks.coldsweat.api.util.placement.Placement;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.message.SyncTempModifiersMessage;
import com.momosoftworks.coldsweat.core.network.message.SyncTemperatureMessage;
import com.momosoftworks.coldsweat.data.codec.util.ExtraCodecs;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.InterruptibleIterator;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class Temperature {
    private Temperature() {
    }

    public static double convert(double value, Units from, Units to, boolean absolute) {
        return switch (from.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                switch (to.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield value;
                    }
                    case 0: {
                        yield value * 1.8 + (absolute ? 32.0 : 0.0);
                    }
                    case 2: 
                }
                yield value / 25.0;
            }
            case 0 -> {
                switch (to.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield (value - (absolute ? 32.0 : 0.0)) / 1.8;
                    }
                    case 0: {
                        yield value;
                    }
                    case 2: 
                }
                yield (value - (absolute ? 32.0 : 0.0)) / 45.0;
            }
            case 2 -> {
                switch (to.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        yield value * 25.0;
                    }
                    case 0: {
                        yield value * 45.0 + (absolute ? 32.0 : 0.0);
                    }
                    case 2: 
                }
                yield value;
            }
        };
    }

    public static double convertIfNeeded(double value, Trait trait, Units units) {
        if (trait.isForWorld()) {
            return Temperature.convert(value, Units.MC, units, true);
        }
        return value;
    }

    public static double get(LivingEntity entity, Trait trait) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.getTrait(trait)).orElse(0.0);
    }

    public static void set(LivingEntity entity, Trait trait, double value) {
        TemperatureChangedEvent event = (TemperatureChangedEvent)NeoForge.EVENT_BUS.post((Event)new TemperatureChangedEvent(entity, trait, Temperature.get(entity, trait), value));
        if (event.isCanceled()) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.setTrait(trait, event.getTemperature()));
        Temperature.updateTemperature(entity);
    }

    public static void add(LivingEntity entity, Trait trait, double value) {
        double oldTemp = Temperature.get(entity, trait);
        TemperatureChangedEvent event = (TemperatureChangedEvent)NeoForge.EVENT_BUS.post((Event)new TemperatureChangedEvent(entity, trait, oldTemp, oldTemp + value));
        if (event.isCanceled()) {
            return;
        }
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.setTrait(trait, event.getTemperature()));
        Temperature.updateTemperature(entity);
    }

    public static double apply(double currentTemp, LivingEntity entity, Trait trait, boolean ignoreTickMultiplier, TempModifier ... modifiers) {
        if (modifiers.length == 0) {
            return currentTemp;
        }
        double temp2 = currentTemp;
        for (TempModifier modifier : modifiers) {
            double newTemp;
            if (modifier == null) continue;
            int tickRate = ignoreTickMultiplier ? modifier.getTickRate() : (int)((double)modifier.getTickRate() / ConfigSettings.MODIFIER_TICK_RATE.get());
            double d = newTemp = entity.tickCount % tickRate == 0 || modifier.getTicksExisted() == 0 || entity.tickCount <= 1 ? modifier.update(temp2, entity, trait) : modifier.apply(trait, temp2);
            if (Double.isNaN(newTemp)) continue;
            temp2 = newTemp;
        }
        return temp2;
    }

    public static double apply(double currentTemp, LivingEntity entity, Trait trait, TempModifier ... modifiers) {
        return Temperature.apply(currentTemp, entity, trait, false, modifiers);
    }

    public static double apply(double temp, LivingEntity entity, Trait trait, Collection<TempModifier> modifiers, boolean ignoreTickMultiplier) {
        return Temperature.apply(temp, entity, trait, ignoreTickMultiplier, modifiers.toArray(new TempModifier[0]));
    }

    public static double apply(double temp, LivingEntity entity, Trait trait, Collection<TempModifier> modifiers) {
        return Temperature.apply(temp, entity, trait, false, modifiers.toArray(new TempModifier[0]));
    }

    public static boolean hasModifier(LivingEntity entity, Trait trait, Class<? extends TempModifier> modClass) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> cap.hasModifier(trait, modClass)).orElse(false);
    }

    public static List<TempModifier> getModifiers(LivingEntity entity, Trait trait) {
        return (List)EntityTempManager.getTemperatureCap((Entity)entity).map(cap -> ImmutableList.copyOf(cap.getModifiers(trait))).orElse(ImmutableList.of());
    }

    public static List<TempModifier> getModifiers(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        return Temperature.getModifiers(entity, trait).stream().filter(condition).toList();
    }

    public static Optional<TempModifier> getModifier(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        return Temperature.getModifiers(entity, trait, condition).stream().findFirst();
    }

    public static <T extends TempModifier> Optional<T> getModifier(LivingEntity entity, Trait trait, Class<T> modClass) {
        return Temperature.getModifier(entity, trait, modClass::isInstance);
    }

    public static boolean replaceOrAddModifier(LivingEntity entity, TempModifier modifier, Trait trait, Matcher duplicateMatcher) {
        Placement placement = Placement.of(Mode.REPLACE, Order.FIRST, mod -> duplicateMatcher.check(modifier, (TempModifier)mod)).orElse(Placement.LAST);
        return Temperature.addModifier(entity, modifier, trait, placement);
    }

    public static boolean addModifier(LivingEntity entity, TempModifier modifier, Trait trait, Placement placement) {
        Optional<ITemperatureCap> optCap;
        TempModifierEvent.Add event = new TempModifierEvent.Add(entity, trait, modifier);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled() && (optCap = EntityTempManager.getTemperatureCap((Entity)entity)).isPresent()) {
            ITemperatureCap cap = optCap.get();
            List<TempModifier> modifiers = cap.getModifiers(trait);
            Consumer<TempModifier> onAdded = mod -> {
                modifier.onAdded(entity, trait);
                Temperature.updateSiblingsAdd(modifiers, entity, trait, modifier);
            };
            Consumer<TempModifier> onRemoved = mod -> {
                modifier.onRemoved(entity, trait);
                Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
            };
            if (Temperature.addModifier(modifiers, event.getModifier(), placement, onAdded, onRemoved)) {
                Temperature.updateModifiers(entity, cap);
                return true;
            }
            return false;
        }
        return false;
    }

    @Internal
    public static boolean addModifier(List<TempModifier> modifiers, TempModifier modifier, Placement placement, Consumer<TempModifier> onAdded, Consumer<TempModifier> onRemoved) {
        boolean added = false;
        Predicate<TempModifier> predicate = placement.predicate();
        if (predicate == null) {
            predicate = mod -> true;
        }
        boolean isForward = placement.order() == Order.FIRST;
        Matcher duplicateMatcher = placement.duplicates();
        int maxDuplicates = placement.maxDuplicates();
        if (duplicateMatcher == Matcher.IGNORE || modifiers.stream().filter(mod -> duplicateMatcher.check(modifier, (TempModifier)mod)).count() < (long)maxDuplicates) {
            if (modifiers.isEmpty()) {
                if (placement.mode().isAdding()) {
                    modifiers.add(modifier);
                    if (onAdded != null) {
                        onAdded.accept(modifier);
                    }
                    return true;
                }
            } else {
                int start;
                int i = start = isForward ? 0 : modifiers.size() - 1;
                while (isForward ? i < modifiers.size() : i >= 0) {
                    TempModifier modifierAt = modifiers.get(i);
                    if (predicate.test(modifierAt)) {
                        added = true;
                        if (placement.mode() == Mode.REPLACE) {
                            modifiers.set(i, modifier);
                            if (onRemoved != null) {
                                onRemoved.accept(modifierAt);
                            }
                        } else {
                            modifiers.add(i + (placement.mode() == Mode.ADD_AFTER ? 1 : 0), modifier);
                        }
                        if (onAdded == null) break;
                        onAdded.accept(modifier);
                        break;
                    }
                    i += isForward ? 1 : -1;
                }
            }
        }
        if (!added && placement.fallback() != null) {
            added = Temperature.addModifier(modifiers, modifier, placement.fallback(), onAdded, onRemoved);
        }
        return added;
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, int maxCount, Order order, Predicate<TempModifier> condition) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> {
            int i;
            List<TempModifier> modifiers = cap.getModifiers(trait);
            boolean forwardOrder = order == Order.FIRST;
            int removed = 0;
            int n = i = forwardOrder ? 0 : modifiers.size() - 1;
            while (i >= 0 && i < modifiers.size() && removed < maxCount) {
                TempModifier modifier = modifiers.get(i);
                if (condition.test(modifier)) {
                    TempModifierEvent.Remove event = new TempModifierEvent.Remove(entity, trait, modifier);
                    NeoForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled()) {
                        cap.removeModifier(modifier, trait);
                        modifier.onRemoved(entity, trait);
                        Temperature.updateSiblingsRemove(modifiers, entity, trait, modifier);
                        i += forwardOrder ? -1 : 1;
                        ++removed;
                    }
                }
                i += forwardOrder ? 1 : -1;
            }
            if (removed > 0) {
                Temperature.updateModifiers(entity, cap);
            }
        });
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, Predicate<TempModifier> condition) {
        Temperature.removeModifiers(entity, trait, Integer.MAX_VALUE, Order.FIRST, condition);
    }

    public static void removeModifiers(LivingEntity entity, Trait trait, Class<? extends TempModifier> clazz) {
        Temperature.removeModifiers(entity, trait, Integer.MAX_VALUE, Order.FIRST, clazz::isInstance);
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, Consumer<TempModifier> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.getModifiers(trait).forEach(action));
    }

    public static void forEachModifier(LivingEntity entity, Trait trait, BiConsumer<TempModifier, InterruptibleIterator<TempModifier>> action) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> CSMath.breakableForEach(cap.getModifiers(trait), action));
    }

    public static double getNeutralWorldTemp(LivingEntity entity) {
        return (Temperature.get(entity, Trait.BURNING_POINT) + Temperature.get(entity, Trait.FREEZING_POINT)) / 2.0;
    }

    @Internal
    public static void updateSiblingsAdd(List<TempModifier> modifiers, LivingEntity entity, Trait trait, TempModifier modifier) {
        modifiers.forEach(mod -> {
            if (mod == modifier) {
                return;
            }
            mod.onSiblingAdded(entity, trait, modifier);
        });
    }

    @Internal
    public static void updateSiblingsRemove(List<TempModifier> modifiers, LivingEntity entity, Trait trait, TempModifier modifier) {
        modifiers.forEach(mod -> {
            if (mod == modifier) {
                return;
            }
            mod.onSiblingRemoved(entity, trait, modifier);
        });
    }

    public static void updateTemperature(LivingEntity entity, ITemperatureCap cap, boolean instant) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncTemperatureMessage(entity, cap.serializeTraits(), instant), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void updateTemperature(LivingEntity entity) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.syncValues(entity));
    }

    public static void updateModifiers(LivingEntity entity, ITemperatureCap cap) {
        if (!entity.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new SyncTempModifiersMessage(entity, cap.serializeModifiers()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void updateModifiers(LivingEntity entity) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> Temperature.updateModifiers(entity, cap));
    }

    public static Map<Trait, Double> getTemperatures(LivingEntity entity) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(ITemperatureCap::getTraits).orElse(new EnumMap(Trait.class));
    }

    public static EnumMap<Trait, List<TempModifier>> getModifiers(LivingEntity entity) {
        return EntityTempManager.getTemperatureCap((Entity)entity).map(ITemperatureCap::getModifiers).orElseGet(() -> new EnumMap(Trait.class));
    }

    public static void clearModifiers(LivingEntity entity, Trait trait) {
        EntityTempManager.getTemperatureCap((Entity)entity).ifPresent(cap -> cap.clearModifiers(trait));
    }

    public static enum Units implements StringRepresentable
    {
        F("\u00b0F", "f"),
        C("\u00b0C", "c"),
        MC("MC", "mc");

        public static final Codec<Units> CODEC;
        private final String name;
        private final String id;

        private Units(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public static Units fromID(String name) {
            return (Units)EnumHelper.byName((Enum[])Units.values(), (String)name);
        }

        public String getFormattedName() {
            return this.name;
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Units.values());
        }
    }

    public static enum Trait implements StringRepresentable
    {
        WORLD("world", true, true, true),
        CORE("core", true, true, false),
        BASE("base", true, true, true),
        BODY("body", false, false, false),
        RATE("rate", true, true, true),
        FREEZING_POINT("freezing_point", true, true, true),
        BURNING_POINT("burning_point", true, true, true),
        COLD_RESISTANCE("cold_resistance", true, true, true),
        HEAT_RESISTANCE("heat_resistance", true, true, true),
        COLD_DAMPENING("cold_dampening", true, true, true),
        HEAT_DAMPENING("heat_dampening", true, true, true);

        public static final Codec<Trait> CODEC;
        private final String id;
        private final boolean forTemperature;
        private final boolean forModifiers;
        private final boolean forAttributes;

        private Trait(String id, boolean forTemperature, boolean forModifiers, boolean forAttributes) {
            this.id = id;
            this.forTemperature = forTemperature;
            this.forModifiers = forModifiers;
            this.forAttributes = forAttributes;
        }

        public boolean isForTemperature() {
            return this.forTemperature;
        }

        public boolean isForModifiers() {
            return this.forModifiers;
        }

        public boolean isForAttributes() {
            return this.forAttributes;
        }

        public boolean isForWorld() {
            return this == WORLD || this == BURNING_POINT || this == FREEZING_POINT;
        }

        public static Trait fromID(String name) {
            return (Trait)EnumHelper.byName((Enum[])Trait.values(), (String)name);
        }

        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = ExtraCodecs.enumIgnoreCase((Enum[])Trait.values());
        }
    }
}

