/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util.placement;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.util.serialization.EnumHelper;
import java.util.function.BiPredicate;
import net.minecraft.util.StringRepresentable;

public enum Matcher implements StringRepresentable
{
    IGNORE("ignore", (modA, modB) -> false),
    SAME_CLASS("same_class", (modA, modB) -> modA.getClass().equals(modB.getClass())),
    SUBCLASS("subclass", (modA, modB) -> modA.getClass().isInstance(modB)),
    EQUALS("equals", TempModifier::equals);

    private final BiPredicate<TempModifier, TempModifier> predicate;
    private final String name;

    private Matcher(String name, BiPredicate<TempModifier, TempModifier> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public boolean check(TempModifier modA, TempModifier modB) {
        return this.predicate.test(modA, modB);
    }

    public String getSerializedName() {
        return this.name;
    }

    public static Matcher byName(String name) {
        return (Matcher)EnumHelper.byName((Enum[])Matcher.values(), (String)name);
    }
}

