/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.util.placement;

import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.placement.Matcher;
import com.momosoftworks.coldsweat.api.util.placement.Mode;
import com.momosoftworks.coldsweat.api.util.placement.Order;
import java.util.function.Predicate;

public class Placement {
    private final Mode mode;
    private final Order order;
    private final Predicate<TempModifier> predicate;
    private Matcher matcher = Matcher.IGNORE;
    private int maxDuplicates = Integer.MAX_VALUE;
    private Placement fallback = null;
    public static final Placement FIRST = Placement.of(Mode.ADD_BEFORE, Order.FIRST, mod -> true);
    public static final Placement LAST = Placement.of(Mode.ADD_AFTER, Order.LAST, mod -> true);

    Placement(Mode mode, Order order, Predicate<TempModifier> predicate) {
        this.mode = mode;
        this.order = order;
        this.predicate = predicate;
    }

    public static Placement of(Mode mode, Order order, Predicate<TempModifier> predicate) {
        return new Placement(mode, order, predicate);
    }

    public Placement limitDuplicates(Matcher duplicateMatcher, int maxDuplicates) {
        this.matcher = duplicateMatcher;
        this.maxDuplicates = maxDuplicates;
        return this;
    }

    public Placement noDuplicates(Matcher duplicateMatcher) {
        this.matcher = duplicateMatcher;
        this.maxDuplicates = 1;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    public Order order() {
        return this.order;
    }

    public Predicate<TempModifier> predicate() {
        return this.predicate;
    }

    public Placement fallback() {
        return this.fallback;
    }

    public Matcher duplicates() {
        return this.matcher;
    }

    public int maxDuplicates() {
        return this.maxDuplicates;
    }

    public Placement orElse(Placement fallback) {
        this.fallback = fallback;
        return this;
    }
}

