/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.Overlays;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

@EventBusSubscriber(value={Dist.CLIENT})
public class RegisterItemOverrides {
    public static final ItemPropertyFunction SOULSPRING_LAMP_PROPERTIES = (stack, level, entity, id) -> {
        if (SoulspringLampItem.isLit(stack)) {
            double fuel = SoulspringLampItem.getFuel(stack);
            return fuel > 43.0 ? 3.0f : (fuel > 22.0 ? 2.0f : 1.0f);
        }
        return 0.0f;
    };
    private static final Field ITEM_PROPERTIES = ObfuscationReflectionHelper.findField(ItemProperties.class, (String)"PROPERTIES");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (!ConfigSettings.ANIMATED_SOULSPRING_LAMP_MODEL.get().booleanValue()) {
                ItemProperties.register((Item)((Item)ModItems.SOULSPRING_LAMP.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"soulspring_state"), (ItemPropertyFunction)SOULSPRING_LAMP_PROPERTIES);
            }
            ItemProperties.register((Item)((Item)ModItems.FILLED_WATERSKIN.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"water_temperature"), (stack, level, entity, id) -> ((Double)stack.getOrDefault(ModItemComponents.WATER_TEMPERATURE, (Object)0.0)).floatValue());
            ItemProperties.register((Item)((Item)ModItems.THERMOMETER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"temperature"), (stack, level, livingEntity, id) -> {
                if (livingEntity instanceof Player) {
                    double worldTemp;
                    Player player = (Player)livingEntity;
                    double minTemp = Temperature.get((LivingEntity)player, Temperature.Trait.FREEZING_POINT);
                    double maxTemp = Temperature.get((LivingEntity)player, Temperature.Trait.BURNING_POINT);
                    if (!player.getPersistentData().contains("WorldTempTimestamp") || player.tickCount % 2 == 0 && player.getPersistentData().getInt("WorldTempTimestamp") != player.tickCount) {
                        worldTemp = Temperature.convert(Overlays.WORLD_TEMP, Preference.getOrDefault(player, Preference.UNITS, Temperature.Units.F), Temperature.Units.MC, true);
                        player.getPersistentData().putDouble("WorldTemp", worldTemp);
                        player.getPersistentData().putInt("WorldTempTimestamp", player.tickCount);
                    } else {
                        worldTemp = player.getPersistentData().getDouble("WorldTemp");
                    }
                    double worldTempAdjusted = Overlays.getWorldSeverity(worldTemp, minTemp, maxTemp) * 1.01;
                    return (float)worldTempAdjusted;
                }
                return 0.0f;
            });
        });
    }

    public static void unregister(Item item) {
        try {
            Map properties = (Map)ITEM_PROPERTIES.get(null);
            properties.remove(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ITEM_PROPERTIES.setAccessible(true);
    }
}

