/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.tooltip.ClientSoulspringTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.InsulationAttributeTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.InsulationTooltip;
import com.momosoftworks.coldsweat.client.gui.tooltip.SoulspringTooltip;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.common.item.SoulspringLampItem;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.enums.InsulationVisibility;
import com.momosoftworks.coldsweat.core.init.ModAttributes;
import com.momosoftworks.coldsweat.core.init.ModItemComponents;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.network.message.SyncItemPredicatesMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.FoodData;
import com.momosoftworks.coldsweat.data.codec.configuration.FuelData;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.AttributeModifierMap;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.FastMap;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT})
public class TooltipHandler {
    public static final Style COLD = Style.EMPTY.withColor(3767039);
    public static final Style HOT = Style.EMPTY.withColor(16736574);
    public static final Component EXPAND_TOOLTIP = Component.literal((String)"[").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"]").withStyle(ChatFormatting.DARK_GRAY));
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.##"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    private static int HOVERED_ITEM_UPDATE_COOLDOWN = 0;
    private static ItemStack HOVERED_STACK = ItemStack.EMPTY;
    public static HashMap<UUID, Boolean> HOVERED_STACK_PREDICATES = new HashMap();
    static int FUEL_FADE_TIMER = 0;

    public static <T extends ConfigData> boolean passesRequirement(T element) {
        return HOVERED_STACK_PREDICATES.getOrDefault(element.uuid(), true);
    }

    public static boolean isShiftDown() {
        return Screen.hasShiftDown() || ConfigSettings.EXPAND_TOOLTIPS.get() != false;
    }

    public static int getTooltipTitleIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipStartIndex;
        block4: {
            if (tooltip.isEmpty()) {
                return 0;
            }
            String hoverName = stack.getHoverName().getString();
            if (CompatManager.isIcebergLoaded()) {
                tooltipStartIndex = CompatManager.LegendaryTooltips.getTooltipStartIndex(tooltip) + 1;
            } else {
                for (tooltipStartIndex = 0; tooltipStartIndex < tooltip.size(); ++tooltipStartIndex) {
                    if (!tooltip.get(tooltipStartIndex).left().map(FormattedText::getString).map(String::strip).orElse("").equals(hoverName)) continue;
                    ++tooltipStartIndex;
                    break block4;
                }
                tooltipStartIndex = 1;
            }
        }
        tooltipStartIndex = CSMath.clamp(tooltipStartIndex, 0, tooltip.size());
        return tooltipStartIndex;
    }

    public static int getTooltipEndIndex(List<Either<FormattedText, TooltipComponent>> tooltip, ItemStack stack) {
        int tooltipEndIndex = tooltip.size();
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            --tooltipEndIndex;
            while (tooltipEndIndex > 0) {
                String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
                if (tooltip.get(tooltipEndIndex).left().map(text -> text.getString().equals(itemId)).orElse(false).booleanValue()) break;
                --tooltipEndIndex;
            }
        }
        tooltipEndIndex = CSMath.clamp(tooltipEndIndex, 0, tooltip.size());
        return tooltipEndIndex;
    }

    public static void addModifierTooltipLines(List<Component> tooltip, AttributeModifierMap map, boolean showIcon, boolean strikethrough) {
        map.getMap().asMap().forEach((attribute, modifiers) -> {
            for (AttributeModifier.Operation operation : AttributeModifier.Operation.values()) {
                double value = 0.0;
                for (AttributeModifier modifier : modifiers.stream().filter(mod -> mod.operation() == operation).toList()) {
                    value += modifier.amount();
                }
                if (value == 0.0) continue;
                tooltip.add((Component)TooltipHandler.getFormattedAttributeModifier((Holder<Attribute>)attribute, value, operation, showIcon, strikethrough));
            }
        });
    }

    public static MutableComponent getFormattedAttributeModifier(Holder<Attribute> attribute, double value, AttributeModifier.Operation operation, boolean forTooltip, boolean strikethrough) {
        MutableComponent component;
        String percent;
        String sign;
        ChatFormatting color;
        String operationString;
        if (attribute == null) {
            return Component.empty();
        }
        String attributeName = ((Attribute)attribute.value()).getDescriptionId().replace("attribute.", "");
        if (operation == AttributeModifier.Operation.ADD_VALUE && (attribute == ModAttributes.FREEZING_POINT.value() || attribute == ModAttributes.BURNING_POINT.value() || attribute == ModAttributes.WORLD_TEMPERATURE.value())) {
            value = Temperature.convert(value, Temperature.Units.MC, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, false);
        }
        String string = operationString = operation == AttributeModifier.Operation.ADD_VALUE ? "add" : "multiply";
        if (value >= 0.0) {
            color = ChatFormatting.BLUE;
            sign = "+";
        } else {
            color = ChatFormatting.RED;
            sign = "";
        }
        if (operation != AttributeModifier.Operation.ADD_VALUE || attribute.equals(ModAttributes.HEAT_RESISTANCE) || attribute.equals(ModAttributes.COLD_RESISTANCE) || attribute.equals(ModAttributes.HEAT_DAMPENING) || attribute.equals(ModAttributes.COLD_DAMPENING)) {
            percent = "%";
            value *= 100.0;
        } else {
            percent = "";
        }
        ArrayList<CallSite> params = new ArrayList<CallSite>(List.of(sign + CSMath.formatDoubleOrInt(CSMath.round(value, 2)) + percent));
        if (EntityTempManager.isTemperatureAttribute(attribute)) {
            component = Component.translatable((String)String.format("attribute.cold_sweat.modifier.%s.%s", operationString, attributeName), (Object[])params.toArray());
        } else {
            component = TooltipHandler.getFormattedVanillaAttributeModifier(attribute, value, operation);
            TranslatableContents contents = (TranslatableContents)component.getContents();
            params.addAll(0, Arrays.asList(contents.getArgs()));
            component = TooltipHandler.setComponentContents(component, (ComponentContents)new TranslatableContents(contents.getKey(), contents.getFallback(), params.toArray()));
        }
        component = component.withStyle(color);
        component = TooltipHandler.addTooltipFlags(component, forTooltip, strikethrough);
        return component;
    }

    public static MutableComponent getFormattedVanillaAttributeModifier(Holder<Attribute> attribute, double amount, AttributeModifier.Operation operation) {
        double adjustedAmount = amount;
        if (operation == AttributeModifier.Operation.ADD_VALUE) {
            adjustedAmount = attribute.equals((Object)Attributes.KNOCKBACK_RESISTANCE) ? amount * 10.0 : amount;
        }
        if (amount >= 0.0) {
            return Component.translatable((String)("attribute.modifier.plus." + operation.id()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(adjustedAmount), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE);
        }
        return Component.translatable((String)("attribute.modifier.take." + operation.id()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(adjustedAmount *= -1.0), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(ChatFormatting.RED);
    }

    public static MutableComponent setComponentContents(MutableComponent component, ComponentContents newContents) {
        MutableComponent newComponent = MutableComponent.create((ComponentContents)newContents).setStyle(component.getStyle());
        component.getSiblings().forEach(arg_0 -> ((MutableComponent)newComponent).append(arg_0));
        return newComponent;
    }

    public static MutableComponent addTooltipFlags(MutableComponent component, boolean showIcon, boolean strikethrough) {
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            ArrayList<Object> params = new ArrayList<Object>(Arrays.asList(translatable.getArgs()));
            if (showIcon) {
                params.add("show_icon");
            }
            if (strikethrough) {
                params.add("strikethrough");
            }
            MutableComponent newComponent = TooltipHandler.setComponentContents(component, (ComponentContents)new TranslatableContents(translatable.getKey(), translatable.getFallback(), params.toArray()));
            if (strikethrough) {
                newComponent.setStyle(Style.EMPTY.withColor(7561572));
            }
            return newComponent;
        }
        return component;
    }

    @SubscribeEvent
    public static void updateHoveredItem(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getItemStack();
        if (!HOVERED_STACK.equals(stack)) {
            AbstractContainerScreen menu;
            Slot hoveredSlot;
            int slotIndex = -1;
            EquipmentSlot equipmentSlot = null;
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof AbstractContainerScreen && (hoveredSlot = (menu = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null) {
                slotIndex = hoveredSlot.getSlotIndex();
                equipmentSlot = EntityHelper.getEquipmentSlot(slotIndex);
            }
            if (stack.isEmpty()) {
                HOVERED_STACK = stack;
            } else if (HOVERED_ITEM_UPDATE_COOLDOWN <= 0) {
                HOVERED_STACK = stack;
                HOVERED_ITEM_UPDATE_COOLDOWN = 5;
                PacketDistributor.sendToServer((CustomPacketPayload)SyncItemPredicatesMessage.fromClient(stack.copy(), slotIndex, equipmentSlot), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void tickHoverCooldown(ClientTickEvent.Post event) {
        if (HOVERED_ITEM_UPDATE_COOLDOWN > 0) {
            --HOVERED_ITEM_UPDATE_COOLDOWN;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addCustomTooltips(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        List elements = event.getTooltipElements();
        InsulationVisibility insulationVisibility = ConfigSettings.INSULATION_VISIBILITY.get();
        LocalPlayer player = Minecraft.getInstance().player;
        float tickRate = player != null ? player.level().tickRateManager().tickrate() : 20.0f;
        int tooltipStartIndex = TooltipHandler.getTooltipTitleIndex(elements, stack);
        int tooltipEndIndex = TooltipHandler.getTooltipEndIndex(elements, stack);
        if (stack.getItem() instanceof SoulspringLampItem) {
            if (!TooltipHandler.isShiftDown() && ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
                elements.add(tooltipStartIndex, Either.left((Object)EXPAND_TOOLTIP));
            }
            elements.add(tooltipStartIndex, Either.right((Object)new SoulspringTooltip((Double)stack.getOrDefault(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)0.0))));
        }
        if (stack.getUseAnimation() == UseAnim.DRINK || stack.getUseAnimation() == UseAnim.EAT) {
            int dietTooltipSectionIndex = CSMath.getIndexOf(elements, line -> line.left().map(text -> text.getString().equalsIgnoreCase(Component.translatable((String)"tooltip.diet.eaten").getString())).orElse(false));
            int index = dietTooltipSectionIndex != -1 ? dietTooltipSectionIndex + 1 : tooltipEndIndex;
            FastMap<Integer, Double> foodTemps = new FastMap<Integer, Double>();
            for (FoodData foodData : ConfigSettings.FOOD_TEMPERATURES.get().get((Object)item)) {
                if (!TooltipHandler.passesRequirement(foodData)) continue;
                foodTemps.merge(foodData.duration(), foodData.temperature(), Double::sum);
            }
            for (Map.Entry entry : foodTemps.entrySet()) {
                MutableComponent consumeEffects;
                double temp = (Double)entry.getValue();
                int duration = (Integer)entry.getKey();
                MutableComponent mutableComponent = temp > 0.0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}).withStyle(HOT) : (consumeEffects = temp == 0.0 ? Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{"+" + CSMath.formatDoubleOrInt(temp)}) : Component.translatable((String)"tooltip.cold_sweat.temperature_effect", (Object[])new Object[]{CSMath.formatDoubleOrInt(temp)}).withStyle(COLD));
                if (duration > 0) {
                    consumeEffects.append(" (" + StringUtil.formatTickDuration((int)duration, (float)tickRate) + ")");
                }
                elements.add(index, Either.left((Object)consumeEffects));
            }
            if (!foodTemps.isEmpty() && dietTooltipSectionIndex == -1) {
                elements.add(tooltipEndIndex, Either.left((Object)Component.translatable((String)"tooltip.cold_sweat.consumed").withStyle(ChatFormatting.GRAY)));
                elements.add(tooltipEndIndex, Either.left((Object)Component.empty()));
            }
        }
        ArrayList<InsulatorData> allUnmetInsulation = new ArrayList<InsulatorData>();
        if (insulationVisibility.canShow() && !stack.isEmpty()) {
            TooltipHandler.addInsulationTooltips(elements, tooltipStartIndex, stack, item, insulationVisibility, allUnmetInsulation);
        }
        int unmetLabelIndex = TooltipHandler.convertAndSortUnmetAttributes(elements);
        if (ConfigSettings.ENABLE_HINTS.get().booleanValue()) {
            TooltipHandler.addUnmetRequirementHints(elements, unmetLabelIndex, allUnmetInsulation);
        }
    }

    private static void addInsulationTooltips(List<Either<FormattedText, TooltipComponent>> elements, int tooltipStartIndex, ItemStack stack, Item item, InsulationVisibility insulationVisibility, List<InsulatorData> allUnmetInsulation) {
        ArrayList<InsulatorData> armorInsulation = new ArrayList<InsulatorData>();
        ArrayList<InsulatorData> unmetArmorInsulation = new ArrayList<InsulatorData>();
        for (InsulatorData insulator : ConfigSettings.INSULATING_ARMORS.get().get((Object)item)) {
            TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation, allUnmetInsulation);
        }
        ItemInsulationManager.getInsulationCap(stack).ifPresent(cap -> {
            List<Pair<ItemStack, List<InsulatorData>>> insulatorPairs = cap.getInsulation();
            for (int i = 0; i < insulatorPairs.size(); ++i) {
                Pair<ItemStack, List<InsulatorData>> pair = insulatorPairs.get(i);
                for (InsulatorData insulator : (List)pair.getSecond()) {
                    TooltipHandler.validateInsulator(insulator, armorInsulation, unmetArmorInsulation, allUnmetInsulation);
                }
            }
        });
        if (!armorInsulation.isEmpty() || insulationVisibility.showsIfEmpty()) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(armorInsulation, Insulation.Slot.ARMOR, stack, false)));
        }
        if (!unmetArmorInsulation.isEmpty()) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetArmorInsulation, Insulation.Slot.ARMOR, stack, true)));
        }
        ArrayList<InsulatorData> insulation = new ArrayList<InsulatorData>();
        ArrayList<InsulatorData> unmetInsulation = new ArrayList<InsulatorData>();
        Iterator iterator = ConfigSettings.INSULATION_ITEMS.get().get((Object)item).iterator();
        while (iterator.hasNext()) {
            InsulatorData insulator;
            TooltipHandler.validateInsulator(insulator, insulation, (insulator = (InsulatorData)iterator.next()).hideIfUnmet() ? new ArrayList<InsulatorData>() : unmetInsulation, allUnmetInsulation);
        }
        if (!insulation.isEmpty() && !insulation.stream().map(InsulatorData::insulation).toList().equals(armorInsulation.stream().map(InsulatorData::insulation).toList())) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(insulation, Insulation.Slot.ITEM, stack, false)));
        }
        if (!unmetInsulation.isEmpty() && !unmetInsulation.stream().map(InsulatorData::insulation).toList().equals(unmetArmorInsulation.stream().map(InsulatorData::insulation).toList())) {
            elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetInsulation, Insulation.Slot.ITEM, stack, true)));
        }
        if (CompatManager.isCuriosLoaded()) {
            ArrayList<InsulatorData> curioInsulation = new ArrayList<InsulatorData>();
            ArrayList<InsulatorData> unmetCurioInsulation = new ArrayList<InsulatorData>();
            for (InsulatorData insulator : ConfigSettings.INSULATING_CURIOS.get().get((Object)item)) {
                TooltipHandler.validateInsulator(insulator, curioInsulation, unmetCurioInsulation, allUnmetInsulation);
            }
            if (!curioInsulation.isEmpty()) {
                elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(curioInsulation, Insulation.Slot.CURIO, stack, false)));
            }
            if (!unmetCurioInsulation.isEmpty()) {
                elements.add(tooltipStartIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationTooltip(unmetCurioInsulation, Insulation.Slot.CURIO, stack, true)));
            }
        }
    }

    private static int convertAndSortUnmetAttributes(List<Either<FormattedText, TooltipComponent>> elements) {
        boolean hasAttributes = false;
        boolean foundUnmetAttribute = false;
        int unmetLabelIndex = elements.size();
        int unmetAttributeIndex = elements.size();
        for (int i = 0; i < elements.size(); ++i) {
            List<Object> args;
            TranslatableContents translatableContents;
            Component component;
            ComponentContents componentContents;
            Object t;
            Either<FormattedText, TooltipComponent> element = elements.get(i);
            if (!element.left().isPresent() || !((t = element.left().get()) instanceof Component) || !((componentContents = (component = (Component)t).getContents()) instanceof TranslatableContents) || (translatableContents = (TranslatableContents)componentContents).getArgs() == null) continue;
            if (translatableContents.getKey().contains("item.modifiers")) {
                if (!hasAttributes) {
                    hasAttributes = true;
                    unmetLabelIndex = i;
                }
                foundUnmetAttribute = false;
            }
            if (!(args = Arrays.asList(translatableContents.getArgs())).contains("show_icon")) continue;
            boolean strikethrough = args.contains("strikethrough");
            if (strikethrough && !foundUnmetAttribute) {
                unmetAttributeIndex = i;
                foundUnmetAttribute = true;
            }
            if (!strikethrough && i > unmetAttributeIndex) {
                elements.remove(i);
                elements.add(unmetAttributeIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip(component, Minecraft.getInstance().font, strikethrough)));
                --i;
                continue;
            }
            elements.set(i, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip(component, Minecraft.getInstance().font, strikethrough)));
        }
        return unmetLabelIndex;
    }

    private static void addUnmetRequirementHints(List<Either<FormattedText, TooltipComponent>> elements, int unmetLabelIndex, List<InsulatorData> allUnmetInsulation) {
        int hintIndex;
        boolean addedUnmetLabel = false;
        for (hintIndex = 0; hintIndex < allUnmetInsulation.size(); ++hintIndex) {
            MutableComponent hintText;
            InsulatorData unmetInsulator = allUnmetInsulation.get(hintIndex);
            Optional<InsulatorData.HintText> hint = unmetInsulator.hint();
            if (!hint.isPresent()) continue;
            if (!addedUnmetLabel) {
                MutableComponent unmetAttributesTooltip = Component.translatable((String)"tooltip.cold_sweat.unmet_attributes").withStyle(ChatFormatting.RED);
                elements.add(unmetLabelIndex, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip((Component)unmetAttributesTooltip, Minecraft.getInstance().font, false)));
                addedUnmetLabel = true;
            }
            if ((hintText = hint.get().getText()).getString().isEmpty()) continue;
            hintText.setStyle(hintText.getStyle().withColor(7561572));
            elements.add(unmetLabelIndex + hintIndex + 1, (Either<FormattedText, TooltipComponent>)Either.right((Object)new InsulationAttributeTooltip((Component)hintText, Minecraft.getInstance().font, true)));
        }
        if (addedUnmetLabel) {
            elements.add(unmetLabelIndex + hintIndex + 1, (Either<FormattedText, TooltipComponent>)Either.left((Object)Component.empty()));
        }
    }

    private static void validateInsulator(InsulatorData insulator, List<InsulatorData> insulation, List<InsulatorData> unmetInsulation, List<InsulatorData> allUnmetInsulation) {
        boolean isEmpty = insulator.insulation().isEmpty();
        if (TooltipHandler.passesRequirement(insulator)) {
            if (!isEmpty) {
                insulation.add(insulator);
            }
        } else if (!insulator.hideIfUnmet()) {
            if (!isEmpty) {
                unmetInsulation.add(insulator);
            }
            allUnmetInsulation.add(insulator);
        }
    }

    @SubscribeEvent
    public static void renderSoulLampInsertTooltip(ScreenEvent.Render.Post event) {
        AbstractContainerScreen screen;
        Screen screen2 = event.getScreen();
        if (screen2 instanceof AbstractContainerScreen && (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse() != null && screen.getSlotUnderMouse().getItem().getItem() == ModItems.SOULSPRING_LAMP.value()) {
            double fuel = (Double)screen.getSlotUnderMouse().getItem().getOrDefault(ModItemComponents.SOULSPRING_LAMP_FUEL, (Object)0.0);
            ItemStack carriedStack = screen.getMenu().getCarried();
            FuelData itemFuel = ConfigHelper.getFirstOrNull(ConfigSettings.SOULSPRING_LAMP_FUEL, carriedStack.getItem(), data -> data.test(carriedStack));
            if (!carriedStack.isEmpty() && itemFuel != null) {
                double fuelValue = (double)screen.getMenu().getCarried().getCount() * itemFuel.fuel();
                int slotX = screen.getSlotUnderMouse().x + screen.getGuiLeft();
                int slotY = screen.getSlotUnderMouse().y + screen.getGuiTop();
                GuiGraphics graphics = event.getGuiGraphics();
                PoseStack ps = graphics.pose();
                ps.pushPose();
                if (event.getMouseY() < slotY + 8) {
                    ps.translate(0.0f, 32.0f, 0.0f);
                }
                graphics.renderTooltip(Minecraft.getInstance().font, List.of(Component.literal((String)"       ")), Optional.empty(), slotX - 18, slotY + 1);
                RenderSystem.defaultBlendFunc();
                graphics.blit(ClientSoulspringTooltip.TOOLTIP_LOCATION.get(), slotX - 7, slotY - 11, 401, 0.0f, 0.0f, 30, 8, 30, 34);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.15f + (float)((Math.sin((float)FUEL_FADE_TIMER / 5.0f) + 1.0) / 2.0) * 0.4f));
                graphics.blit(ClientSoulspringTooltip.TOOLTIP_LOCATION.get(), slotX - 7, slotY - 11, 401, 0.0f, 8.0f, Math.min(30, (int)((fuel + fuelValue) / (double)2.1333f)), 8, 30, 34);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.blit(ClientSoulspringTooltip.TOOLTIP_LOCATION.get(), slotX - 7, slotY - 11, 401, 0.0f, 16.0f, (int)(fuel / (double)2.1333f), 8, 30, 34);
                ps.popPose();
            }
        }
    }

    @SubscribeEvent
    public static void tickSoulLampInsertTooltip(ClientTickEvent.Post event) {
        ++FUEL_FADE_TIMER;
    }
}

