/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.momosoftworks.coldsweat.api.temperature.modifier.WaterTempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import oshi.util.tuples.Triplet;

@EventBusSubscriber(value={Dist.CLIENT})
public class WetnessRenderer {
    private static final ResourceLocation WATER_DROP = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/droplet.png");
    private static final ResourceLocation WATER_DROP_TRAIL = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/overlay/droplet_trail.png");
    private static final List<Droplet> WATER_DROPS = new ArrayList<Droplet>();
    private static final List<Triplet<Vector2i, Float, Integer>> TRAILS = new ArrayList<Triplet<Vector2i, Float, Integer>>();
    private static boolean WAS_SUBMERGED = false;
    private static int LEFT_DROPLETS = 0;
    private static int RIGHT_DROPLETS = 0;
    private static final int MAX_DROPLETS = 5;

    @SubscribeEvent
    public static void updateSkyBrightness(ClientTickEvent.Pre event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            level.updateSkyBrightness();
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        boolean justExitedWater;
        LocalPlayer player;
        if (!ConfigSettings.WATER_EFFECT_SETTING.get().showGui()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        float frametime = mc.getTimer().getRealtimeDeltaTicks();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        boolean paused = mc.isPaused();
        int uiScale = (Integer)mc.options.guiScale().get();
        if (uiScale == 0) {
            uiScale = mc.getWindow().calculateScale(0, mc.isEnforceUnicode());
        }
        if ((player = mc.player) == null || player.isSpectator()) {
            return;
        }
        BlockPos playerPos = BlockPos.containing((Position)player.getEyePosition());
        float playerYVelocity = (float)(player.position().y - player.yOld);
        boolean isSubmerged = player.getEyeInFluidType() == Fluids.WATER.getFluidType();
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        double midTemp = (ConfigSettings.MIN_TEMP.get() + ConfigSettings.MAX_TEMP.get()) / 2.0;
        float tempMult = (float)CSMath.blend(1.0, 3.0, Temperature.get((LivingEntity)player, Temperature.Trait.WORLD), midTemp, ConfigSettings.MAX_TEMP.get() * 2.0);
        if (isSubmerged && !paused) {
            TRAILS.clear();
            for (Droplet drop : WATER_DROPS) {
                drop.alpha -= 0.6f * frametime;
                float xMoveDir = drop.position.x < (float)screenWidth / 2.0f ? -1.0f : 1.0f;
                float yMoveDir = drop.position.y < (float)screenHeight / 2.0f ? -1.0f : 1.0f;
                drop.position.add((Vector2fc)new Vector2f(xMoveDir, yMoveDir).mul(200.0f * -playerYVelocity * frametime));
            }
        }
        double wetness = Temperature.getModifier((LivingEntity)mc.player, Temperature.Trait.WORLD, WaterTempModifier.class).map(mod -> CSMath.blend(0.0, 1.0, Math.abs(mod.getTemperature()), 0.0, 0.2)).orElse(0.0);
        boolean bl = justExitedWater = WAS_SUBMERGED && !isSubmerged;
        if (justExitedWater) {
            for (int i = 0; i < 10; ++i) {
                Droplet newDrop = WetnessRenderer.createDrop(screenWidth);
                newDrop.yMotion = WetnessRenderer.getRandomVelocity(frametime) / 2.0f + 0.3f;
                newDrop.position.y = (float)(Math.sin(i * 4 + player.tickCount) / 2.0 + 0.5) * (float)screenHeight;
                newDrop.position.x = (float)((double)i / 10.0) * (float)screenWidth;
                WATER_DROPS.add(newDrop);
            }
        }
        boolean bl2 = WAS_SUBMERGED = player.isAlive() && isSubmerged;
        if (!paused && !isSubmerged && wetness > (double)0.01f && (double)((float)Math.random()) * 0.05 < (double)0.0015f * wetness * (double)(frametime * 2.0f) && WATER_DROPS.size() < 5) {
            WATER_DROPS.add(WetnessRenderer.createDrop(screenWidth));
        }
        int waterColor = BiomeColors.getAverageWaterColor((BlockAndTintGetter)player.level(), (BlockPos)playerPos);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getParticleShader);
        GuiGraphics graphics = event.getGuiGraphics();
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int blockLight = player.level().getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(playerPos);
        int skyLight = player.level().getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(playerPos);
        int combinedLight = LightTexture.pack((int)blockLight, (int)skyLight);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        for (int i = 0; i < WATER_DROPS.size(); ++i) {
            Droplet drop = WATER_DROPS.get(i);
            Vector2f pos = drop.position;
            float alpha = drop.alpha;
            drop.size = ConfigSettings.WATER_DROPLET_SCALE.get().clamp(drop.size);
            int scaledSize = drop.size / uiScale * 3;
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale), (int)pos.y, scaledSize, scaledSize, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (!paused) {
                    drop.alpha = wetness <= 0.0 ? (drop.alpha -= 0.08f * frametime) : (drop.alpha -= 0.003f * frametime * tempMult);
                    if (drop.yMotionUpdateCooldown <= 0.0f) {
                        drop.yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
                        drop.yMotion = WetnessRenderer.getRandomVelocity(frametime);
                    } else {
                        drop.yMotionUpdateCooldown -= frametime;
                    }
                    if (drop.XMotionUpdateCooldown <= 0.0f) {
                        drop.XMotionUpdateCooldown = (float)Math.random() * 8.0f + 4.0f;
                        drop.xMotion = (float)Math.random() * 0.02f - 0.01f;
                    }
                    drop.XMotionUpdateCooldown -= frametime;
                    int oldY = (int)pos.y;
                    if (!isSubmerged) {
                        drop.position.add((Vector2fc)new Vector2f(drop.xMotion * drop.yMotion * 20.0f + drop.xVelocity, drop.yMotion).div((float)uiScale).mul(3.0f));
                    }
                    for (int j = 0; j < Math.max(0, (int)(pos.y - (float)oldY)); ++j) {
                        TRAILS.add((Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i((int)pos.x, oldY + j), (Object)Float.valueOf(alpha), (Object)drop.size));
                    }
                }
                if (pos.x < -20.0f) {
                    pos.x = screenWidth + 20;
                } else if (pos.x > (float)(screenWidth + 20)) {
                    pos.x = -20.0f;
                }
                if (!(pos.y > (float)screenHeight)) continue;
                WetnessRenderer.removeDrop(drop);
                --i;
                continue;
            }
            WetnessRenderer.removeDrop(drop);
            --i;
        }
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WATER_DROP_TRAIL);
        bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        for (int i = 0; i < TRAILS.size(); ++i) {
            Triplet<Vector2i, Float, Integer> trail = TRAILS.get(i);
            Vector2i pos = (Vector2i)trail.getA();
            float alpha = ((Float)trail.getB()).floatValue();
            int size = (Integer)trail.getC();
            if (alpha > 0.0f) {
                WetnessRenderer.renderQuadDirect(poseStack, bufferBuilder, (int)CSMath.roundNearest(pos.x, 3.0f / (float)uiScale * 4.0f), pos.y, size / uiScale * 3, 1, 0.0f, 0.0f, 1.0f, 1.0f, alpha, combinedLight, waterColor);
                if (paused) continue;
                alpha = wetness <= 0.0 ? (alpha -= 0.08f * frametime) : (alpha -= 0.045f * frametime * tempMult / 2.0f);
                TRAILS.set(i, (Triplet<Vector2i, Float, Integer>)new Triplet((Object)new Vector2i(pos.x, pos.y), (Object)Float.valueOf(alpha), (Object)size));
                continue;
            }
            TRAILS.remove(trail);
            --i;
        }
        meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.getInstance().gameRenderer.lightTexture().turnOffLightLayer();
        poseStack.popPose();
    }

    private static float getRandomVelocity(float frametime) {
        return (float)Math.min((double)(0.7f * frametime * 20.0f), Math.pow(Math.random() * 5.0 + (double)0.1f, 3.0) * (double)frametime / 4.0);
    }

    private static Droplet createDrop(int screenWidth) {
        int x;
        Droplet.Side side;
        IntegerBounds dropSize = ConfigSettings.WATER_DROPLET_SCALE.get();
        int size = dropSize.getRandom();
        Droplet.Side side2 = side = Math.random() < 0.5 ? Droplet.Side.LEFT : Droplet.Side.RIGHT;
        if (WetnessRenderer.getDropletsOnSide(side) > WetnessRenderer.getDropletsOnSide(side.opposite())) {
            side = side.opposite();
        }
        int xOffset = (int)(Math.random() * (double)screenWidth / 4.0);
        int n = x = side == Droplet.Side.LEFT ? xOffset : screenWidth - xOffset;
        if (side == Droplet.Side.LEFT) {
            ++LEFT_DROPLETS;
        } else {
            ++RIGHT_DROPLETS;
        }
        return new Droplet(new Vector2f((float)x, (float)(-size)), 1.0f, size, side);
    }

    private static void removeDrop(Droplet droplet) {
        if (droplet.side == Droplet.Side.LEFT) {
            --LEFT_DROPLETS;
        } else {
            --RIGHT_DROPLETS;
        }
        WATER_DROPS.remove(droplet);
    }

    private static int getDropletsOnSide(Droplet.Side side) {
        return side == Droplet.Side.LEFT ? LEFT_DROPLETS : RIGHT_DROPLETS;
    }

    private static void renderQuadDirect(PoseStack poseStack, BufferBuilder buffer, int x, int y, int width, int height, float u, float v, float uWidth, float vHeight, float alpha, int lightLevel, int waterColor) {
        alpha = (float)((double)alpha * ConfigSettings.WATER_DROPLET_OPACITY.get());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        Matrix4f lastPose = poseStack.last().pose();
        buffer.addVertex(lastPose, (float)x, (float)y, 0.0f).setUv(u, v).setColor(red, green, blue, alpha).setLight(lightLevel);
        buffer.addVertex(lastPose, (float)x, (float)(y + height), 0.0f).setUv(u, v + vHeight).setColor(red, green, blue, alpha).setLight(lightLevel);
        buffer.addVertex(lastPose, (float)(x + width), (float)(y + height), 0.0f).setUv(u + uWidth, v + vHeight).setColor(red, green, blue, alpha).setLight(lightLevel);
        buffer.addVertex(lastPose, (float)(x + width), (float)y, 0.0f).setUv(u + uWidth, v).setColor(red, green, blue, alpha).setLight(lightLevel);
    }

    protected static class Droplet {
        public Vector2f position;
        public float alpha;
        public int size;
        public float yMotion = WetnessRenderer.getRandomVelocity(Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() / 5.0f);
        public float xMotion = (float)Math.random() * 0.02f - 0.01f;
        public float xVelocity = 0.0f;
        public float yMotionUpdateCooldown = (float)Math.random() * 16.0f + 8.0f;
        public float XMotionUpdateCooldown = 16.0f;
        public Side side;

        public Droplet(Vector2f position, float alpha, int size, Side side) {
            this.position = position;
            this.alpha = alpha;
            this.size = size;
            this.side = side;
        }

        public static enum Side {
            LEFT,
            RIGHT;


            public Side opposite() {
                return this == LEFT ? RIGHT : LEFT;
            }
        }
    }
}

