/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.momosoftworks.coldsweat.client.gui.AbstractHearthScreen;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.container.BoilerContainer;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BoilerScreen
extends AbstractHearthScreen<BoilerContainer> {
    private static final ResourceLocation BOILER_GUI = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/screen/boiler_gui.png");

    @Override
    HearthBlockEntity getBlockEntity() {
        return ((BoilerContainer)this.menu).te;
    }

    public BoilerScreen(BoilerContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.imageWidth = 176;
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = this.leftPos + this.imageWidth / 2 - Minecraft.getInstance().font.width((FormattedText)this.getTitle()) / 2;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(BOILER_GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.renderFuelGauge(HearthBlockEntity.FuelType.HOT, graphics, this.leftPos + 100, this.topPos + 63, ((BoilerContainer)this.menu).getFuel(), ((BoilerContainer)this.menu).te.getMaxFuel());
        if (!ConfigSettings.SMART_HEARTH.get().booleanValue() && ((BoilerContainer)this.menu).te.hasSmokestack()) {
            boolean powered = ((BoilerContainer)this.menu).te.isHeatingOn();
            this.renderPowerIndicator(graphics, this.leftPos + 101, this.topPos + 78, powered);
            if (CSMath.betweenInclusive(mouseX, this.leftPos + 98, this.leftPos + 117) && CSMath.betweenInclusive(mouseY, this.topPos + 75, this.topPos + 82)) {
                this.setTooltipForNextRenderPass((Component)Component.translatable((String)(powered ? "gui.cold_sweat.hearth.powered" : "gui.cold_sweat.hearth.unpowered")));
            }
        }
    }
}

