/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.particle;

import com.momosoftworks.coldsweat.client.particle.ParticleUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VaporParticle
extends TextureSheetParticle {
    private final SpriteSet ageSprite;
    private final boolean hasGravity;
    private boolean collidedY;
    private float maxAlpha;
    VaporType type;

    protected VaporParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, VaporType type) {
        super(world, x, y, z);
        this.ageSprite = spriteSet;
        this.alpha = 0.0f;
        this.maxAlpha = (float)(Math.random() / 3.0 + 0.5);
        this.scale(3.0f + (float)(Math.random() / 2.5));
        this.setSize(this.quadSize / 10.0f, this.quadSize / 10.0f);
        this.lifetime = 40 + (int)(Math.random() * 20.0 - 10.0);
        this.hasPhysics = true;
        this.setParticleSpeed(vx, vy, vz);
        this.setSpriteFromAge(spriteSet);
        this.hasGravity = type == VaporType.GROUND_MIST;
        this.type = type;
        switch (type.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                float f = -0.04f;
                break;
            }
            case 1: {
                float f = 0.04f;
                break;
            }
            case 2: {
                float f = this.gravity = 0.0f;
            }
        }
        if (type == VaporType.MIST) {
            this.maxAlpha = 0.2f;
        }
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleUtil.PARTICLE_SHEET_TRANSPARENT;
    }

    public void tick() {
        if (Minecraft.getInstance().options.particles().get() == ParticleStatus.MINIMAL) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd * (this.onGround ? 1.0 : 0.2), this.yd, this.zd * (this.onGround ? 1.0 : 0.2));
            this.xd *= 0.99;
            this.yd *= 0.99;
            this.xd *= 0.99;
        }
        this.setSpriteFromAge(this.ageSprite);
        if (this.type == VaporType.GROUND_MIST) {
            if (this.alpha < this.maxAlpha) {
                this.alpha += 0.02f;
            } else if (this.age > 32) {
                this.alpha -= 0.02f;
            }
            if ((double)this.alpha < 0.035 && this.age > 10) {
                this.remove();
            }
        } else if (this.type == VaporType.MIST || this.type == VaporType.STEAM) {
            if (this.alpha < this.maxAlpha) {
                this.alpha += this.maxAlpha / 20.0f;
            } else if ((float)this.age > this.maxAlpha / (this.maxAlpha / 20.0f)) {
                this.alpha -= this.maxAlpha / 20.0f;
            }
            if ((double)this.alpha < 0.02 && this.age > 10) {
                this.remove();
            }
        }
    }

    public void move(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.hasPhysics && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 vec3 = Entity.collideBoundingBox((Entity)null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec3.x;
            y = vec3.y;
            z = vec3.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, this.collidedY ? 0.0 : y, z));
            AABB axisalignedbb = this.getBoundingBox();
            this.x = (axisalignedbb.minX + axisalignedbb.maxX) / 2.0;
            this.y = axisalignedbb.minY + (this.hasGravity ? 0.2 : 0.0);
            this.z = (axisalignedbb.minZ + axisalignedbb.maxZ) / 2.0;
        }
        if (Math.abs(d1) >= 1.0E-5 && Math.abs(y) < 1.0E-5) {
            this.collidedY = true;
        }
        boolean bl = this.onGround = d1 != y && d1 < 0.0;
        if (d0 != x) {
            this.xd = 0.0;
        }
        if (d2 != z) {
            this.zd = 0.0;
        }
    }

    public static enum VaporType {
        STEAM,
        GROUND_MIST,
        MIST;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MistFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public MistFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GroundMistFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GroundMistFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.GROUND_MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SteamFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SteamFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (Minecraft.getInstance().options.particles().get() != ParticleStatus.MINIMAL) {
                return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.STEAM);
            }
            return null;
        }
    }
}

