/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.model.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.client.renderer.ChameleonAnimations;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.core.init.ModEntities;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChameleonModel<T extends Chameleon>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"chameleon"), "main");
    final Map<String, ModelPart> modelParts;
    final ModelPart body;
    final ModelPart head;
    Chameleon chameleon;
    boolean tongueVisible = false;

    public ChameleonModel(ModelPart root) {
        super(RenderType::entityTranslucent, true, 4.75f, 0.75f, 1.8f, 1.6f, 14.0f);
        this.body = root.getChild("Body");
        this.head = root.getChild("Head");
        this.head.y = 19.2f;
        this.body.y -= 0.8f;
        this.modelParts = AnimationManager.getChildrenMap(root);
        AnimationManager.storeDefaultPoses((EntityType)ModEntities.CHAMELEON.value(), this.modelParts);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(1, 16).addBox(-2.0f, -8.0f, -3.0f, 4.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -7.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition TopFrill = Head.addOrReplaceChild("TopFrill", CubeListBuilder.create().texOffs(30, 0).addBox(-1.0f, 1.4f, 0.05f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(15, 7).addBox(-2.0f, 0.0f, -7.0f, 4.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(18, 15).addBox(0.0f, 1.0f, -6.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightEye = Head.addOrReplaceChild("RightEye", CubeListBuilder.create().texOffs(15, 1).addBox(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)0.0f, (float)-3.5f));
        PartDefinition LeftEye = Head.addOrReplaceChild("LeftEye", CubeListBuilder.create().texOffs(15, 1).mirror().addBox(-5.0E-4f, -1.4782f, -1.634f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.0005f, (float)-0.0218f, (float)-3.366f));
        PartDefinition Tongue1 = Head.addOrReplaceChild("Tongue1", CubeListBuilder.create().texOffs(27, 25).addBox(-1.0f, 0.0f, -7.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition Tongue2 = Tongue1.addOrReplaceChild("Tongue2", CubeListBuilder.create().texOffs(27, 25).addBox(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)3.0f));
        PartDefinition Tongue3 = Tongue2.addOrReplaceChild("Tongue3", CubeListBuilder.create().texOffs(27, 25).addBox(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontLeg = Body.addOrReplaceChild("RightFrontLeg", CubeListBuilder.create().texOffs(38, 25).mirror().addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition RightFrontLeg2 = RightFrontLeg.addOrReplaceChild("RightFrontLeg2", CubeListBuilder.create().texOffs(38, 29).mirror().addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontFoot1 = RightFrontLeg2.addOrReplaceChild("RightFrontFoot1", CubeListBuilder.create().texOffs(28, 27).mirror().addBox(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontFoot2 = RightFrontLeg2.addOrReplaceChild("RightFrontFoot2", CubeListBuilder.create().texOffs(28, 24).mirror().addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontLeg = Body.addOrReplaceChild("LeftFrontLeg", CubeListBuilder.create().texOffs(38, 25).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition LeftFrontLeg2 = LeftFrontLeg.addOrReplaceChild("LeftFrontLeg2", CubeListBuilder.create().texOffs(38, 29).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontFoot1 = LeftFrontLeg2.addOrReplaceChild("LeftFrontFoot1", CubeListBuilder.create().texOffs(28, 27).addBox(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontFoot2 = LeftFrontLeg2.addOrReplaceChild("LeftFrontFoot2", CubeListBuilder.create().texOffs(28, 24).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackLeg = Body.addOrReplaceChild("RightBackLeg", CubeListBuilder.create().texOffs(38, 25).mirror().addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)-3.0f, (float)4.0f));
        PartDefinition RightBackLeg2 = RightBackLeg.addOrReplaceChild("RightBackLeg2", CubeListBuilder.create().texOffs(38, 29).mirror().addBox(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackFoot1 = RightBackLeg2.addOrReplaceChild("RightBackFoot1", CubeListBuilder.create().texOffs(28, 27).mirror().addBox(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackFoot2 = RightBackLeg2.addOrReplaceChild("RightBackFoot2", CubeListBuilder.create().texOffs(28, 24).mirror().addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackLeg = Body.addOrReplaceChild("LeftBackLeg", CubeListBuilder.create().texOffs(38, 25).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)4.0f));
        PartDefinition LeftBackLeg2 = LeftBackLeg.addOrReplaceChild("LeftBackLeg2", CubeListBuilder.create().texOffs(38, 29).addBox(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackFoot1 = LeftBackLeg2.addOrReplaceChild("LeftBackFoot1", CubeListBuilder.create().texOffs(28, 27).addBox(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackFoot2 = LeftBackLeg2.addOrReplaceChild("LeftBackFoot2", CubeListBuilder.create().texOffs(27, 24).addBox(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(34, 18).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.5f, (float)6.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(38, 13).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasLookTarget;
        this.chameleon = entity;
        AnimationManager.loadAnimationStates(entity, this.modelParts);
        float tickDelta = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        ModelPart head = this.modelParts.get("Head");
        ModelPart rightEye = this.modelParts.get("RightEye");
        ModelPart leftEye = this.modelParts.get("LeftEye");
        float desiredXHead = CSMath.toRadians(headPitch);
        boolean bl = hasLookTarget = ((Chameleon)((Object)entity)).isWalking() || ((Chameleon)((Object)entity)).getEatTimer() > 0.0f;
        if (Double.isNaN(((Chameleon)((Object)entity)).xRotHead)) {
            ((Chameleon)((Object)entity)).xRotHead = 0.0f;
        }
        ((Chameleon)((Object)entity)).xRotHead = ((Chameleon)((Object)entity)).xRotHead + ((hasLookTarget ? desiredXHead : CSMath.clamp(((Chameleon)((Object)entity)).xRotHead, desiredXHead - 0.4f, desiredXHead + 0.4f)) - ((Chameleon)((Object)entity)).xRotHead) * tickDelta;
        float desiredYHead = CSMath.toRadians(netHeadYaw);
        if (Double.isNaN(((Chameleon)((Object)entity)).yRotHead)) {
            ((Chameleon)((Object)entity)).yRotHead = 0.0f;
        }
        ((Chameleon)((Object)entity)).yRotHead = ((Chameleon)((Object)entity)).yRotHead + ((hasLookTarget ? desiredYHead : CSMath.clamp(((Chameleon)((Object)entity)).yRotHead, desiredYHead - 0.6f, desiredYHead + 0.6f)) - ((Chameleon)((Object)entity)).yRotHead) * tickDelta;
        if (head.yRot < desiredYHead) {
            ((Chameleon)((Object)entity)).yRotRightEye += (-CSMath.clamp(desiredYHead - head.yRot, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).yRotRightEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotRightEye += (-CSMath.clamp(desiredXHead - head.xRot, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).xRotRightEye) * tickDelta;
        } else {
            ((Chameleon)((Object)entity)).yRotRightEye += (0.0f - ((Chameleon)((Object)entity)).yRotRightEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotRightEye += (0.0f - ((Chameleon)((Object)entity)).xRotRightEye) * tickDelta;
        }
        if (head.yRot > desiredYHead) {
            ((Chameleon)((Object)entity)).yRotLeftEye += (CSMath.clamp(head.yRot - desiredYHead, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).yRotLeftEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotLeftEye += (CSMath.clamp(desiredXHead - head.xRot, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).xRotLeftEye) * tickDelta;
        } else {
            T t = entity;
            ((Chameleon)((Object)t)).yRotLeftEye = ((Chameleon)((Object)t)).yRotLeftEye + -((Chameleon)((Object)entity)).yRotLeftEye * tickDelta;
            t = entity;
            ((Chameleon)((Object)t)).xRotLeftEye = ((Chameleon)((Object)t)).xRotLeftEye + -((Chameleon)((Object)entity)).xRotLeftEye * tickDelta;
        }
        head.xRot = ((Chameleon)((Object)entity)).xRotHead;
        head.yRot = ((Chameleon)((Object)entity)).yRotHead;
        rightEye.yRot = ((Chameleon)((Object)entity)).yRotRightEye;
        rightEye.zRot = ((Chameleon)((Object)entity)).xRotRightEye;
        leftEye.yRot = ((Chameleon)((Object)entity)).yRotLeftEye;
        leftEye.zRot = ((Chameleon)((Object)entity)).xRotLeftEye;
        AnimationManager.saveAnimationStates(entity, this.modelParts);
        AnimationManager.animateEntity(entity, (animTime, frameTime) -> {
            Vec3 velocity;
            Entity patt0$temp;
            float prevAnimTime = animTime.floatValue();
            HashMap<String, ModelPart> animatedParts = new HashMap<String, ModelPart>(this.modelParts);
            animatedParts.remove("Head");
            animatedParts.remove("LeftEye");
            animatedParts.remove("RightEye");
            ModelPart tail = (ModelPart)animatedParts.remove("Tail");
            ModelPart tail2 = (ModelPart)animatedParts.remove("Tail2");
            ModelPart tail3 = (ModelPart)animatedParts.remove("Tail3");
            if (this.riding && (patt0$temp = entity.getVehicle()) instanceof Player) {
                Player player = (Player)patt0$temp;
                float playerYaw = CSMath.blend(player.yHeadRotO, player.yHeadRot, partialTick, 0.0f, 1.0f);
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.RIDE.animateAll(animatedParts, animTime.floatValue(), false);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.RIDE.animate("Tail", tail, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail2", tail2, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail3", tail3, 0.0f, false);
                }
                if (this.young) {
                    this.body.y -= 1.0f;
                }
                this.body.y -= player.getBbHeight() / 2.0f * 16.0f - 26.0f;
                head.y -= player.getBbHeight() / 2.0f * 16.0f - 11.0f;
                head.z += 1.5f;
                this.body.yRot = CSMath.toRadians(playerYaw) - CSMath.toRadians(CSMath.blend(player.yBodyRotO, player.yBodyRot, partialTick, 0.0f, 1.0f));
                head.yRot = CSMath.toRadians(entity.getViewYRot(partialTick) - player.getViewYRot(partialTick)) + 0.2f;
                head.xRot = CSMath.clamp(CSMath.toRadians(entity.getViewXRot(partialTick) - player.getViewXRot(partialTick)) + 0.2f, -1.0f, 1.0f);
            } else if (entity.isWalking()) {
                float walkSpeed = Math.min(0.15f, new Vec2((float)entity.getDeltaMovement().x, (float)entity.getDeltaMovement().z).length());
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue() * walkSpeed * (float)(this.young ? 50 : 30));
                ChameleonAnimations.WALK.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", tail, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail2", tail2, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail3", tail3, animTime.floatValue(), true);
                }
            } else {
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.IDLE.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", tail, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail2", tail2, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail3", tail3, 0.0f, true);
                }
            }
            if (this.chameleon.isTracking()) {
                float rotY;
                BlockPos trackingPos = this.chameleon.getTrackingPos();
                Vec3 entityPos = entity.getPosition(partialTick);
                Vec3 trackingDirection = new Vec3((double)trackingPos.getX() - entityPos.x, 0.0, (double)trackingPos.getZ() - entityPos.z);
                float playerRotX = 0.0f;
                Entity patt1$temp = entity.getVehicle();
                if (patt1$temp instanceof Player) {
                    Player player = (Player)patt1$temp;
                    playerRotX = player.getViewXRot(partialTick);
                    rotY = CSMath.blend(player.yHeadRotO, player.yHeadRot, partialTick, 0.0f, 1.0f);
                } else {
                    rotY = CSMath.blend(entity.yBodyRotO, entity.yBodyRot, partialTick, 0.0f, 1.0f);
                }
                float angle = (float)Math.atan2(trackingDirection.z, trackingDirection.x) - CSMath.toRadians(Mth.wrapDegrees((float)rotY));
                float desiredTailRot = angle + CSMath.toRadians(90.0f);
                tail.yRot = tail2.yRot = (float)Math.sin(desiredTailRot) / 1.3f;
                tail3.yRot = tail2.yRot;
                tail2.xRot = Math.max(0.0f, (float)Math.sin((double)desiredTailRot - 1.5707963267948966) + 0.2f);
                tail3.xRot = tail2.xRot / 1.5f;
                tail.xRot = tail3.xRot - CSMath.toRadians(playerRotX) / 1.25f + 0.1f;
            }
            if (entity.getEatTimer() > 0.0f) {
                this.tongueVisible = true;
                ChameleonAnimations.EAT.animateAll(this.modelParts, CSMath.blend(0.5f, 0.0f, entity.getEatTimer() - Minecraft.getInstance().getTimer().getRealtimeDeltaTicks(), 0.0f, entity.getEatAnimLength()), true);
            } else {
                this.tongueVisible = false;
            }
            if (Minecraft.getInstance().isPaused()) {
                return Float.valueOf(prevAnimTime);
            }
            float playerXHead = 0.0f;
            Entity patt1$temp = entity.getVehicle();
            if (patt1$temp instanceof Player) {
                Player player = (Player)patt1$temp;
                playerXHead = CSMath.toRadians(player.getViewXRot(partialTick));
            }
            Vec3 vec3 = velocity = playerXHead != 0.0f ? entity.getVehicle().getDeltaMovement() : entity.getDeltaMovement();
            if (!this.chameleon.isTracking()) {
                float speed = (float)Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z);
                float tailSpeed = Math.min(0.1f, speed / 2.0f) + 0.01f;
                float deltaTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
                this.chameleon.tailPhase = (float)((double)this.chameleon.tailPhase + Math.PI * 2 * (double)deltaTime * (double)tailSpeed);
                float speedStraightFactor = 3.0f + speed * 100.0f;
                float tailRot1 = (float)Math.sin(this.chameleon.tailPhase - 0.0f) / speedStraightFactor;
                float tailRot2 = (float)Math.sin(this.chameleon.tailPhase - 1.0f) / speedStraightFactor;
                float tailRot3 = (float)Math.sin(this.chameleon.tailPhase - 2.0f) / speedStraightFactor;
                float tailRotation = 1.0f + Math.abs(tail.xRot - 0.2f) * 1.0f;
                tail.yRot = tailRot1 / tailRotation;
                tail2.yRot = tailRot2 / tailRotation;
                tail3.yRot = tailRot3 / tailRotation;
            }
            float playerYVel = (float)velocity.y;
            if (Double.isNaN(entity.xRotTail)) {
                entity.xRotTail = 0.0f;
            }
            float tailRot = entity.xRotTail = (float)((double)entity.xRotTail + (CSMath.clamp((double)playerYVel, -0.5, 0.5) - (double)entity.xRotTail) * (double)frameTime.floatValue() * 8.0);
            tailRot = (float)((double)tailRot * CSMath.clamp((double)Math.abs(tail.xRot + tail2.xRot + tail3.xRot + playerXHead) - 2.3, -1.0, 1.0));
            tail.xRot += tailRot;
            tail2.xRot += tailRot;
            tail3.xRot += tailRot;
            return animTime;
        });
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, color, false);
    }

    protected Iterable<ModelPart> headParts() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color, boolean isOverlay) {
        if (this.chameleon == null) {
            return;
        }
        float alpha = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float partialTick = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        long tickCount = this.chameleon.tickCount;
        long hurtTime = this.chameleon.getHurtTimestamp();
        if (!isOverlay && this.chameleon.isAlive()) {
            if (CSMath.betweenInclusive(tickCount - hurtTime, 0.0, 40.0) && hurtTime != 0L) {
                this.chameleon.opacity = CSMath.blend(alpha, alpha * 0.15f, (float)tickCount + partialTick - (float)hurtTime, 0.0f, 40.0f);
            } else if (this.chameleon.opacity < alpha) {
                this.chameleon.opacity = CSMath.blend(alpha * 0.15f, alpha, (float)tickCount + partialTick - (float)hurtTime, 120.0f, 180.0f);
            }
        }
        ModelPart tongue1 = this.modelParts.get("Tongue1");
        tongue1.visible = false;
        super.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.colorFromFloat((float)(isOverlay ? alpha : this.chameleon.opacity), (float)red, (float)green, (float)blue));
        if (this.tongueVisible && !isOverlay) {
            poseStack.pushPose();
            ModelPart jaw = this.modelParts.get("Jaw");
            VertexConsumer tongueConsumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.entityCutout((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_GREEN));
            tongue1.visible = true;
            poseStack.translate(0.0, 1.1555, -0.18755);
            tongue1.xRot = this.head.xRot + jaw.xRot / 2.0f;
            tongue1.yRot = this.head.yRot;
            tongue1.render(poseStack, tongueConsumer, packedLight, packedOverlay, FastColor.ARGB32.colorFromFloat((float)this.chameleon.opacity, (float)red, (float)green, (float)blue));
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
    }
}

