/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.fluid.SlushFluid;
import com.momosoftworks.coldsweat.data.tag.ModFluidTags;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.event.EventHooks;

public class SlushLiquidBlock
extends LiquidBlock {
    public SlushLiquidBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid.get(), properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canFreeze()) {
            entity.setIsInPowderSnow(true);
        }
        super.entityInside(state, level, pos, entity);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.shouldFreeze(level, pos, state)) {
            return;
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (this.shouldFreeze(level, pos, state)) {
            return;
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    private boolean shouldFreeze(Level level, BlockPos pos, BlockState state) {
        if (this.fluid.is(ModFluidTags.SLUSH)) {
            FluidState slushState = level.getFluidState(pos);
            for (Direction direction : POSSIBLE_FLOW_DIRECTIONS) {
                BlockPos neighborPos = pos.relative(direction);
                FluidState neighborFluid = level.getFluidState(neighborPos);
                if (!neighborFluid.is(FluidTags.WATER)) continue;
                if (direction == Direction.DOWN) {
                    Block resultBlock = Blocks.SNOW_BLOCK;
                    level.setBlockAndUpdate(pos.below(), EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos.below(), (BlockPos)pos, (BlockState)resultBlock.defaultBlockState()));
                    SlushFluid.fizz((LevelAccessor)level, pos);
                } else {
                    Block resultBlock = slushState.isSource() ? Blocks.ICE : Blocks.SNOW_BLOCK;
                    level.setBlockAndUpdate(pos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)resultBlock.defaultBlockState()));
                    SlushFluid.fizz((LevelAccessor)level, pos);
                }
                return true;
            }
        }
        return false;
    }
}

