/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class NicerEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> Component.translatable((String)"commands.forge.arguments.enum.invalid", (Object[])new Object[]{constants, found}));
    private final Class<T> enumClass;

    private NicerEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public static <T extends Enum<T>> NicerEnumArgument<T> enumArgument(Class<T> enumClass) {
        return new NicerEnumArgument<T>(enumClass);
    }

    public static <T extends Enum<T>> T getEnum(CommandContext<CommandSourceStack> context, String argument, Class<T> clazz) {
        return (T)((Enum)context.getArgument(argument, clazz));
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).toArray()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(en -> en.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(en -> en.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public static class Info<T extends Enum<T>>
    implements ArgumentTypeInfo<NicerEnumArgument<T>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeUtf(template.enumClass.getName());
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            try {
                String name = buffer.readUtf();
                return new Template(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("enum", template.enumClass.getName());
        }

        public Template unpack(NicerEnumArgument<T> argument) {
            return new Template(argument.enumClass);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<NicerEnumArgument<T>> {
            final Class<T> enumClass;

            Template(Class<T> enumClass) {
                this.enumClass = enumClass;
            }

            public NicerEnumArgument<T> instantiate(CommandBuildContext pContext) {
                return new NicerEnumArgument(this.enumClass);
            }

            public ArgumentTypeInfo<NicerEnumArgument<T>, ?> type() {
                return Info.this;
            }
        }
    }
}

