/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.api.util.placement.Matcher;
import com.momosoftworks.coldsweat.api.util.placement.Mode;
import com.momosoftworks.coldsweat.api.util.placement.Order;
import com.momosoftworks.coldsweat.api.util.placement.Placement;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.command.BaseCommand;
import com.momosoftworks.coldsweat.common.command.argument.NicerEnumArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempAttributeTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierArgument;
import com.momosoftworks.coldsweat.common.command.argument.TempModifierTraitArgument;
import com.momosoftworks.coldsweat.common.command.argument.TemperatureTraitArgument;
import com.momosoftworks.coldsweat.common.entity.data.Preference;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TempCommand
extends BaseCommand {
    public TempCommand(String name, int permissionLevel, boolean enabled) {
        super(name, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.literal((String)"set").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)-150, (int)150)).executes(source -> this.executeSetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"), Temperature.Trait.BODY)))))).then(Commands.literal((String)"add").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(source -> this.executeAddEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), IntegerArgumentType.getInteger((CommandContext)source, (String)"amount"), Temperature.Trait.BODY)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"get").then(((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(source -> this.executeGetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), Temperature.Trait.BODY))).then(Commands.argument((String)"trait", (ArgumentType)TemperatureTraitArgument.temperatureGet()).executes(source -> this.executeGetEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TemperatureTraitArgument.getTemperature((CommandContext<CommandSourceStack>)source, "trait")))))).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(source -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)source, (String)"pos");
            return this.executeGetWorldTemp((CommandSourceStack)source.getSource(), pos.getX(), pos.getY(), pos.getZ(), null);
        })).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(source -> this.executeGetWorldTemp((CommandSourceStack)source.getSource(), IntegerArgumentType.getInteger((CommandContext)source, (String)"x"), IntegerArgumentType.getInteger((CommandContext)source, (String)"y"), IntegerArgumentType.getInteger((CommandContext)source, (String)"z"), DimensionArgument.getDimension((CommandContext)source, (String)"dimension"))))))).then(Commands.literal((String)"debug").then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"type", (ArgumentType)TempModifierTraitArgument.modifier()).executes(source -> this.executeDebugModifiers((CommandSourceStack)source.getSource(), EntityArgument.getEntity((CommandContext)source, (String)"entity"), TempModifierTraitArgument.getModifier((CommandContext<CommandSourceStack>)source, "type"))))))).then(Commands.literal((String)"attribute").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").then(Commands.argument((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).executes(source -> this.executeClearModifier((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"))))).executes(source -> this.executeClearAllModifiers((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"))))).then(Commands.argument((String)"operation", NicerEnumArgument.enumArgument(AttributeModifier.Operation.class)).then(Commands.argument((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), NicerEnumArgument.getEnum((CommandContext<CommandSourceStack>)source, "operation", AttributeModifier.Operation.class), BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), NicerEnumArgument.getEnum((CommandContext<CommandSourceStack>)source, "operation", AttributeModifier.Operation.class), false)))))).then(Commands.literal((String)"set").then(Commands.argument((String)"type", (ArgumentType)TempAttributeTraitArgument.attribute()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"permanent", (ArgumentType)BoolArgumentType.bool()).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, BoolArgumentType.getBool((CommandContext)source, (String)"permanent"))))).executes(source -> this.executeModifyEntityTemp((CommandSourceStack)source.getSource(), EntityArgument.getEntities((CommandContext)source, (String)"entities"), TempAttributeTraitArgument.getAttribute((CommandContext<CommandSourceStack>)source, "type"), DoubleArgumentType.getDouble((CommandContext)source, (String)"amount"), null, false)))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"modifier").then(Commands.literal((String)"add").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"trait", (ArgumentType)TempModifierTraitArgument.modifier()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"modifier", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(((LiteralArgumentBuilder)Commands.literal((String)"infinite").executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"tickRate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"nbt", (ArgumentType)NbtTagArgument.nbtTag()).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.argument((String)"mode", NicerEnumArgument.enumArgument(Mode.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.argument((String)"order", NicerEnumArgument.enumArgument(Order.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.argument((String)"match", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(Commands.argument((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)))))).executes(this::executeAddModifier))).executes(this::executeAddModifier)))).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"tickRate", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"nbt", (ArgumentType)NbtTagArgument.nbtTag()).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"mode", NicerEnumArgument.enumArgument(Mode.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.argument((String)"order", NicerEnumArgument.enumArgument(Order.class)).executes(this::executeAddModifier)).then(((RequiredArgumentBuilder)Commands.argument((String)"match", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeAddModifier)).then(Commands.argument((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeAddModifier))))).executes(this::executeAddModifier))).executes(this::executeAddModifier))).executes(this::executeAddModifier)))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"trait", (ArgumentType)TempModifierTraitArgument.modifier()).then(((RequiredArgumentBuilder)Commands.argument((String)"modifier", (ArgumentType)TempModifierArgument.modifier()).executes(this::executeRemoveModifier)).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(this::executeRemoveModifier)))))));
    }

    private <T> T readArgumentOrDefault(CommandContext<CommandSourceStack> context, String name, BiFunction<CommandContext<CommandSourceStack>, String, T> getter, T defaultValue) {
        T result;
        try {
            result = getter.apply(context, name);
            if (result == null) {
                result = defaultValue;
            }
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        return result;
    }

    private <T> T readArgumentOrDefault(CommandContext<CommandSourceStack> context, String name, Class<T> clazz, T defaultValue) {
        Object result;
        try {
            result = context.getArgument(name, clazz);
            if (result == null) {
                result = defaultValue;
            }
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        return (T)result;
    }

    private int executeSetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, double temp, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            Temperature.set(living, trait == Temperature.Trait.BODY ? Temperature.Trait.CORE : trait, temp);
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.getPlayer(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        String string = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
        double convertedTemp = Temperature.convertIfNeeded(temp, trait, preferredUnits);
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.set.single.result", (Object[])new Object[]{trait.getSerializedName(), target.getName().getString(), CSMath.truncate(convertedTemp, 1) + unitsName}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.set.many.result", (Object[])new Object[]{trait.getSerializedName(), entities.size(), CSMath.truncate(convertedTemp, 1) + unitsName}), true);
        }
        return entities.size();
    }

    private int executeAddEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, double temp, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            Temperature.add(living, trait == Temperature.Trait.BODY ? Temperature.Trait.CORE : trait, temp);
        }
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.getPlayer(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        String string = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
        double convertedTemp = Temperature.convertIfNeeded(temp, trait, preferredUnits);
        if (entities.size() == 1) {
            Entity target = entities.iterator().next();
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.set.single.result", (Object[])new Object[]{trait.getSerializedName(), target.getName().getString(), CSMath.truncate(convertedTemp, 1) + unitsName}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.set.many.result", (Object[])new Object[]{trait.getSerializedName(), entities.size(), CSMath.truncate(convertedTemp, 1) + unitsName}), true);
        }
        return entities.size();
    }

    private int executeGetEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait trait) {
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        for (Entity target : entities.stream().sorted(Comparator.comparing(player -> player.getName().getString())).toList()) {
            Temperature.Units preferredUnits = CSMath.getIfNotNull(source.getPlayer(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
            double temp = CSMath.truncate(Temperature.convertIfNeeded(Temperature.get((LivingEntity)target, trait), trait, preferredUnits), 2);
            String unitsName = trait.isForWorld() ? " " + preferredUnits.getFormattedName() : "";
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.get.result", (Object[])new Object[]{target.getName().getString(), trait.getSerializedName(), temp + unitsName}), false);
        }
        return entities.size();
    }

    private int executeGetWorldTemp(CommandSourceStack source, int x, int y, int z, ServerLevel level) {
        Temperature.Units units = CSMath.getIfNotNull(source.getPlayer(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        int worldTemp = (int)Temperature.convert(WorldHelper.getTemperatureAt((Level)(level != null ? level : source.getLevel()), new BlockPos(x, y, z)), Temperature.Units.MC, units, true);
        source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.get.world.result", (Object[])new Object[]{x, y, z, worldTemp, units.getFormattedName()}), true);
        return 1;
    }

    private int executeAddModifier(CommandContext<CommandSourceStack> context) {
        Collection entities = this.readArgumentOrDefault(context, "entities", (CommandContext<CommandSourceStack> src, String str) -> {
            try {
                return EntityArgument.getEntities((CommandContext)src, (String)str);
            }
            catch (Exception ignored) {
                return List.of();
            }
        }, List.of());
        Temperature.Trait trait = this.readArgumentOrDefault(context, "trait", TempModifierTraitArgument::getModifier, Temperature.Trait.BODY);
        ResourceLocation modifierId = this.readArgumentOrDefault(context, "modifier", TempModifierArgument::getModifier, null);
        int duration = this.readArgumentOrDefault(context, "duration", IntegerArgumentType::getInteger, Integer.valueOf(-1));
        int tickRate = this.readArgumentOrDefault(context, "tickRate", IntegerArgumentType::getInteger, Integer.valueOf(1));
        CompoundTag nbt = this.readArgumentOrDefault(context, "nbt", NbtTagArgument::getNbtTag, new CompoundTag());
        Mode mode = this.readArgumentOrDefault(context, "mode", Mode.class, Mode.ADD_AFTER);
        Order order = this.readArgumentOrDefault(context, "order", Order.class, Order.LAST);
        ResourceLocation otherId = this.readArgumentOrDefault(context, "match", ResourceLocation.class, null);
        int maxCount = this.readArgumentOrDefault(context, "maxCount", IntegerArgumentType::getInteger, Integer.valueOf(1));
        return this.executeAddModifier(context, entities, trait, modifierId, duration, tickRate, nbt, mode, order, otherId, maxCount);
    }

    private int executeAddModifier(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, Temperature.Trait trait, ResourceLocation modifierId, int duration, int tickRate, CompoundTag nbt, Mode mode, Order order, ResourceLocation otherId, int maxCount) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        Optional<TempModifier> modifierOpt = TempModifierRegistry.getValue(modifierId);
        if (modifierOpt.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temp_modifier.invalid"));
            return 0;
        }
        TempModifier modifier = modifierOpt.get();
        ((TempModifier)modifier.expires(duration)).tickRate(tickRate);
        modifier.getNBT().merge(nbt);
        Placement placement = Placement.of(mode, order, mod -> otherId == null || TempModifierRegistry.getKey(mod).equals((Object)otherId)).limitDuplicates(Matcher.SAME_CLASS, maxCount);
        for (Entity entity2 : entities) {
            Temperature.addModifier((LivingEntity)entity2, modifier, trait, placement);
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temp_modifier.single.add.result", (Object[])new Object[]{modifierId.toString(), ((Entity)entities.iterator().next()).getName().getString()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temp_modifier.many.add.result", (Object[])new Object[]{modifierId.toString(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeRemoveModifier(CommandContext<CommandSourceStack> context) {
        Collection entities = this.readArgumentOrDefault(context, "entities", (CommandContext<CommandSourceStack> src, String str) -> {
            try {
                return EntityArgument.getEntities((CommandContext)src, (String)str);
            }
            catch (Exception ignored) {
                return List.of();
            }
        }, List.of());
        Temperature.Trait trait = this.readArgumentOrDefault(context, "trait", TempModifierTraitArgument::getModifier, Temperature.Trait.BODY);
        ResourceLocation modifierId = this.readArgumentOrDefault(context, "modifier", TempModifierArgument::getModifier, null);
        int count = this.readArgumentOrDefault(context, "count", IntegerArgumentType::getInteger, Integer.valueOf(Integer.MAX_VALUE));
        return this.executeRemoveModifier(context, entities, trait, modifierId, count);
    }

    private int executeRemoveModifier(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, Temperature.Trait trait, ResourceLocation modifierId, int count) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (entities.stream().anyMatch(entity -> !(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity))) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (TempModifierRegistry.getValue(modifierId).isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temp_modifier.invalid", (Object[])new Object[]{modifierId.toString()}));
            return 0;
        }
        for (Entity entity2 : entities) {
            Temperature.removeModifiers((LivingEntity)entity2, trait, count, Order.FIRST, mod -> TempModifierRegistry.getKey(mod).equals((Object)modifierId));
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temp_modifier.single.remove.result", (Object[])new Object[]{modifierId.toString(), ((Entity)entities.iterator().next()).getName().getString()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temp_modifier.many.remove.result", (Object[])new Object[]{modifierId.toString(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeDebugModifiers(CommandSourceStack source, Entity entity, Temperature.Trait trait) {
        if (!(entity instanceof Player) && !EntityTempManager.isTemperatureEnabled(entity)) {
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        LivingEntity living = (LivingEntity)entity;
        AttributeInstance attribute = trait.isForAttributes() ? EntityTempManager.getAttribute(trait, living) : null;
        Temperature.Units preferredUnits = CSMath.getIfNotNull(source.getPlayer(), player -> Preference.getOrDefault((Player)player, Preference.UNITS, Temperature.Units.F), Temperature.Units.F);
        double lastValue = trait == Temperature.Trait.BURNING_POINT ? ConfigSettings.MAX_TEMP.get() : (trait == Temperature.Trait.FREEZING_POINT ? ConfigSettings.MIN_TEMP.get() : 0.0);
        source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.debug", (Object[])new Object[]{living.getDisplayName(), trait.getSerializedName()}).withStyle(ChatFormatting.WHITE), false);
        if (attribute != null && CSMath.safeDouble(attribute.getBaseValue()).isPresent()) {
            source.sendSuccess(() -> Component.literal((String)BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)attribute.getAttribute().value())).toString()).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" \u2192 ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)("" + attribute.getValue())).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withHoverEvent(TempCommand.getConvertedUnitHover(trait, attribute.getValue(), preferredUnits)))), false);
            lastValue = attribute.getBaseValue();
        } else {
            for (TempModifier modifier : Temperature.getModifiers(living, trait)) {
                double lastInput = modifier.getLastInput(trait);
                double lastOutput = modifier.getLastOutput(trait);
                source.sendSuccess(() -> Component.empty().append((Component)Component.literal((String)("" + CSMath.truncate(lastInput, 2))).withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withHoverEvent(TempCommand.getConvertedUnitHover(trait, lastInput, preferredUnits)))).append((Component)Component.literal((String)" \u2192 ").withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withHoverEvent(null))).append((Component)Component.literal((String)modifier.toString()).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)" \u2192 ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)("" + CSMath.truncate(lastOutput, 2))).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withHoverEvent(TempCommand.getConvertedUnitHover(trait, lastOutput, preferredUnits)))), false);
                lastValue = lastOutput;
            }
        }
        if (attribute != null) {
            double newBase = lastValue;
            for (AttributeModifier modifier : attribute.getModifiers().stream().filter(mod -> mod.operation() == AttributeModifier.Operation.ADD_VALUE).toList()) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newBase += modifier.amount(), trait, preferredUnits);
            }
            double newValue = newBase;
            for (AttributeModifier modifier : attribute.getModifiers().stream().filter(mod -> mod.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toList()) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue += newBase * modifier.amount(), trait, preferredUnits);
            }
            for (AttributeModifier modifier : attribute.getModifiers().stream().filter(mod -> mod.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).toList()) {
                TempCommand.printAttributeModifierLine(source, modifier, lastValue, newValue *= 1.0 + modifier.amount(), trait, preferredUnits);
            }
        }
        return 1;
    }

    static void printAttributeModifierLine(CommandSourceStack source, AttributeModifier modifier, double lastValueStore, double newValueStore, Temperature.Trait trait, Temperature.Units preferredUnits) {
        source.sendSuccess(() -> Component.literal((String)("" + CSMath.truncate(lastValueStore, 2))).withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withHoverEvent(TempCommand.getConvertedUnitHover(trait, lastValueStore, preferredUnits))).append((Component)Component.literal((String)" \u2192 ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)modifier.id().toString()).withStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)modifier.id().toString()).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"chat.copy.click").withStyle(ChatFormatting.GRAY)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, modifier.id().toString())))).append((Component)Component.literal((String)" \u2192 ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)("" + CSMath.truncate(newValueStore, 2))).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withHoverEvent(TempCommand.getConvertedUnitHover(trait, newValueStore, preferredUnits)))), false);
    }

    static double getFormattedTraitValue(Temperature.Trait trait, double rawValue, Temperature.Units units) {
        double converted;
        block3: {
            converted = rawValue;
            switch (trait) {
                case WORLD: 
                case FREEZING_POINT: 
                case BURNING_POINT: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            converted = Temperature.convert(converted, Temperature.Units.MC, units, true);
        }
        return converted;
    }

    static HoverEvent getConvertedUnitHover(Temperature.Trait trait, double value, Temperature.Units units) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)(CSMath.truncate(TempCommand.getFormattedTraitValue(trait, value, units), 1) + " " + units.getFormattedName())));
    }

    private int executeModifyEntityTemp(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute, double amount, AttributeModifier.Operation operation, boolean permanent) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                if (instance == null) continue;
                if (operation != null) {
                    AttributeModifier modifier = EntityTempManager.makeAttributeModifier(attribute, amount, operation);
                    instance.addPermanentModifier(modifier);
                } else {
                    EntityTempManager.getAttribute(attribute, living).setBaseValue(amount);
                }
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    if (permanent) {
                        cap.markPersistentAttribute((Attribute)instance.getAttribute().value());
                    }
                });
                continue;
            }
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            if (operation == null) {
                source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.modify.set.single.result", (Object[])new Object[]{attribute.getSerializedName(), ((Entity)entities.iterator().next()).getName().getString(), amount}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.modify.add_modifier.single.result", (Object[])new Object[]{attribute.getSerializedName(), ((Entity)entities.iterator().next()).getName().getString()}), true);
            }
        } else if (operation == null) {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.modify.set.many.result", (Object[])new Object[]{attribute.getSerializedName(), entities.size(), amount}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.modify.add_modifier.many.result", (Object[])new Object[]{attribute.getSerializedName(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearModifier(CommandSourceStack source, Collection<? extends Entity> entities, Temperature.Trait attribute) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                    if (instance != null) {
                        instance.removeModifiers();
                        EntityTempManager.getAttribute(attribute, living).setBaseValue(Double.NaN);
                        cap.clearPersistentAttribute((Attribute)instance.getAttribute().value());
                    }
                });
                continue;
            }
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.clear.single.result", (Object[])new Object[]{attribute.getSerializedName(), ((Entity)entities.iterator().next()).getName().getString()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.clear.many.result", (Object[])new Object[]{attribute.getSerializedName(), entities.size()}), true);
        }
        return entities.size();
    }

    private int executeClearAllModifiers(CommandSourceStack source, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            if (EntityTempManager.isTemperatureEnabled(entity) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                EntityTempManager.getTemperatureCap(entity).ifPresent(cap -> {
                    for (Temperature.Trait attribute : EntityTempManager.VALID_ATTRIBUTE_TRAITS) {
                        AttributeInstance instance = EntityTempManager.getAttribute(attribute, living);
                        if (instance == null) continue;
                        instance.removeModifiers();
                        instance.setBaseValue(((Attribute)instance.getAttribute().value()).getDefaultValue());
                        cap.clearPersistentAttribute((Attribute)instance.getAttribute().value());
                    }
                });
                continue;
            }
            source.sendFailure((Component)Component.translatable((String)"commands.cold_sweat.temperature.invalid"));
            return 0;
        }
        if (entities.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.clear.all.single.result", (Object[])new Object[]{((Entity)entities.iterator().next()).getName().getString()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.cold_sweat.temperature.clear.all.many.result", (Object[])new Object[]{entities.size()}), true);
        }
        return entities.size();
    }
}

