/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goals.EatObjectsGoal;
import com.momosoftworks.coldsweat.common.entity.goals.LazyLookGoal;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.ModEntities;
import com.momosoftworks.coldsweat.core.init.ModItems;
import com.momosoftworks.coldsweat.core.init.ModSounds;
import com.momosoftworks.coldsweat.core.network.message.ChameleonEatMessage;
import com.momosoftworks.coldsweat.core.network.message.EntityMountMessage;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.data.tag.ModEntityTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class Chameleon
extends Animal {
    static final EntityDataAccessor<Integer> SHED_TIME = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<Integer> LAST_SHED = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<Integer> HURT_TIMESTAMP = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<CompoundTag> TRUSTED_PLAYERS = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    static final EntityDataAccessor<BlockPos> TRACKING_POS = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    static final EntityDataAccessor<Integer> EAT_TIMESTAMP = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<Float> TEMPERATURE = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    static final EntityDataAccessor<CompoundTag> EDIBLE_COOLDOWNS = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    static final EntityDataAccessor<Boolean> SEARCHING = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Integer> AGE_SECS = SynchedEntityData.defineId(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public float xRotHead = 0.0f;
    public float yRotHead = 0.0f;
    public float xRotLeftEye = 0.0f;
    public float yRotLeftEye = 0.0f;
    public float xRotRightEye = 0.0f;
    public float yRotRightEye = 0.0f;
    public float xRotTail = 0.0f;
    public float tailPhase = 0.0f;
    float eatAnimationTimer = 0.0f;
    private int feedCooldown = 0;
    public float opacity = 1.0f;
    float desiredTemp = 1.0f;
    boolean mountSneaking = false;
    int mountSneakCount = 0;
    int lastMountSneak = 0;

    public Chameleon(EntityType<Chameleon> type, Level Level2) {
        super(type, Level2);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new EatObjectsGoal(this, ModEntityTags.CHAMELEON_EATS));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> ChameleonEdibles.EDIBLES.stream().anyMatch(edible -> stack.is(edible.associatedItems())), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new LazyLookGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.16).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHED_TIME, (Object)0);
        builder.define(LAST_SHED, (Object)0);
        builder.define(HURT_TIMESTAMP, (Object)0);
        builder.define(TRUSTED_PLAYERS, (Object)new CompoundTag());
        builder.define(TRACKING_POS, (Object)BlockPos.ZERO);
        builder.define(EAT_TIMESTAMP, (Object)0);
        builder.define(TEMPERATURE, (Object)Float.valueOf((float)CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get())));
        builder.define(EDIBLE_COOLDOWNS, (Object)new CompoundTag());
        builder.define(SEARCHING, (Object)false);
        builder.define(AGE_SECS, (Object)0);
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Entity entity = this.getVehicle();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DamageSources damageSources = player.level().damageSources();
            if (source.equals(damageSources.inWall()) || source.equals(damageSources.fall())) {
                return true;
            }
            return player.isCreative() || player.isInvulnerableTo(source);
        }
        return super.isInvulnerableTo(source);
    }

    public void die(DamageSource source) {
        super.die(source);
        if (this.dead) {
            this.getCombatTracker().recordDamage(source, 1.0f);
            Component deathMessage = this.getCombatTracker().getDeathMessage();
            ListTag trustedPlayers = this.getTrustedPlayers().getList("Players", 8);
            if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES)) {
                trustedPlayers.forEach(string -> {
                    Player player = this.level().getPlayerByUUID(UUID.fromString(string.getAsString()));
                    if (player != null) {
                        player.sendSystemMessage(deathMessage);
                    }
                });
            }
        }
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!ConfigSettings.CHAMELEON_SHED_AUTOMATICALLY.get().booleanValue() && Chameleon.makeShed((LivingEntity)this)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Edible edible = ChameleonEdibles.getEdible(stack).orElse(null);
        if (edible != null) {
            if (this.feedCooldown <= 0 && this.isPlayerTrusted(player) ^ this.isTamingItem(stack) && this.getCooldown(edible) <= 0 || this.canFallInLove() && this.isFood(stack)) {
                if (!player.level().isClientSide) {
                    ItemStack dropStack = stack.copy();
                    dropStack.setCount(1);
                    ItemEntity dropped = player.drop(dropStack, true);
                    if (dropped != null) {
                        dropped.getPersistentData().putUUID("Recipient", this.getUUID());
                    }
                    player.stopUsingItem();
                    this.usePlayerItem(player, hand, stack);
                }
                this.feedCooldown = 10;
                return InteractionResult.SUCCESS;
            }
            player.swing(hand);
            return InteractionResult.CONSUME;
        }
        if (this.isPlayerTrusted(player) && player.getPassengers().isEmpty() && !this.level().isClientSide) {
            if (this.startRiding((Entity)player) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((CustomPacketPayload)new EntityMountMessage(this.getId(), player.getId(), EntityMountMessage.Action.MOUNT));
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean makeShed(LivingEntity entity) {
        Chameleon chameleon;
        if (entity instanceof Chameleon && (chameleon = (Chameleon)entity).isShedding() && chameleon.canShed()) {
            chameleon.shedItems();
            chameleon.setLastShed(chameleon.getAgeTicks());
            chameleon.setShedTime(-1);
            return true;
        }
        return false;
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(ModItemTags.CHAMELEON_TAMING);
    }

    public boolean canFallInLove() {
        return super.canFallInLove() && !this.isBaby() && !this.isInLove() && !this.getPersistentData().getBoolean("HasBred");
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby()) {
            this.shedItems();
        }
    }

    private void shedItems() {
        for (ItemStack stack : ModLootTables.getEntityDropsLootTable((Entity)this, null, ModLootTables.CHAMELEON_SHEDDING)) {
            WorldHelper.entityDropItem((Entity)this, stack, 40000);
        }
        WorldHelper.playEntitySound((SoundEvent)ModSounds.CHAMELEON_SHED.value(), (Entity)this, this.getSoundSource(), 1.0f, this.getVoicePitch());
    }

    @SubscribeEvent
    public static void setHeight(EntityEvent.Size event) {
        Chameleon chameleon;
        Entity entity;
        if (event.getEntity().isAddedToLevel() && (entity = event.getEntity()) instanceof Chameleon && (chameleon = (Chameleon)entity).isBaby()) {
            event.setNewSize(EntityDimensions.fixed((float)0.65f, (float)0.5f).withEyeHeight(0.25f));
        }
    }

    @SubscribeEvent
    public static void onHitFromOwner(LivingIncomingDamageEvent event) {
        Chameleon chameleon;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Chameleon && (chameleon = (Chameleon)livingEntity).getVehicle() != null && chameleon.getVehicle() == event.getSource().getEntity()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelProjectileHit(ProjectileImpactEvent event) {
        Chameleon chameleon;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult hitResult2 = (EntityHitResult)hitResult;
        Entity entity = hitResult2.getEntity();
        if (entity instanceof Chameleon && (chameleon = (Chameleon)entity).getVehicle() instanceof Player) {
            event.setCanceled(true);
            chameleon.setHurtTimestamp(chameleon.tickCount - 20);
        }
    }

    public int getTimeToShed() {
        return 600;
    }

    public int getEatAnimLength() {
        return 6;
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob parent) {
        return (AgeableMob)((EntityType)ModEntities.CHAMELEON.get()).create((Level)level);
    }

    public void spawnChildFromBreeding(ServerLevel level, Animal mate) {
        super.spawnChildFromBreeding(level, mate);
        this.getPersistentData().putBoolean("HasBred", true);
        mate.getPersistentData().putBoolean("HasBred", true);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.CHAMELEON_AMBIENT.value();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return (SoundEvent)ModSounds.CHAMELEON_HURT.value();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.CHAMELEON_DEATH.value();
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (!this.level().isClientSide && soundevent != null && !this.isSearching()) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.getSoundSource(), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    protected void playHurtSound(@NotNull DamageSource damageSource) {
        SoundEvent soundevent = this.getHurtSound(damageSource);
        if (soundevent != null) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.getSoundSource(), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean isWalking() {
        return (double)new Vec2((float)this.getDeltaMovement().x, (float)this.getDeltaMovement().z).length() > 0.005;
    }

    public int getHeadRotSpeed() {
        return 20;
    }

    public void tick() {
        super.tick();
        if (this.eatAnimationTimer > 0.0f) {
            this.eatAnimationTimer -= 1.0f;
        }
        if (this.feedCooldown > 0) {
            --this.feedCooldown;
        }
        if (!this.level().isClientSide && this.tickCount % 20 == 0) {
            this.setAgeSecs(this.getAgeSecs() + 1);
        }
        if (!this.level().isClientSide) {
            int shedCheckInterval = ConfigSettings.SHED_TIMINGS.get().interval();
            int shedCooldown = ConfigSettings.SHED_TIMINGS.get().cooldown();
            double shedChance = ConfigSettings.SHED_TIMINGS.get().chance();
            int shedTime = this.getShedTime();
            if (this.tickCount % shedCheckInterval == 0 && shedTime < 0 && this.random.nextDouble() < shedChance && this.getAgeTicks() - this.getLastShed() > shedCooldown) {
                this.setShedTime(0);
            }
            if (shedTime > -1 && shedTime < this.getTimeToShed()) {
                this.setShedTime(shedTime + 1);
            }
            if (shedTime == this.getTimeToShed()) {
                this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            }
            if (ConfigSettings.CHAMELEON_SHED_AUTOMATICALLY.get().booleanValue() && this.canShed()) {
                Chameleon.makeShed((LivingEntity)this);
            }
        } else if (this.random.nextDouble() < 0.2 && this.canShed()) {
            WorldHelper.spawnParticle(this.level(), (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, ModItems.CHAMELEON_MOLT.toStack()), this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.01, 0.05, 0.01);
        }
        Entity shedCooldown = this.getVehicle();
        if (shedCooldown instanceof Player) {
            Player player = (Player)shedCooldown;
            float playerHeadYaw = player.yHeadRot;
            this.yHeadRot = CSMath.clamp(this.yHeadRot, playerHeadYaw - 50.0f, playerHeadYaw + 50.0f);
            this.yBodyRot = playerHeadYaw;
        }
        if (this.tickCount % 20 == 0 || this.tickCount == 1) {
            this.desiredTemp = (float)CSMath.clamp(Temperature.get((LivingEntity)this, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
        }
        this.setTemperature(this.getTemperature() + (this.desiredTemp - this.getTemperature()) * 0.03f);
        Entity playerHeadYaw = this.getVehicle();
        if (playerHeadYaw instanceof Player) {
            Player player = (Player)playerHeadYaw;
            if (!this.level().isClientSide) {
                if (player.isCrouching()) {
                    if (!this.mountSneaking) {
                        this.mountSneakCount = player.tickCount - this.lastMountSneak < 8 || this.mountSneakCount == 0 ? ++this.mountSneakCount : 0;
                        this.lastMountSneak = player.tickCount;
                        this.mountSneaking = true;
                        if (this.mountSneakCount >= 2) {
                            this.stopRiding();
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                serverPlayer.connection.send((CustomPacketPayload)new EntityMountMessage(this.getId(), player.getId(), EntityMountMessage.Action.DISMOUNT));
                            }
                            this.boardingCooldown = 10;
                            this.mountSneakCount = 0;
                        }
                    }
                } else {
                    this.mountSneaking = false;
                }
            }
        }
        if (this.tickCount % 5 == 0 && this.isTracking()) {
            if (this.random.nextDouble() < 0.3) {
                WorldHelper.spawnParticle(this.level(), (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX() + Math.random() - 0.5, this.getY() + Math.random() - 0.5 + (double)(this.getBbHeight() / 2.0f), this.getZ() + Math.random() - 0.5, 0.01, 0.01, 0.01);
            }
            if (this.tickCount % 20 == 0) {
                if ((long)this.getAgeTicks() - this.getEatTimestamp() > 6000L) {
                    this.clearTrackingPos();
                }
                if ((Math.sqrt(Math.pow(this.getX() - (double)this.getTrackingPos().getX(), 2.0) + Math.pow(this.getZ() - (double)this.getTrackingPos().getZ(), 2.0)) < 20.0 || this.getTrackingPos().equals((Object)BlockPos.ZERO)) && this.getServer() != null) {
                    AdvancementHolder advancement = this.getServer().getAdvancements().get(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"chameleon_find_biome"));
                    for (ServerPlayer player : this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(20.0))) {
                        if (advancement == null || player.getAdvancements().getOrStartProgress(advancement).isDone()) continue;
                        player.getAdvancements().award(advancement, "requirement");
                    }
                    this.clearTrackingPos();
                }
            }
        }
        if (!this.level().isClientSide) {
            CompoundTag cooldowns = this.getCooldowns();
            for (String tag : cooldowns.getAllKeys()) {
                int time = cooldowns.getInt(tag);
                if (time <= 0) continue;
                cooldowns.putInt(tag, time - 1);
            }
            this.entityData.set(EDIBLE_COOLDOWNS, (Object)cooldowns);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && !this.isInvulnerableTo(source)) {
            this.setHurtTimestamp(this.tickCount);
        }
        return super.hurt(source, amount);
    }

    @Nullable
    public Entity changeDimension(DimensionTransition teleportData) {
        this.clearTrackingPos();
        return super.changeDimension(teleportData);
    }

    public void onEatEntity(Entity entity) {
        if (!this.level().isClientSide) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack item = itemEntity.getItem();
                if (this.isTamingItem(item)) {
                    Player player;
                    Player player2 = player = itemEntity.getOwner() != null ? this.level().getPlayerByUUID(itemEntity.getOwner().getUUID()) : null;
                    if (player != null) {
                        if (!this.isPlayerTrusted(player)) {
                            if (player.isCreative() || Math.random() < 0.3) {
                                this.setPersistenceRequired();
                                this.addTrustedPlayer(itemEntity.getOwner().getUUID());
                                WorldHelper.spawnParticleBatch(this.level(), (ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 0.5, this.getZ(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            } else {
                                WorldHelper.spawnParticleBatch(this.level(), (ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            }
                        } else if (this.canFallInLove()) {
                            this.setInLove(player);
                        }
                    }
                }
                ChameleonEdibles.getEdible(item).ifPresent(edible -> {
                    if (edible.onEaten(this, itemEntity) == Edible.Result.SUCCESS) {
                        this.setCooldown((Edible)edible, edible.getCooldown());
                    } else {
                        this.setCooldown((Edible)edible, edible.getCooldown() / 4);
                    }
                });
            }
            this.setEatTimestamp(this.getAgeTicks());
        }
    }

    public static boolean canSpawn(EntityType<Chameleon> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    public int getMaxHeadYRot() {
        return 60;
    }

    public void eatAnimation() {
        if (this.eatAnimationTimer <= 0.0f) {
            if (!this.level().isClientSide) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ChameleonEatMessage(this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                AnimationManager.ANIMATION_TIMERS.put((Entity)this, Float.valueOf(0.0f));
            }
            this.eatAnimationTimer = this.getEatAnimLength();
        }
    }

    public float getEatTimer() {
        return this.eatAnimationTimer;
    }

    public int getShedTime() {
        return (Integer)this.entityData.get(SHED_TIME);
    }

    public void setShedTime(int shedTime) {
        this.entityData.set(SHED_TIME, (Object)shedTime);
    }

    public boolean isShedding() {
        return this.getShedTime() >= 0;
    }

    public boolean canShed() {
        return this.getShedTime() >= this.getTimeToShed();
    }

    public CompoundTag getTrustedPlayers() {
        return (CompoundTag)this.entityData.get(TRUSTED_PLAYERS);
    }

    public void addTrustedPlayer(UUID player) {
        StringTag uuid;
        CompoundTag trustedPlayers = this.getTrustedPlayers();
        ListTag players = trustedPlayers.getList("Players", 8);
        if (!players.contains((Object)(uuid = StringTag.valueOf((String)player.toString())))) {
            players.add((Object)uuid);
        }
        trustedPlayers.put("Players", (Tag)players);
        this.entityData.set(TRUSTED_PLAYERS, (Object)trustedPlayers, true);
    }

    public void removeTrustedPlayer(UUID player) {
        CompoundTag trustedPlayers = this.getTrustedPlayers();
        trustedPlayers.getList("Players", 8).removeIf(tag -> tag.getAsString().equals(player.toString()));
        this.entityData.set(TRUSTED_PLAYERS, (Object)trustedPlayers);
    }

    public boolean isPlayerTrusted(Player player) {
        return this.isPlayerTrusted(player.getUUID());
    }

    public boolean isPlayerTrusted(UUID player) {
        return this.getTrustedPlayers().getList("Players", 8).contains((Object)StringTag.valueOf((String)player.toString()));
    }

    public int getLastShed() {
        return (Integer)this.entityData.get(LAST_SHED);
    }

    public void setLastShed(int lastShed) {
        this.entityData.set(LAST_SHED, (Object)lastShed);
    }

    public float getTemperature() {
        return ((Float)this.entityData.get(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.entityData.set(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public void setSearching(boolean searching) {
        this.entityData.set(SEARCHING, (Object)searching);
    }

    public boolean isSearching() {
        return (Boolean)this.entityData.get(SEARCHING);
    }

    public int getHurtTimestamp() {
        return (Integer)this.entityData.get(HURT_TIMESTAMP);
    }

    public void setHurtTimestamp(int hurtTimestamp) {
        this.entityData.set(HURT_TIMESTAMP, (Object)hurtTimestamp);
    }

    public void setTrackingPos(BlockPos pos) {
        this.entityData.set(TRACKING_POS, (Object)pos);
    }

    public void clearTrackingPos() {
        this.entityData.set(TRACKING_POS, (Object)BlockPos.ZERO);
    }

    public BlockPos getTrackingPos() {
        return (BlockPos)this.entityData.get(TRACKING_POS);
    }

    public boolean isTracking() {
        return !((BlockPos)this.entityData.get(TRACKING_POS)).equals((Object)BlockPos.ZERO);
    }

    public long getEatTimestamp() {
        return ((Integer)this.entityData.get(EAT_TIMESTAMP)).intValue();
    }

    public void setEatTimestamp(int eatTimestamp) {
        this.entityData.set(EAT_TIMESTAMP, (Object)eatTimestamp);
    }

    public void setCooldown(Edible edible, Integer time) {
        CompoundTag map = (CompoundTag)this.entityData.get(EDIBLE_COOLDOWNS);
        map.putInt(edible.associatedItems().location().toString(), time.intValue());
        this.entityData.set(EDIBLE_COOLDOWNS, (Object)map);
    }

    public Integer getCooldown(Edible edible) {
        return ((CompoundTag)this.entityData.get(EDIBLE_COOLDOWNS)).getInt(edible.getName());
    }

    public CompoundTag getCooldowns() {
        return (CompoundTag)this.entityData.get(EDIBLE_COOLDOWNS);
    }

    public int getAgeSecs() {
        return (Integer)this.entityData.get(AGE_SECS);
    }

    public int getAgeTicks() {
        return this.getAgeSecs() * 20;
    }

    public void setAgeSecs(int ageSecs) {
        this.entityData.set(AGE_SECS, (Object)ageSecs);
    }

    public boolean isTamingItem(ItemStack item) {
        return item.is(ModItemTags.CHAMELEON_TAMING);
    }

    public CompoundTag saveWithoutId(CompoundTag tag) {
        super.saveWithoutId(tag);
        tag.put("TrustedPlayers", Objects.requireNonNullElseGet(this.getTrustedPlayers().get("Players"), ListTag::new));
        tag.putInt("LastShed", this.getLastShed());
        tag.putInt("ShedTime", this.getShedTime());
        tag.putInt("HurtTimestamp", this.getHurtTimestamp());
        tag.putInt("AgeInSeconds", this.getAgeSecs());
        tag.putLong("EatTimestamp", this.getEatTimestamp());
        if (this.isTracking()) {
            tag.putLong("TrackingPos", this.getTrackingPos().asLong());
        } else {
            tag.remove("TrackingPos");
        }
        ListTag edibleCooldowns = new ListTag();
        for (String key : this.getCooldowns().getAllKeys()) {
            CompoundTag cooldownTag = new CompoundTag();
            cooldownTag.putString("Edible", key);
            cooldownTag.putInt("Cooldown", this.getCooldowns().getInt(key));
            edibleCooldowns.add((Object)cooldownTag);
        }
        tag.put("EdibleCooldowns", (Tag)edibleCooldowns);
        tag.putFloat("Temperature", this.getTemperature());
        return tag;
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        CompoundTag players = new CompoundTag();
        players.put("Players", Objects.requireNonNullElseGet(nbt.get("TrustedPlayers"), ListTag::new));
        this.entityData.set(TRUSTED_PLAYERS, (Object)players, true);
        this.setLastShed(nbt.getInt("LastShed"));
        this.setShedTime(nbt.getInt("ShedTime"));
        this.setHurtTimestamp(nbt.getInt("HurtTimestamp"));
        this.setAgeSecs(nbt.getInt("AgeInSeconds"));
        this.setEatTimestamp(nbt.getInt("EatTimestamp"));
        if (nbt.contains("TrackingPos")) {
            this.setTrackingPos(BlockPos.of((long)nbt.getLong("TrackingPos")));
        }
        ListTag edibleCooldowns = nbt.getList("EdibleCooldowns", 10);
        for (int i = 0; i < edibleCooldowns.size(); ++i) {
            CompoundTag cooldownTag = edibleCooldowns.getCompound(i);
            ChameleonEdibles.EDIBLES.stream().filter(ed -> ed.getName().equals(cooldownTag.getString("Item"))).findFirst().ifPresent(edible -> this.setCooldown((Edible)edible, cooldownTag.getInt("Cooldown")));
        }
        this.setTemperature(nbt.getFloat("Temperature"));
        this.desiredTemp = this.getTemperature();
    }
}

