/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class IceBreakingEvents {
    @SubscribeEvent
    public static void onIceBreak(BlockEvent.BreakEvent event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        BlockState state = event.getState();
        LevelAccessor ilevel = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState belowState = ilevel.getBlockState(pos.below());
        if (state.is(Blocks.ICE) && !event.getPlayer().getMainHandItem().isCorrectToolForDrops(state) && EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_ICE_MELTING) && !player.getAbilities().instabuild && (belowState.blocksMotion() || belowState.liquid()) && !ilevel.dimensionType().ultraWarm()) {
            ilevel.setBlock(pos, IceBlock.meltsInto(), 3);
        }
    }

    @SubscribeEvent
    public static void onIceMining(PlayerEvent.BreakSpeed event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getState();
        Player player = event.getEntity();
        ItemStack tool = player.getMainHandItem();
        float speed = event.getNewSpeed();
        if (IceBreakingEvents.isModifiableIceBlock(state) && !player.getMainHandItem().isCorrectToolForDrops(state)) {
            if (tool.canPerformAction(ItemAbilities.PICKAXE_DIG)) {
                event.setNewSpeed(speed * 2.0f);
            } else {
                event.setNewSpeed(speed * 3.0f);
            }
        }
        if (state.is(Blocks.PACKED_ICE)) {
            event.setNewSpeed(event.getNewSpeed() / 3.0f);
        }
    }

    @SubscribeEvent
    public static void iceHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getTargetBlock();
        Player player = event.getEntity();
        ItemStack tool = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (IceBreakingEvents.isModifiableIceBlock(state)) {
            event.setCanHarvest(tool.canPerformAction(ItemAbilities.PICKAXE_DIG) && event.getEntity().getMainHandItem().isCorrectToolForDrops(state));
        }
    }

    public static boolean isModifiableIceBlock(BlockState state) {
        return state.is(Blocks.ICE) || state.is(Blocks.PACKED_ICE) || state.is(Blocks.BLUE_ICE);
    }

    public static ResourceLocation getLootTableForIce(BlockState state) {
        if (state.is(Blocks.ICE)) {
            return ModLootTables.CUSTOM_ICE_DROP;
        }
        if (state.is(Blocks.PACKED_ICE)) {
            return ModLootTables.CUSTOM_PACKED_ICE_DROP;
        }
        if (state.is(Blocks.BLUE_ICE)) {
            return ModLootTables.CUSTOM_BLUE_ICE_DROP;
        }
        return null;
    }
}

